/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.LinearFog;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Box;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;
import org.xith3d.utility.interpolate.DistanceInterpolater;

@Xith3DTest.Description(fulltext={"This is a simple benchmark, which shows a rotating tube made of multiple", "cuboids."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CuboidTubeBenchmark
extends Xith3DTest {
    private static final int NUM_CUBOIDS = 400;
    private static final long FADE_TIME = 5000000L;
    private List<Cuboid> cuboids;
    private Canvas3D canvas;
    private FadingColor lightColor = new FadingColor();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        super.onRenderLoopStopped(gameTime, timingMode, averageFPS);
        System.out.println("Rendered frames: " + this.getIterationsCount());
        System.out.println("Average FPS: " + averageFPS);
        System.out.println("Triangles in the scene: " + this.canvas.getPeer().getTriangles());
    }

    private static final float rndFloat(Random rnd, float min, float max) {
        return rnd.nextFloat() * (max - min) + min;
    }

    private void createSceneGraph(SceneGraph sg) {
        Node.pushGlobalIgnoreBounds(true);
        BranchGroup root = new BranchGroup();
        PointLight light = new PointLight((Colorf)this.lightColor, (Tuple3f)new Point3f(0.0f, 0.0f, -5.0f), 0.01f);
        root.addChild(light);
        LinearFog fog = new LinearFog(Colorf.BLACK, 1.0f, 100.0f);
        root.addChild(fog);
        Random rnd = new Random(System.nanoTime());
        this.cuboids = new ArrayList<Cuboid>(400);
        for (int i = 0; i < 400; ++i) {
            Cuboid c = new Cuboid(rnd);
            this.cuboids.add(c);
            c.attach(root);
        }
        RenderPass renderPass = sg.addPerspectiveBranch(root);
        renderPass.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        Node.popGlobalIgnoreBounds();
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        this.lightColor.update(micros);
        for (int i = 0; i < this.cuboids.size(); ++i) {
            Cuboid c = this.cuboids.get(i);
            c.update(micros);
            if (!c.isAged()) continue;
            c.reset(micros);
        }
    }

    public CuboidTubeBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Canvas3D canvas;
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        this.canvas = canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.BLACK);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        CuboidTubeBenchmark test = new CuboidTubeBenchmark(CuboidTubeBenchmark.parseCommandLine(args));
        test.begin();
    }

    private class FadingColor
    extends Colorf {
        private static final long serialVersionUID = 1L;
        private long t0;
        private int corner;

        public void update(long gameTime) {
            switch (this.corner) {
                case 0: {
                    float f = (float)(gameTime - this.t0) / 5000000.0f;
                    if (f < 1.0f) {
                        this.set(1.0f - f, f, 0.0f);
                        break;
                    }
                    this.set(0.0f, 1.0f, 0.0f);
                    this.t0 = gameTime;
                    this.corner = 1;
                    break;
                }
                case 1: {
                    float f = (float)(gameTime - this.t0) / 5000000.0f;
                    if (f < 1.0f) {
                        this.set(0.0f, 1.0f - f, f);
                        break;
                    }
                    this.set(0.0f, 0.0f, 1.0f);
                    this.t0 = gameTime;
                    this.corner = 2;
                    break;
                }
                case 2: {
                    float f = (float)(gameTime - this.t0) / 5000000.0f;
                    if (f < 1.0f) {
                        this.set(f, 0.0f, 1.0f - f);
                        break;
                    }
                    this.set(1.0f, 0.0f, 0.0f);
                    this.t0 = gameTime;
                    this.corner = 0;
                    break;
                }
            }
        }

        public FadingColor() {
            super(1.0f, 0.0f, 0.0f);
            this.t0 = 0L;
            this.corner = 0;
        }
    }

    private static class Cuboid {
        private static final float[] discreteLevels = new float[]{10.0f, 12.0f, 14.0f};
        private float width;
        private float height;
        private float depth;
        private float lastDepthPos;
        public Box shape;
        public TransformGroup transGroup;
        public AngleInterpolater angleInter;
        public DistanceInterpolater distanceInter;
        private static Material mat = null;

        public void update(long gameMicros) {
            float angle = this.angleInter.getValue(gameMicros);
            float depth = this.distanceInter.getValue(gameMicros);
            Transform3D t3d = this.transGroup.getTransform();
            t3d.rotZ(angle);
            t3d.setTranslation(0.0f, 0.0f, depth);
            this.lastDepthPos = depth;
            this.transGroup.setTransform(t3d);
        }

        public boolean isAged() {
            return this.lastDepthPos - this.depth / 2.0f > 0.0f;
        }

        public void reset(long gameMicros) {
            this.distanceInter.stop();
            this.distanceInter.setValue(-100.0f);
            this.distanceInter.startIncreasing(gameMicros);
        }

        public void attach(GroupNode parentGroup) {
            this.transGroup.addChild(this.shape);
            parentGroup.addChild(this.transGroup);
        }

        private static Material getMat() {
            if (mat == null) {
                mat = new Material();
                mat.setEmissiveColor(Colorf.GRAY20);
                mat.setDiffuseColor(Colorf.WHITE);
                mat.setSpecularColor(Colorf.BLACK);
                mat.setLightingEnabled(true);
            }
            return mat;
        }

        private static final Box createBox(float width, float height, float depth, int level) {
            Box box = new Box(height, width, depth, 9, false, 2);
            box.getGeometry().setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
            box.getAppearance(true).setTexture(TextureLoader.getInstance().getTexture("stone.jpg"));
            box.getAppearance(true).setMaterial(Cuboid.getMat());
            StaticTransform.translate(box, discreteLevels[level], 0.0f, 0.0f);
            return box;
        }

        public Cuboid(Random rnd) {
            this.width = CuboidTubeBenchmark.rndFloat(rnd, 1.0f, 3.0f);
            this.height = CuboidTubeBenchmark.rndFloat(rnd, 0.1f, 0.3f);
            this.depth = CuboidTubeBenchmark.rndFloat(rnd, 5.0f, 8.0f);
            this.shape = Cuboid.createBox(this.width, this.height, this.depth, rnd.nextInt(3));
            this.transGroup = new TransformGroup();
            this.angleInter = new AngleInterpolater(rnd.nextFloat() * ((float)Math.PI * 2), rnd.nextFloat() * 1.0f - 0.5f, 0.0f, (float)Math.PI * 2, true);
            this.distanceInter = new DistanceInterpolater(rnd.nextFloat() * -100.0f, rnd.nextFloat() * 10.0f, -3.4028235E38f, Float.MAX_VALUE);
            this.angleInter.startIncreasing(0L);
            this.distanceInter.startIncreasing(0L);
        }
    }
}

