/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.primitives.GeometryType;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Compares different geometry types."}, authors={"Marvin Froehlich (aka Qudus)"})
public class GeomTypeBenchmark
extends Xith3DTest {
    private Switch geomSwitch;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                int whichChild = (this.geomSwitch.getWhichChild() + 1) % this.geomSwitch.numChildren();
                this.geomSwitch.setWhichChild(whichChild);
                Shape3D shape = (Shape3D)this.geomSwitch.getChild(whichChild);
                System.out.println("Rendering a " + shape.getGeometry().getClass().getSimpleName());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private static Sphere createSphere() {
        Sphere sphere = new Sphere(2.5f, 64, 64, 1, false, 0);
        return sphere;
    }

    private BranchGroup createSceneGraph() {
        BranchGroup scene = new BranchGroup();
        this.geomSwitch = new Switch(-3);
        Sphere.setGeometryConstructionTypeHint(GeometryType.TRIANGLE_ARRAY);
        Sphere s0 = GeomTypeBenchmark.createSphere();
        s0.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        System.out.println((Object)((Object)Sphere.getGeometryConstructionTypeHint()) + ": " + s0.getGeometry().getVertexCount());
        this.geomSwitch.addChild(s0);
        Sphere.setGeometryConstructionTypeHint(GeometryType.INDEXED_TRIANGLE_ARRAY);
        Sphere s1 = GeomTypeBenchmark.createSphere();
        s1.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        System.out.println((Object)((Object)Sphere.getGeometryConstructionTypeHint()) + ": " + s1.getGeometry().getVertexCount());
        this.geomSwitch.addChild(s1);
        Sphere.setGeometryConstructionTypeHint(GeometryType.TRIANGLE_STRIP_ARRAY);
        Sphere s2 = GeomTypeBenchmark.createSphere();
        s2.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        System.out.println((Object)((Object)Sphere.getGeometryConstructionTypeHint()) + ": " + s2.getGeometry().getVertexCount());
        this.geomSwitch.addChild(s2);
        Sphere.setGeometryConstructionTypeHint(GeometryType.INDEXED_TRIANGLE_STRIP_ARRAY);
        Sphere s3 = GeomTypeBenchmark.createSphere();
        s3.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        System.out.println((Object)((Object)Sphere.getGeometryConstructionTypeHint()) + ": " + s3.getGeometry().getVertexCount());
        this.geomSwitch.addChild(s3);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        rg.addChild(this.geomSwitch);
        this.getAnimator().addAnimatableObject(rg);
        scene.addChild(rg);
        this.geomSwitch.setWhichChild(0);
        Shape3D shape = (Shape3D)this.geomSwitch.getChild(this.geomSwitch.getWhichChild());
        System.out.println("Rendering a " + shape.getGeometry().getClass().getSimpleName());
        return scene;
    }

    public GeomTypeBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        BranchGroup rootBranch = this.createSceneGraph();
        env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setWireframeMode(true);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static final void main(String[] args) throws Throwable {
        GeomTypeBenchmark test = new GeomTypeBenchmark(GeomTypeBenchmark.parseCommandLine(args));
        test.begin();
    }
}

