/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.FastMath;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"This benchmark doesn't actually render anything,", "but runs different operations on list implementations"}, authors={"Joe LaFata (aka qbproger)"})
public class ListSpeedBenchmark
extends Xith3DTest {
    private static final int NUM_LOOPS = 10;
    private static final int[] lengths = new int[]{100, 1000, 10000, 100000};
    private static final int[] values = new int[(int)((double)lengths[3] * 1.5) + 1];
    private static final NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private static String getAverageTime(long t0) {
        double dt = (double)(System.nanoTime() - t0) / 1.0E9;
        double avg = dt / 10.0;
        return format.format(avg);
    }

    private void generateList1(ArrayList<Integer> list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                list.add(values[j]);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "generateList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void generateList2(Vector<Integer> list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                list.add(values[j]);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "generateList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private Integer[] generateList3(int length) {
        Integer[] list = new Integer[16];
        int size = 0;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                list = ArrayUtils.ensureCapacity(list, size + 1);
                list[size++] = values[j];
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "generateList()", length, ListSpeedBenchmark.getAverageTime(t0));
        return list;
    }

    private int[] generateList4(int length) {
        int[] list = new int[16];
        int size = 0;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                list = ArrayUtils.ensureCapacity(list, size + 1);
                list[size++] = values[j];
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "generateList()", length, ListSpeedBenchmark.getAverageTime(t0));
        return list;
    }

    private void containList1(ArrayList<Integer> list, int length) {
        int length0 = length;
        int offset = length / 2;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            length = 100;
            for (int j = 0; j < length; ++j) {
                list.contains(values[offset + j]);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "containList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void containList2(Vector<Integer> list, int length) {
        int length0 = length;
        int offset = length / 2;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            length = 100;
            for (int j = 0; j < length; ++j) {
                list.contains(values[offset + j]);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "containList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void containList3(Integer[] list, int length) {
        int length0 = length;
        int offset = length / 2;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            length = 100;
            for (int j = 0; j < length; ++j) {
                ArrayUtils.contains(list, 0, length - 1, values[offset + j], false);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "containList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void containList4(int[] list, int length) {
        int length0 = length;
        int offset = length / 2;
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            length = 100;
            for (int j = 0; j < length; ++j) {
                ArrayUtils.contains(list, 0, length - 1, values[offset + j]);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "containList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void getList1(ArrayList<Integer> list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                Integer tmp = list.get(j);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "getList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void getList2(Vector<Integer> list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                Integer tmp = list.get(j);
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "getList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void getList3(Integer[] list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                Integer tmp = list[j];
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "getList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private void getList4(int[] list, int length) {
        long t0 = System.nanoTime();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < length; ++j) {
                int tmp = list[j];
            }
        }
        System.out.printf("%-10s %-15s (%-6d): %-16s seconds.%n", list.getClass().getSimpleName(), "getList()", length, ListSpeedBenchmark.getAverageTime(t0));
    }

    private static void fillValuePool() {
        for (int i = 0; i < values.length; ++i) {
            ListSpeedBenchmark.values[i] = FastMath.randomInt();
        }
    }

    private void runBenchmark() {
        ListSpeedBenchmark.fillValuePool();
        for (int i = 0; i < lengths.length; ++i) {
            ArrayList<Integer> list1 = new ArrayList<Integer>();
            this.generateList1(list1, lengths[i]);
            this.containList1(list1, lengths[i]);
            this.getList1(list1, lengths[i]);
        }
        this.end();
    }

    @Override
    public void begin(RenderLoop.RunMode runMode, UpdatingThread.TimingMode timingMode) {
        this.runBenchmark();
    }

    public ListSpeedBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
    }

    public static void main(String[] args) throws Throwable {
        ListSpeedBenchmark test = new ListSpeedBenchmark(ListSpeedBenchmark.parseCommandLine(args));
        test.begin();
    }

    static {
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(10);
    }
}

