/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import java.awt.geom.Rectangle2D;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.primitives.DrawRectangle;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This benchmark compares the render performance of the", "standard ButtonWidget and a dynamically texture-rendered one."}, authors={"Marvin Froehlich (aka Qudus)"})
public class NewWidgetsBenchmark
extends Xith3DTest {
    private static final Button.Description buttonDesc = HUD.getTheme().getButtonDescription();

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Rectangle createButton(float left, float top, float width, float height, final String text) {
        DrawRectangle rect = new DrawRectangle(width, height, true);
        Texture2DCanvas texCanvas = rect.getTextureCanvas();
        texCanvas.addDrawCallback(new Texture2DCanvas.DrawCallback2D(){

            public void drawTexture(Texture2DCanvas texCanvas, int texWidth, int texHeight) {
                texCanvas.beginUpdateRegionComplete();
                TextureImage2D ic = texCanvas.getImage();
                texCanvas.setAntialiazingEnabled(false);
                ic.clear(true, null);
                TextureImage2D btex = buttonDesc.getTextureNormal().getImage0();
                int srcOrgW = btex.getOriginalWidth();
                int srcOrgH = btex.getOriginalHeight();
                int srcBottomH = buttonDesc.getBottomHeight();
                int srcRightW = buttonDesc.getRightWidth();
                int srcTopH = buttonDesc.getTopHeight();
                int srcLeftW = buttonDesc.getLeftWidth();
                int srcRightLeft = srcOrgW - srcRightW;
                int srcBottomTop = srcOrgH - srcBottomH;
                int trgRightLeft = texWidth - srcRightW;
                int trgBottomTop = texHeight - srcBottomH;
                int srcBodyWidth = srcOrgW - srcLeftW - srcRightW;
                ic.drawImage(btex, 0, srcBottomTop, srcLeftW, srcBottomH, 0, trgBottomTop, true, null);
                ic.drawImage(btex, srcRightLeft, srcBottomTop, srcRightW, srcBottomH, trgRightLeft, trgBottomTop, true, null);
                ic.drawImage(btex, srcRightLeft, 0, srcRightW, srcTopH, trgRightLeft, 0, true, null);
                ic.drawImage(btex, 0, 0, srcLeftW, srcTopH, 0, 0, true, null);
                ic.drawImage(btex, srcLeftW, srcBottomTop, srcOrgW - srcLeftW - srcRightW, srcBottomH, srcLeftW, trgBottomTop, texWidth - srcLeftW - srcRightW, srcBottomH, true, null);
                ic.drawImage(btex, srcRightLeft, srcTopH, srcRightW, srcOrgH - srcTopH - srcBottomH, trgRightLeft, srcTopH, srcRightW, texHeight - srcTopH - srcBottomH, true, null);
                ic.drawImage(btex, srcLeftW, 0, srcOrgW - srcLeftW - srcRightW, srcTopH, srcLeftW, 0, texWidth - srcLeftW - srcRightW, srcTopH, true, null);
                ic.drawImage(btex, 0, srcTopH, srcLeftW, srcOrgH - srcTopH - srcBottomH, 0, srcTopH, srcLeftW, texHeight - srcTopH - srcBottomH, true, null);
                ic.drawImage(btex, srcLeftW, srcTopH, srcBodyWidth, srcOrgH - srcTopH - srcBottomH, srcLeftW, srcTopH, texWidth - srcLeftW - srcRightW, texHeight - srcTopH - srcBottomH, true, null);
                texCanvas.setAntialiazingEnabled(true);
                Rectangle2D bounds = texCanvas.getFontMetrics().getStringBounds(text, null);
                texCanvas.setColor(Colorf.BLACK);
                texCanvas.drawString(text, texWidth / 2 - (int)(bounds.getWidth() / 2.0), texHeight / 2 + (int)(bounds.getHeight() / 3.0));
                texCanvas.setAntialiazingEnabled(false);
                texCanvas.finishUpdateRegion();
            }
        });
        StaticTransform.translate(rect, left, -top, 0.0f);
        return rect;
    }

    private void createWithHUD(Sized2iRO canvasRes, int numX, int numY, SceneGraph sceneGraph) throws Exception {
        HUD hud = new HUD(canvasRes, 800.0f);
        float x = 10.0f;
        float y = 10.0f;
        for (int j = 0; j < numY; ++j) {
            x = 10.0f;
            for (int i = 0; i < numX; ++i) {
                hud.getContentPane().addWidget(new Button(100.0f, 25.0f, "Don't click me!", buttonDesc), x, y);
                x += 110.0f;
            }
            y += 35.0f;
        }
        sceneGraph.addHUD(hud);
    }

    private void createPlain(int numX, int numY, SceneGraph sceneGraph) throws Exception {
        RenderPass renderPass = RenderPass.create2D(800, 600);
        BranchGroup scene = renderPass.getBranchGroup();
        float x = 10.0f;
        float y = 10.0f;
        for (int j = 0; j < numY; ++j) {
            x = 10.0f;
            for (int i = 0; i < numX; ++i) {
                scene.addChild(this.createButton(x, y, 100.0f, 25.0f, "Don't click me!"));
                x += 110.0f;
            }
            y += 35.0f;
        }
        sceneGraph.addRenderPass(renderPass);
    }

    private void createSceneGraph(SceneGraph sceneGraph) throws Exception {
        int numX = 7;
        int numY = 17;
        this.createPlain(7, 17, sceneGraph);
    }

    public NewWidgetsBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        NewWidgetsBenchmark test = new NewWidgetsBenchmark(NewWidgetsBenchmark.parseCommandLine(args));
        test.begin();
    }
}

