/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import java.io.IOException;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.jagatoo.loaders.models.bsp.BSPPrototypeLoader;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BSPTreeGroup;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.camera.flight.CameraFlight;
import org.xith3d.utility.camera.flight.CameraFlightListener;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"In this benchmark a CameraFlight through a Quake3 map is tested."}, authors={"Marvin Froehlich (aka Qudus)"})
public class Q3FlightBenchmark
extends Xith3DTest
implements CameraFlightListener {
    private BSPClusterManager clusterManager;
    protected View view;
    protected FirstPersonInputHandler fpHandler;
    private CameraFlight camFlight = null;
    private SceneGraph sceneGraph;
    private HUD hud;

    protected void exit() {
        super.exit();
    }

    private void startFlight() {
        if (this.hud != null) {
            this.sceneGraph.removeHUD(this.hud);
        }
        try {
            this.fpHandler.setSuspended(true);
            long t0 = System.currentTimeMillis();
            this.camFlight = new CameraFlight(ResourceLocator.getInstance().getResource("pdmq3duel5/inter_engine_benchmark--2006-09-29.cflt"));
            this.camFlight.addCameraFlightListener(this);
            this.camFlight.start(this.getGameMicroTime() + (System.currentTimeMillis() - t0));
            System.out.println("CameraFlight started.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopFlight() {
        this.camFlight = null;
        this.fpHandler.updateViewInverse();
        this.fpHandler.setSuspended(false);
        if (this.hud != null) {
            this.sceneGraph.addHUD(this.hud);
        }
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F4: {
                if (this.clusterManager == null) break;
                this.clusterManager.setPVSUsage(!this.clusterManager.isPVSUsed());
                System.out.println("PVS: " + (this.clusterManager.isPVSUsed() ? "on" : "off"));
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
            }
        }
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F10: 
            case SPACE: {
                if (this.camFlight == null) {
                    this.startFlight();
                    break;
                }
                this.stopFlight();
                break;
            }
            case ESCAPE: {
                System.out.println("average FPS: " + (float)this.getIterationsCount() / this.getTimingMode().getSecondsAsFloat(this.getGameTime()));
                this.end();
            }
        }
    }

    public void onCameraFlightEnded(long frames, long millis, float averageFPS) {
        System.out.println("CameraFlight ended. (average FPS: " + averageFPS + ")");
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.camFlight != null) {
            this.camFlight.updateCamera(this.view, gameTime, timingMode);
        }
        super.prepareNextFrame(gameTime, frameTime, timingMode);
    }

    private HUD createHUD(SceneGraph sg, Sized2iRO resolution) {
        this.hud = new HUD(resolution.getWidth(), resolution.getHeight(), 800.0f, 600.0f);
        Label hint2 = new Label(this.hud.getResX(), this.hud.getResY(), "Hit \"Y\" to invert the mouse y-axis.", HUDFont.getFont("Verdana", HUDFont.BOLD, 18), Colorf.WHITE, TextAlignment.BOTTOM_LEFT);
        hint2.setPadding(40, 10, 10, 10);
        this.hud.getContentPane().addWidget(hint2);
        Label hint1 = new Label(this.hud.getResX(), this.hud.getResY(), "Hit \"SPACE\" to start the flight, ESC to exit.", HUDFont.getFont("Verdana", HUDFont.BOLD, 18), Colorf.WHITE, TextAlignment.BOTTOM_LEFT);
        hint1.setPadding(10);
        this.hud.getContentPane().addWidget(hint1);
        sg.addHUD(this.hud);
        return this.hud;
    }

    protected Model loadLevel() throws Exception {
        ResourceLocator resLoc = ResourceLocator.getInstance();
        BSPPrototypeLoader.loadNormals = false;
        Model scene = ModelLoader.getInstance().loadModel(resLoc.getResource("pdmq3duel5/pdmq3duel5.bsp"));
        if (scene.getMainGroup() instanceof BSPTreeGroup) {
            this.clusterManager = (BSPClusterManager)((BSPTreeGroup)scene.getMainGroup()).getBSPVisibilityUpdater();
        }
        return scene;
    }

    protected RenderPass createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution) throws Exception {
        RenderPass rp = env.addPerspectiveBranch(new BranchGroup((Node)this.loadLevel()));
        rp.getConfig().setFrontClipDistance(0.1f);
        rp.getConfig().setBackClipDistance(2000.0f);
        rp.setClipperEnabled(false);
        rp.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        this.sceneGraph = env;
        this.createHUD(env, resolution);
        return rp;
    }

    public Q3FlightBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(2.0f, 2.5f, -4.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.view = env.getView();
        ResourceLocator.setSingletonInstance(TestUtils.createResourceLocator().getSubLocator("levels/quake3/"));
        this.createSceneGraph(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.disableLighting();
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.fpHandler = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
        System.out.println("Hit \"Y\" to invert the mouse y-axis. Hit ESC to exit.");
    }

    public static void main(String[] args) throws Throwable {
        Q3FlightBenchmark test = new Q3FlightBenchmark(Q3FlightBenchmark.parseCommandLine(args));
        test.begin();
    }
}

