/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.BackgroundImage;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This benchmark doesn't actually render anything,", "but simply loads a texture multiple times."}, authors={"Marvin Froehlich (aka Qudus)"})
public class TextureLoadingBenchmark
extends Xith3DTest {
    private static final int NUM_LOOPS = 50;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Texture loadTexture(String texName) throws Exception {
        TextureLoader tl = TextureLoader.getInstance();
        Texture2D texture = null;
        for (int i = 0; i < 50; ++i) {
            texture = tl.getTexture(texName);
        }
        return texture;
    }

    private static final float getTime(long nanos) {
        return (float)nanos / 1.0E9f;
    }

    private void createSceneGraph(Sized2iRO canvasRes, SceneGraph sceneGraph) throws Exception {
        TextureLoader tl = TextureLoader.getInstance();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        tl.getCache().setEnabled(false);
        long t0 = System.nanoTime();
        Texture texture = this.loadTexture("stone.tga");
        long t1 = System.nanoTime();
        System.out.println("loading-time for 50 loads: " + TextureLoadingBenchmark.getTime(t1 - t0) + " seconds.");
        BackgroundImage bgImage = new BackgroundImage(texture, canvasRes.getAspect());
        sceneGraph.addRenderPass(bgImage);
    }

    public TextureLoadingBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.createSceneGraph(arguments.getResolution(), env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        TextureLoadingBenchmark test = new TextureLoadingBenchmark(TextureLoadingBenchmark.parseCommandLine(args));
        test.begin();
    }
}

