/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.demos.utils.ClothFactory;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Very cool cloth simulation."}, authors={"Abdul Bezrati (aka JavaCoolDude)", "kukanani", "Marvin Froehlich (aka Qudus)"})
public class ClothSimulation
extends Xith3DTest {
    private ClothFactory clothFactory;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case C: {
                this.clothFactory.switchFillWire();
                break;
            }
            case SPACE: {
                this.clothFactory.resetCloth();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void prepareLighting(BranchGroup scene) {
        BoundingSphere lightBounds = new BoundingSphere(0.0f, 0.0f, 0.0f, 2000.0f);
        AmbientLight ambientLight = new AmbientLight(Colorf.DARK_GRAY);
        ambientLight.setInfluencingBounds(lightBounds);
        Vector3f lightDirection1 = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight directedLight1 = new DirectionalLight(Colorf.WHITE, lightDirection1);
        directedLight1.setInfluencingBounds(lightBounds);
        Vector3f lightDirection2 = new Vector3f(1.0f, 1.0f, 1.0f);
        DirectionalLight directedLight2 = new DirectionalLight(Colorf.WHITE, lightDirection2);
        directedLight2.setInfluencingBounds(lightBounds);
        Vector3f lightDirection3 = new Vector3f(-1.0f, -1.0f, -1.0f);
        PointLight pointLight1 = new PointLight(Colorf.WHITE, (Tuple3f)lightDirection3, 0.001f);
        pointLight1.setInfluencingBounds(lightBounds);
        Vector3f lightDirection4 = new Vector3f(1.0f, 1.0f, 1.0f);
        PointLight pointLight2 = new PointLight(Colorf.WHITE, (Tuple3f)lightDirection4, 0.002f);
        pointLight2.setInfluencingBounds(lightBounds);
        scene.addChild(ambientLight);
        scene.addChild(directedLight1);
        scene.addChild(directedLight2);
        scene.addChild(pointLight1);
        scene.addChild(pointLight2);
    }

    public void createSceneGraph(SceneGraph sg) {
        BranchGroup scene = new BranchGroup();
        this.prepareLighting(scene);
        this.clothFactory = new ClothFactory("wood.jpg", "flag.jpg");
        scene.addChild(new DirectionalLight(true, Colorf.WHITE, new Vector3f(-1.0f, -2.0f, -1.0f)));
        scene.addChild(this.clothFactory.getSphere(32));
        scene.addChild(this.clothFactory.getGround());
        scene.addChild(this.clothFactory.getCloth());
        sg.addPerspectiveBranch(scene);
        this.addUpdatable(this.clothFactory);
    }

    public ClothSimulation(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(20.0f, 30.0f, 20.0f, 0.0f, 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.BLACK);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = new FirstPersonInputHandler((Transformable)env.getView(), canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 3.0f);
        fpih.getBindingsManager().createDefaultBindings();
        fpih.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        ClothSimulation test = new ClothSimulation(ClothSimulation.parseCommandLine(args));
        test.begin();
    }
}

