/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.demos.utils.phong.SceneManager;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Very cool phong lighting simulation."}, authors={"Abdul Bezrati (aka JavaCoolDude)", "Marvin Froehlich (aka Qudus)"})
public class PhongLighting
extends Xith3DTest {
    private SceneManager manager;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.manager.setSceneState();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph(View view) throws Exception {
        BranchGroup scene = new BranchGroup();
        this.manager = new SceneManager(view);
        this.manager.loadParticleSystem(300, 0, "light.png", view);
        this.manager.loadModel("chaliceJCD.jcd", "chalicebase.png", "chalicedot3.jpg", "white.png", new Point3f(0.2f, 0.2f, 0.2f), new Point3f(1.0f, 1.0f, 1.0f), 1.5f, 32, -150.0f, -50.0f, 75.0f);
        this.manager.loadModel("torusJCD.jcd", "torusbase.jpg", "torusdot3.png", "white.png", new Point3f(0.1f, 0.1f, 0.1f), new Point3f(1.0f, 1.0f, 1.0f), 2.0f, 16, 150.0f, -50.0f, 75.0f);
        this.manager.loadModel("sphereJCD.jcd", "spherebase.jpg", "spheredot3.jpg", "white.png", new Point3f(0.1f, 0.1f, 0.1f), new Point3f(1.0f, 1.0f, 1.0f), 1.5f, 16, 0.0f, -50.0f, -150.0f);
        this.manager.loadLight();
        this.manager.loadRoom(600.0f, 300.0f, 600.0f, 0.0f, 0.0f, 0.0f);
        scene.addChild(this.manager.getSceneGroup());
        this.addUpdatable(this.manager);
        return scene;
    }

    public PhongLighting(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 85.0f, 280.0f, 0.0f, -0.5f, -1.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator().getSubLocator("phong/");
        resLoc.useAsSingletonInstance();
        resLoc.createAndAddTSL();
        env.addPerspectiveBranch(this.createSceneGraph(env.getView()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.BLACK);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = new FirstPersonInputHandler((Transformable)env.getView(), canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 30.0f);
        fpih.getBindingsManager().createDefaultBindings();
        fpih.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        PhongLighting test = new PhongLighting(PhongLighting.parseCommandLine(args));
        test.begin();
    }
}

