/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos;

import java.awt.Font;
import java.util.Date;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ForegroundRenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.text2d.Text2D;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This class demonstrates the advanced use of Text2D."}, authors={"Florian Hofmann"})
public class Text2DDemo
extends Xith3DTest {
    private static final String hv_align = "|\n|\n|\n|\n               | horizontal and\n                 | vertical aligned\n                  | text             \n|\n-----------------|-----------------\n|\n|\n|\n|\n|\n|\n|\n|";
    private static final String colored = "##################################################################\n##################################################################\n##################################################################\n##################################################################\n################################################################\n##################################################################\n#################################################################\n################# P S Y C H O D E L I C ###########################\n######################## C O L O R E D ###############################\n############################ T E X T ############################\n##################################################################\n##################################################################\n#################################################################\n##################################################################\n#################################################################\n##################################################################\n#################################################################\n##################################################################";
    private Xith3DEnvironment env = new Xith3DEnvironment(this);
    private Text2D text = null;
    private TransformGroup scale = null;
    private Transform3D scale3D = null;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void coloredText(int seconds) {
        this.text.setText(colored);
        seconds *= 1000;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)seconds) {
            this.text.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.env.render();
        }
    }

    private void renderSeconds(int seconds) {
        seconds *= 1000;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)seconds) {
            this.env.render();
        }
    }

    private void outro() {
        this.text.setText("for more information visit\n \nhttp://xith.org");
        this.text.setColor(1.0f, 1.0f, 1.0f);
    }

    private void morphOnce(float i_max) {
        float i = 0.0f;
        float i_step = 0.01f;
        while (i < i_max) {
            this.scale3D.setScale(FastMath.pow(i += i_step, 2.0f));
            this.scale.setTransform(this.scale3D);
            float color = 1.0f - i / i_max;
            if (color < 0.2f) {
                color = 0.2f;
            }
            this.text.setColor(color, color, color);
            this.env.render();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        this.scale3D.setScale(1.0f);
        this.scale.setTransform(this.scale3D);
    }

    private void dynamicText(int seconds) {
        seconds *= 1000;
        long start = System.currentTimeMillis();
        Date date = new Date();
        while (System.currentTimeMillis() - start < (long)seconds) {
            date.setTime(System.currentTimeMillis());
            this.text.setColor(1.0f, 1.0f, 1.0f);
            this.text.setText("Dynamic Text:\n(with an effective caching algorithm)\n \nThe date is now:\n" + date);
            this.env.render();
        }
    }

    private void demo() {
        this.text.setText("Hello Xith3D!");
        this.morphOnce(3.0f);
        this.text.setText("This is the\nDynamic Text2D\npackage for Xith3D (DTX)");
        this.morphOnce(3.0f);
        this.text.setText("DTX features:");
        this.morphOnce(3.0f);
        this.text.setText(hv_align);
        this.text.setColor(1.0f, 1.0f, 1.0f);
        this.renderSeconds(5);
        this.dynamicText(10);
        this.coloredText(5);
        this.outro();
    }

    public Text2DDemo(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        ForegroundRenderPass pass = ForegroundRenderPass.createParallel(View.CameraMode.VIEW_FIXED);
        this.env.addRenderPass(pass);
        BranchGroup scene = pass.getBranchGroup();
        pass.getConfig().setFrontClipDistance(-1.0f);
        pass.getConfig().setBackClipDistance(1.0f);
        pass.getConfig().setScreenScale(arguments.getResolution().getWidth());
        this.scale = new TransformGroup();
        this.scale3D = new Transform3D();
        this.scale3D.setScale(1.0f);
        this.scale.setTransform(this.scale3D);
        scene.addChild(this.scale);
        this.text = new Text2D("", Colorf.WHITE, new Font("Courier", 1, 64), TextAlignment.CENTER_CENTER);
        this.scale.addChild(this.text);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(canvas);
        this.env.getCanvas().addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.demo();
    }

    public static void main(String[] args) throws Throwable {
        Text2DDemo test = new Text2DDemo(Text2DDemo.parseCommandLine(args));
        test.begin();
    }
}

