/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.shooter_demo.core;

import org.jagatoo.commands.CommandProcessor;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.listeners.InputAdapter;
import org.xith3d.demos.shooter_demo.graphics.Graphics;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;

public class GameInput
extends InputAdapter {
    private final boolean DEBUG = false;
    private final Graphics graphics;
    private final FirstPersonInputHandler fpHandler;

    public final Keyboard getKeyboard() {
        return InputSystem.getInstance().getKeyboard();
    }

    public final Mouse getMouse() {
        return InputSystem.getInstance().getMouse();
    }

    public final FirstPersonInputHandler getFirstPersonInputHandler() {
        return this.fpHandler;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case ESCAPE: {
                this.graphics.getGameLoop().end();
            }
        }
    }

    private final void registerCommands(CommandProcessor commandProcessor, FirstPersonInputHandler fpHandler) {
    }

    private final FirstPersonInputHandler createFirstPersonInputHandler(View view, Canvas3D canvas, boolean mouseYInverted, CollisionEngine collEngine, BranchGroup scene) {
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler((Transformable)view, canvas, 1.0f, 1.0f, mouseYInverted, 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        InputSystem.getInstance().addInputHandler(fpHandler);
        return fpHandler;
    }

    public GameInput(Graphics graphics, boolean mouseYInverted, CommandProcessor commandProcessor, CollisionEngine collEngine) throws InputSystemException {
        this.graphics = graphics;
        InputSystem.getInstance().registerNewKeyboardAndMouse(graphics.getCanvas().getPeer());
        this.fpHandler = this.createFirstPersonInputHandler(graphics.getView(), graphics.getCanvas(), mouseYInverted, collEngine, graphics.getBranchGroup());
        InputSystem.getInstance().addInputListener(this);
        InputSystem.getInstance().addInputListener(commandProcessor.getInputListener());
        this.registerCommands(commandProcessor, this.fpHandler);
    }
}

