/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.shooter_demo.graphics;

import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.demos.shooter_demo.graphics.GameLoop;
import org.xith3d.demos.shooter_demo.graphics.Graphics;
import org.xith3d.demos.shooter_demo.graphics.ui.hud.GameHUD;
import org.xith3d.demos.shooter_demo.graphics.ui.hud.GameHUDFactory;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.scenegraph.SceneGraph;

public class GraphicsImpl
extends Xith3DEnvironment
implements Graphics {
    private final GameLoop gameLoop;
    private final GameHUD hud;

    public GameLoop getGameLoop() {
        return this.gameLoop;
    }

    public final void startRendering() {
        this.gameLoop.begin();
    }

    public GameHUD getGameHUD() {
        return this.hud;
    }

    private static RenderPass createRenderPass(SceneGraph sg) {
        RenderPass rp = sg.addPerspectiveBranch();
        rp.getConfig().setFrontClipDistance(1.0f);
        rp.getConfig().setBackClipDistance(100.0f);
        return rp;
    }

    public GraphicsImpl(GameLoop gameLoop, CanvasConstructionInfo canvasInfo) throws Exception {
        super(gameLoop);
        this.gameLoop = gameLoop;
        GraphicsImpl.createRenderPass(this);
        Canvas3D canvas = Canvas3DFactory.create(canvasInfo);
        this.addCanvas(canvas);
        this.hud = GameHUDFactory.createHUD(this);
    }
}

