/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.shooter_demo.graphics.ui.menu;

import org.xith3d.render.Canvas3D;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.widgets.Frame;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.ui.text2d.TextAlignment;

public class GammaFrame
extends Frame {
    private final Canvas3D canvas;
    private Label lblGamma;
    private Slider slGamma;
    private Label lblBrightness;
    private Slider slBrightness;
    private Label lblContrast;
    private Slider slContrast;

    protected void onVisibilityChanged(boolean visible) {
        if (visible && this.canvas != null) {
            float gamma = this.canvas.getGamma();
            float brightness = this.canvas.getBrightness();
            float contrast = this.canvas.getContrast();
            this.lblGamma.setText(String.valueOf(gamma));
            this.slGamma.setValue((int)(gamma * 100.0f));
            this.lblBrightness.setText(String.valueOf(brightness));
            this.slBrightness.setValue((int)(brightness * 100.0f));
            this.lblContrast.setText(String.valueOf(contrast));
            this.slContrast.setValue((int)(contrast * 100.0f));
        }
    }

    public GammaFrame(final Canvas3D canvas, float width, float height, String title) {
        super(width, height, title);
        this.canvas = canvas;
        this.setCloseButtonVisible(false);
        this.setDefaultCloseOperation(null);
        Label lblGammaCaption = new Label(60.0f, 20.0f, "Gamma:", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(lblGammaCaption, 20.0f, 9.0f);
        this.lblGamma = new Label(50.0f, 20.0f, "", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(this.lblGamma, 80.0f, 9.0f);
        this.slGamma = new Slider(250.0f);
        this.getContentPane().addWidget(this.slGamma, 20.0f, 30.0f);
        Label lblBrightnessCaption = new Label(80.0f, 20.0f, "Brightness:", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(lblBrightnessCaption, 20.0f, 55.0f);
        this.lblBrightness = new Label(50.0f, 20.0f, "", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(this.lblBrightness, 100.0f, 55.0f);
        this.slBrightness = new Slider(250.0f);
        this.getContentPane().addWidget(this.slBrightness, 20.0f, 76.0f);
        Label lblContrastCaption = new Label(70.0f, 20.0f, "Contrast:", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(lblContrastCaption, 20.0f, 101.0f);
        this.lblContrast = new Label(50.0f, 20.0f, "", TextAlignment.BOTTOM_LEFT);
        this.getContentPane().addWidget(this.lblContrast, 90.0f, 101.0f);
        this.slContrast = new Slider(250.0f);
        this.getContentPane().addWidget(this.slContrast, 20.0f, 122.0f);
        this.slGamma.setMinAndMax(0, 200);
        this.slGamma.addSliderListener(new SliderListener(){

            public void onSliderValueChanged(Slider scrollbar, int newValue) {
                float gamma = (float)newValue / 100.0f;
                GammaFrame.this.lblGamma.setText(String.valueOf(gamma));
                canvas.setGamma(gamma, canvas.getBrightness(), canvas.getContrast());
            }
        });
        this.slBrightness.setMinAndMax(-100, 100);
        this.slBrightness.addSliderListener(new SliderListener(){

            public void onSliderValueChanged(Slider scrollbar, int newValue) {
                float brightness = (float)newValue / 100.0f;
                GammaFrame.this.lblBrightness.setText(String.valueOf(brightness));
                canvas.setGamma(canvas.getGamma(), brightness, canvas.getContrast());
            }
        });
        this.slContrast.setMinAndMax(0, 100);
        this.slContrast.addSliderListener(new SliderListener(){

            public void onSliderValueChanged(Slider scrollbar, int newValue) {
                float contrast = (float)newValue / 100.0f;
                GammaFrame.this.lblContrast.setText(String.valueOf(contrast));
                canvas.setGamma(canvas.getGamma(), canvas.getBrightness(), contrast);
            }
        });
    }
}

