/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.primitives.Sphere;

public class ClothFactory
implements Updatable {
    private static final int GRID_WIDTH = 14;
    private static final int GRID_HEIGHT = 14;
    private final long timePrecision = 20000L;
    private long timeSinceLastUpdate = 0L;
    private int numberOfNodes = 196;
    private int numberOfSprings = 182;
    private final float damp = 0.9f;
    private final float scale = 20.0f;
    private final float radius = 4.0f;
    private final float springLength = 0.9f;
    private final float springConstant = 20.0f;
    private final float clothInitalHeight = 17.0f;
    private Spring[] springs = null;
    private boolean wireMesh = false;
    private boolean lightingOn = true;
    private Shape3D ground = null;
    private Shape3D cloth = null;
    private Point3f gridStart = this.getGridStart();
    private Point3f[] clothData = null;
    private Vector3f tensionDirection = new Vector3f();
    private Vector3f sphereLocation = new Vector3f(0.0f, 12.0f, 0.0f);
    private Vector3f[] clothNormals = null;
    private Vector3f gravityVector = new Vector3f(0.0f, -0.98f, 0.0f);
    private Vector3f acceleration = new Vector3f();
    private Vector3f usefulVector = new Vector3f();
    private Vector3f windAction = new Vector3f();
    private Vector3f windForce = new Vector3f(-0.2f, 0.0f, -0.2f);
    private Vector3f force = new Vector3f();
    private Triangle[] clothMesh = null;
    private ClothNode[] clothNodes1 = null;
    private ClothNode[] clothNodes2 = null;
    private ClothNode[] nextClothNodes = null;
    private ClothNode[] currentClothNodes = null;
    private Appearance clothAppearance = new Appearance();
    private PolygonAttributes polygonAttributes = null;
    private TriangleStripArray clothGeomtry = null;

    private void computeNodeNormals() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.currentClothNodes[i].normal.set(0.0f, 0.0f, 0.0f);
        }
        Point3f p0 = null;
        Point3f p1 = null;
        Point3f p2 = null;
        Point3f p3 = null;
        Vector3f n0 = null;
        Vector3f n1 = null;
        Vector3f n2 = null;
        Vector3f n3 = null;
        Vector3f tool = Vector3f.fromPool();
        Vector3f normal = Vector3f.fromPool();
        for (int j = 0; j < 13; ++j) {
            for (int i = 0; i < 13; ++i) {
                p0 = this.currentClothNodes[(j + 0) * 14 + (i + 0)].location;
                p1 = this.currentClothNodes[(j + 0) * 14 + (i + 1)].location;
                p2 = this.currentClothNodes[(j + 1) * 14 + (i + 0)].location;
                p3 = this.currentClothNodes[(j + 1) * 14 + (i + 1)].location;
                n0 = this.currentClothNodes[(j + 0) * 14 + (i + 0)].normal;
                n1 = this.currentClothNodes[(j + 0) * 14 + (i + 1)].normal;
                n2 = this.currentClothNodes[(j + 1) * 14 + (i + 0)].normal;
                n3 = this.currentClothNodes[(j + 1) * 14 + (i + 1)].normal;
                tool.sub(p1, p0);
                normal.sub(p2, p0);
                normal.cross(normal, tool);
                n0.add(normal);
                n1.add(normal);
                n2.add(normal);
                tool.sub(p1, p2);
                normal.sub(p3, p2);
                normal.cross(normal, tool);
                n1.add(normal);
                n2.add(normal);
                n3.add(normal);
            }
        }
        Vector3f.toPool(normal);
        Vector3f.toPool(tool);
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.currentClothNodes[i].normal.normalize();
        }
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        int i;
        boolean updated = false;
        this.timeSinceLastUpdate += timingMode.getMicroSeconds(frameTime);
        while (this.timeSinceLastUpdate > 20000L) {
            this.timeSinceLastUpdate -= 20000L;
            updated = true;
            for (i = 0; i < this.numberOfNodes; ++i) {
                this.currentClothNodes[i].resetForce();
            }
            for (i = 0; i < this.clothMesh.length; ++i) {
                float dot = this.clothMesh[i].normal.dot(this.windForce);
                this.windAction.scale(dot, this.clothMesh[i].normal);
                this.clothMesh[i].addForce(this.windAction);
            }
            for (i = 0; i < this.numberOfSprings; ++i) {
                this.usefulVector.sub(this.currentClothNodes[this.springs[i].firstNode].location, this.currentClothNodes[this.springs[i].secondNode].location);
                this.springs[i].tension = 20.0f * (this.usefulVector.length() - this.springs[i].naturalLength) / this.springs[i].naturalLength;
            }
            for (i = 0; i < this.numberOfNodes; ++i) {
                this.nextClothNodes[i].still = this.currentClothNodes[i].still;
                if (this.currentClothNodes[i].still) {
                    this.nextClothNodes[i].location = this.currentClothNodes[i].location;
                    this.nextClothNodes[i].velocity.set(0.0f, 0.0f, 0.0f);
                    continue;
                }
                this.force.add(this.gravityVector, this.currentClothNodes[i].force);
                for (int j = 0; j < this.numberOfSprings; ++j) {
                    if (this.springs[j].firstNode == i) {
                        this.tensionDirection.sub(this.currentClothNodes[this.springs[j].secondNode].location, this.currentClothNodes[i].location);
                        this.tensionDirection.normalize();
                        this.force.scaleAdd(this.springs[j].tension, this.tensionDirection, this.force);
                    }
                    if (this.springs[j].secondNode != i) continue;
                    this.tensionDirection.sub(this.currentClothNodes[this.springs[j].firstNode].location, this.currentClothNodes[i].location);
                    this.tensionDirection.normalize();
                    this.force.scaleAdd(this.springs[j].tension, this.tensionDirection, this.force);
                }
                this.acceleration.scale(100.0f, this.force);
                this.nextClothNodes[i].velocity.scaleAdd(0.01f, this.acceleration, this.currentClothNodes[i].velocity);
                this.nextClothNodes[i].velocity.scale(0.9f);
                this.usefulVector.add(this.nextClothNodes[i].velocity, this.currentClothNodes[i].velocity);
                this.usefulVector.scale(0.005f);
                this.nextClothNodes[i].location.add(this.usefulVector, this.nextClothNodes[i].location);
                this.usefulVector.sub(this.nextClothNodes[i].location, this.sphereLocation);
                float testRadius = 4.12f;
                if (this.usefulVector.lengthSquared() < 16.9744f) {
                    this.usefulVector.normalize();
                    this.usefulVector.scaleAdd(4.12f, this.usefulVector, this.sphereLocation);
                    this.nextClothNodes[i].location.set((TupleNf)this.usefulVector);
                }
                if (!(this.nextClothNodes[i].location.getY() < 0.2f)) continue;
                this.nextClothNodes[i].location.setY(0.2f);
            }
        }
        if (updated) {
            for (i = 0; i < this.clothMesh.length; ++i) {
                this.clothMesh[i].updateNormal();
            }
            this.computeNodeNormals();
            this.clothGeomtry.setCoordinates(0, this.clothData);
            this.clothGeomtry.setNormals(0, this.clothNormals);
        }
    }

    public void letGo(int index) {
        switch (index) {
            case 1: {
                this.clothNodes1[0].still = false;
                break;
            }
            case 2: {
                this.clothNodes1[13].still = false;
                break;
            }
            case 3: {
                this.clothNodes1[182].still = false;
                break;
            }
            case 4: {
                this.clothNodes1[195].still = false;
            }
        }
    }

    private Point3f getGridStart() {
        float halfSize = 0.45f;
        return new Point3f(-13.1f * halfSize, 17.0f, -13.1f * halfSize);
    }

    public final Shape3D getGround() {
        return this.ground;
    }

    public final Shape3D getCloth() {
        return this.cloth;
    }

    public void switchFillWire() {
        boolean bl = this.wireMesh = !this.wireMesh;
        if (this.wireMesh) {
            this.polygonAttributes.setDrawMode(DrawMode.LINE);
        } else {
            this.polygonAttributes.setDrawMode(DrawMode.FILL);
        }
    }

    public void resetCloth() {
        int i;
        int j;
        for (int j2 = 0; j2 < 14; ++j2) {
            for (int i2 = 0; i2 < 14; ++i2) {
                if (this.clothNodes1[j2 * 14 + i2] == null) {
                    this.clothNodes1[j2 * 14 + i2] = new ClothNode();
                }
                this.clothNodes1[j2 * 14 + i2].location.set(this.gridStart.getX() + 0.9f * (float)i2, this.gridStart.getY() + 0.0f, this.gridStart.getZ() + 0.9f * (float)j2);
                this.clothNodes1[j2 * 14 + i2].velocity.set(0.0f, 0.0f, 0.0f);
                this.clothNodes1[j2 * 14 + i2].still = false;
            }
        }
        this.clothNodes1[0].still = true;
        this.clothNodes1[13].still = true;
        this.clothNodes1[182].still = true;
        this.clothNodes1[195].still = true;
        System.arraycopy(this.clothNodes1, 0, this.clothNodes2, 0, this.numberOfNodes);
        this.currentClothNodes = this.clothNodes1;
        this.nextClothNodes = this.clothNodes2;
        if (this.springs[0] != null) {
            return;
        }
        int springProgress = 0;
        for (j = 0; j < 14; ++j) {
            for (i = 0; i < 13; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = j * 14 + i + 1;
                this.springs[springProgress].naturalLength = 0.9f;
                ++springProgress;
            }
        }
        for (j = 0; j < 13; ++j) {
            for (i = 0; i < 14; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = (j + 1) * 14 + i;
                this.springs[springProgress].naturalLength = 0.9f;
                ++springProgress;
            }
        }
        for (j = 0; j < 13; ++j) {
            for (i = 0; i < 13; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = (j + 1) * 14 + i + 1;
                this.springs[springProgress].naturalLength = 0.9f * FastMath.sqrt(2.0f);
                ++springProgress;
            }
        }
        for (j = 0; j < 13; ++j) {
            for (i = 1; i < 14; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = (j + 1) * 14 + i - 1;
                this.springs[springProgress].naturalLength = 0.9f * FastMath.sqrt(2.0f);
                ++springProgress;
            }
        }
        for (j = 0; j < 14; ++j) {
            for (i = 0; i < 12; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = j * 14 + i + 2;
                this.springs[springProgress].naturalLength = 1.8f;
                ++springProgress;
            }
        }
        for (j = 0; j < 12; ++j) {
            for (i = 0; i < 14; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 14 + i;
                this.springs[springProgress].secondNode = (j + 2) * 14 + i;
                this.springs[springProgress].naturalLength = 1.8f;
                ++springProgress;
            }
        }
    }

    private void makeGround(Texture groundTex) {
        this.ground = new Rectangle(40.0f, 40.0f, groundTex);
        StaticTransform.rotateX(this.ground, 1.5707964f);
    }

    public Shape3D getSphere(int divisions) {
        Sphere sphere = new Sphere(4.0f, divisions, divisions, 3, false, 2);
        Material material = new Material(Colorf.GRAY90, Colorf.GRAY90, Colorf.RED, Colorf.WHITE, 100.0f);
        material.setLightingEnabled(this.lightingOn);
        material.setColorTarget(Material.NONE);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        sphere.setAppearance(appearance);
        StaticTransform.translate(sphere, (Tuple3f)this.sphereLocation);
        return sphere;
    }

    private void makeCloth(Texture clothTex) {
        int[] strips = new int[13];
        TexCoord2f[] textureData = new TexCoord2f[this.numberOfNodes];
        for (int i = 0; i < strips.length; ++i) {
            strips[i] = 28;
        }
        this.clothMesh = new Triangle[338];
        this.clothData = new Point3f[2 * (this.numberOfNodes - 14)];
        this.clothNormals = new Vector3f[2 * (this.numberOfNodes - 14)];
        this.clothGeomtry = new TriangleStripArray(this.clothData.length, strips);
        this.computeNodeNormals();
        for (int j = 0; j < 14; ++j) {
            for (int i = 0; i < 14; ++i) {
                textureData[j * 14 + i] = new TexCoord2f((float)i / 14.0f, (float)j / 14.0f);
            }
        }
        int progress = 0;
        int meshProgress = 0;
        for (int a = 0; a < 13; ++a) {
            for (int i = 0; i < 14; ++i) {
                this.clothData[progress + 0] = this.clothNodes1[(a + 0) * 14 + i].location;
                this.clothData[progress + 1] = this.clothNodes1[(a + 1) * 14 + i].location;
                this.clothNormals[progress + 0] = this.clothNodes1[(a + 0) * 14 + i].normal;
                this.clothNormals[progress + 1] = this.clothNodes1[(a + 1) * 14 + i].normal;
                this.clothGeomtry.setTextureCoordinate(0, progress + 0, textureData[(a + 0) * 14 + i]);
                this.clothGeomtry.setTextureCoordinate(0, progress + 1, textureData[(a + 1) * 14 + i]);
                if (i != 13) {
                    this.clothMesh[meshProgress++] = new Triangle(this.clothNodes1[(a + 0) * 14 + (i + 0)], this.clothNodes1[(a + 1) * 14 + (i + 0)], this.clothNodes1[(a + 0) * 14 + (i + 1)]);
                    this.clothMesh[meshProgress++] = new Triangle(this.clothNodes1[(a + 1) * 14 + (i + 0)], this.clothNodes1[(a + 1) * 14 + (i + 1)], this.clothNodes1[(a + 0) * 14 + (i + 1)]);
                }
                progress += 2;
            }
        }
        this.clothGeomtry.setCoordinates(0, this.clothData);
        this.clothGeomtry.setNormals(0, this.clothNormals);
        this.polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE);
        this.clothAppearance.setTexture(clothTex);
        this.clothAppearance.setPolygonAttributes(this.polygonAttributes);
        Material material = new Material(Colorf.GRAY80, Colorf.GRAY80, Colorf.GRAY20, Colorf.GRAY60, 20.0f);
        material.setLightingEnabled(this.lightingOn);
        material.setColorTarget(Material.NONE);
        this.clothAppearance.setMaterial(material);
        this.cloth = new Shape3D(this.clothGeomtry, this.clothAppearance);
    }

    public ClothFactory(Texture groundTex, Texture flagTex) {
        this.numberOfSprings += 182;
        this.numberOfSprings += 169;
        this.numberOfSprings += 169;
        this.numberOfSprings += 168;
        this.numberOfSprings += 168;
        this.clothNodes1 = new ClothNode[this.numberOfNodes];
        this.clothNodes2 = new ClothNode[this.numberOfNodes];
        this.springs = new Spring[this.numberOfSprings];
        this.resetCloth();
        this.makeGround(groundTex);
        this.makeCloth(flagTex);
    }

    public ClothFactory(String groundTex, String flagTex) {
        this(TextureLoader.getInstance().getTexture(groundTex), TextureLoader.getInstance().getTexture(flagTex));
    }

    private class Spring {
        float tension = 0.0f;
        float naturalLength = 0.0f;
        int firstNode = 0;
        int secondNode = 0;

        Spring() {
        }
    }

    private class ClothNode {
        Vector3f velocity = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector3f force = new Vector3f();
        Point3f location = new Point3f();
        boolean still = false;

        public void resetForce() {
            this.force.set(0.0f, 0.0f, 0.0f);
        }

        ClothNode() {
        }
    }

    private class Triangle {
        ClothNode clothNode0 = null;
        ClothNode clothNode1 = null;
        ClothNode clothNode2 = null;
        Vector3f normal = new Vector3f();
        Vector3f tool = new Vector3f();
        Point3f p0 = null;
        Point3f p1 = null;
        Point3f p2 = null;

        public void updateNormal() {
            this.tool.sub(this.p1, this.p0);
            this.normal.sub(this.p2, this.p0);
            this.normal.cross(this.tool, this.normal);
        }

        public void addForce(Tuple3f force) {
            this.clothNode0.force.add(force);
            this.clothNode1.force.add(force);
            this.clothNode2.force.add(force);
        }

        Triangle(ClothNode cn0, ClothNode cn1, ClothNode cn2) {
            this.clothNode0 = cn0;
            this.clothNode1 = cn1;
            this.clothNode2 = cn2;
            this.p0 = this.clothNode0.location;
            this.p1 = this.clothNode1.location;
            this.p2 = this.clothNode2.location;
            this.updateNormal();
        }
    }
}

