/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils.phong;

import java.util.Random;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.scenegraph.View;

public class ParticlesManager {
    public static final int PARTICLE_TYPE_FLAME = 0;
    public static final int PARTICLE_TYPE_WATER = 1;
    public static final int PARTICLE_TYPE_MAGMA = 2;
    public static final int PARTICLE_TYPE_SMOKE = 3;
    private TriangleStripArray particlesGeometry = null;
    private View camera = null;
    private SingleParticle[] particles = null;
    private Matrix3f viewMatrix = new Matrix3f();
    private Vector3f upVector = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f rightVector = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f usefulVector = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f gravityForce = new Vector3f(0.0f, 0.0f, 0.0f);
    private boolean getViewAllowed = false;
    private Point3f[] geometryCoordinates = null;
    private Point3f originCenter = new Point3f();
    private Colorf[] appearanceColors = null;
    private Colorf color = new Colorf(1.0f, 0.0f, 0.0f, 1.0f);
    private Random randomFloatsGenerator = new Random(System.nanoTime());
    private float minimumLifeTime = 15.0f;
    private float maximumAngle = 0.7853982f;
    private float randomFactor = 1.0f;
    private float globalSpeed = 1.0f;
    private float globalSize = 2.0f;
    private int numberOfParticles = 0;

    public ParticlesManager(int numberOfParticles, int effect, View camera) {
        this.camera = camera;
        this.numberOfParticles = numberOfParticles;
        TexCoord2f[] sharedTextureData = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f)};
        int[] strips = new int[numberOfParticles];
        this.geometryCoordinates = new Point3f[numberOfParticles << 2];
        this.appearanceColors = new Colorf[numberOfParticles << 2];
        this.particles = new SingleParticle[numberOfParticles];
        for (int i = 0; i < strips.length; ++i) {
            strips[i] = 4;
        }
        this.particlesGeometry = new TriangleStripArray(numberOfParticles << 2, strips);
        Vector3f location = new Vector3f();
        Vector3f speed = new Vector3f();
        for (int i = 0; i < numberOfParticles; ++i) {
            this.modifyVectorSpeed(speed);
            this.particles[i] = new SingleParticle(speed, location, this.color, this.getLifeTime());
            for (int j = 3; j >= 0; --j) {
                this.particlesGeometry.setTextureCoordinate(0, (i << 2) + j, sharedTextureData[j]);
                this.geometryCoordinates[(i << 2) + j] = this.particles[i].particleCoordinates[j];
                this.appearanceColors[(i << 2) + j] = this.particles[i].particleColor;
            }
        }
        this.preSettings(effect);
    }

    private void warmUp() {
        for (int i = 0; i < 500; ++i) {
            this.updateLogic(0.1f);
        }
    }

    public void updateLogic(float timeFraction) {
        if (this.getViewAllowed) {
            this.camera.getTransform().getRotation(this.viewMatrix);
        }
        this.getViewAllowed = false;
        for (int i = this.numberOfParticles - 1; i > -1; --i) {
            if (!this.particles[i].updateAndCheckParticleState(timeFraction)) continue;
            this.modifyVectorSpeed(this.usefulVector);
            this.particles[i].spawnNewParticle(this.usefulVector, this.originCenter, this.color, this.getLifeTime());
        }
    }

    public void updateGeometry() {
        for (int i = this.numberOfParticles - 1; i > -1; --i) {
            this.particles[i].updateParticleLocation();
        }
        this.particlesGeometry.setCoordinates(0, this.geometryCoordinates);
        this.particlesGeometry.setColors(0, this.appearanceColors);
        this.getViewAllowed = true;
    }

    public Shape3D getParticles(String tex) {
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        Appearance appearance = new Appearance();
        appearance.setTexture(TextureLoader.getInstance().getTexture(tex, Texture.MipmapMode.BASE_LEVEL));
        renderingAttributes.setDepthBufferEnabled(false);
        appearance.setRenderingAttributes(renderingAttributes);
        transparencyAttributes.setMode(TransparencyAttributes.BLENDED);
        transparencyAttributes.setTransparency(0.0f);
        transparencyAttributes.setSrcBlendFunction(TransparencyAttributes.BLEND_SRC_ALPHA);
        transparencyAttributes.setDstBlendFunction(TransparencyAttributes.BLEND_ONE);
        appearance.setTransparencyAttributes(transparencyAttributes);
        return new Shape3D(this.particlesGeometry, appearance);
    }

    public void preSettings(int settings) {
        switch (settings) {
            case 0: {
                this.color.set(1.0f, 0.312f, 0.121f, 1.0f);
                this.minimumLifeTime = 3.5f;
                this.maximumAngle = 0.174f;
                this.randomFactor = 2.0f;
                this.globalSpeed = 1.5f;
                this.globalSize = 15.0f;
                this.gravityForce.set(0.0f, 0.0f, 0.0f);
                this.warmUp();
            }
        }
    }

    private float getNextRandomFloat() {
        return this.randomFloatsGenerator.nextFloat();
    }

    private void modifyVectorSpeed(Vector3f speed) {
        float alphaAngle = (float)Math.PI * 2 * this.getNextRandomFloat();
        float betaAngle = this.clampToMaxAngle((float)Math.PI * this.getNextRandomFloat());
        speed.setX(FastMath.cos(alphaAngle) * FastMath.sin(betaAngle));
        speed.setY(FastMath.cos(betaAngle));
        speed.setZ(FastMath.sin(alphaAngle) * FastMath.sin(betaAngle));
    }

    private float getRandomSpeed() {
        float privateSpeed = this.globalSpeed * (this.getNextRandomFloat() + 0.3f);
        return privateSpeed;
    }

    private float clampToMaxAngle(float value) {
        if (value > this.maximumAngle) {
            return this.maximumAngle;
        }
        return value;
    }

    private float getLifeTime() {
        return this.minimumLifeTime * (1.0f + this.getNextRandomFloat() * this.getNextRandomFloat());
    }

    public void setParticlesOrigin(Point3f origin) {
        this.originCenter.set((TupleNf)origin);
    }

    public float getParticlesNumber() {
        return this.numberOfParticles;
    }

    private class SingleParticle {
        Vector3f vectorSpeed = null;
        Point3f[] particleCoordinates = null;
        Point3f particleLocation = null;
        Point3f randomPoint = new Point3f();
        Colorf particleColor;
        float particleSpeed = 0.0f;
        float particleSize = 0.0f;
        float lifeTime = 0.0f;
        float ratio = 0.0f;
        float age = 0.0f;

        SingleParticle(Vector3f speed, Vector3f location, Colorf color, float lifeT) {
            this.lifeTime = lifeT;
            this.vectorSpeed = new Vector3f(speed);
            this.particleColor = new Colorf(color);
            this.particleLocation = new Point3f(location);
            this.particleCoordinates = new Point3f[4];
            for (int i = 0; i < 4; ++i) {
                this.particleCoordinates[i] = new Point3f();
            }
        }

        public boolean updateAndCheckParticleState(float passedTime) {
            this.age += passedTime;
            this.vectorSpeed.scaleAdd(this.particleSpeed, ParticlesManager.this.gravityForce, this.vectorSpeed);
            this.particleLocation.scaleAdd(this.particleSpeed, this.vectorSpeed, this.particleLocation);
            if (ParticlesManager.this.randomFactor != 0.0f) {
                this.randomPoint.set(ParticlesManager.this.randomFactor * (-ParticlesManager.this.getNextRandomFloat() + ParticlesManager.this.getNextRandomFloat()), 0.0f, ParticlesManager.this.randomFactor * (-ParticlesManager.this.getNextRandomFloat() + ParticlesManager.this.getNextRandomFloat()));
                this.particleLocation.add(this.randomPoint);
            }
            this.ratio = this.age / this.lifeTime;
            this.particleSize += this.ratio * 0.5f;
            float alpha = 1.0f - this.ratio;
            this.particleColor.setAlpha(alpha);
            return alpha < 0.0f;
        }

        public void spawnNewParticle(Vector3f speed, Point3f location, Colorf color, float lifeT) {
            this.age = 0.0f;
            this.lifeTime = lifeT;
            this.particleSize = ParticlesManager.this.globalSize;
            this.particleSpeed = ParticlesManager.this.getRandomSpeed();
            this.vectorSpeed.set((TupleNf)speed);
            this.particleColor.set(color);
            this.particleLocation.set((TupleNf)location);
            this.updateParticleLocation();
        }

        public void updateParticleLocation() {
            ParticlesManager.this.viewMatrix.getColumn(0, ParticlesManager.this.rightVector);
            ParticlesManager.this.viewMatrix.getColumn(1, ParticlesManager.this.upVector);
            ParticlesManager.this.usefulVector.sub(ParticlesManager.this.upVector, ParticlesManager.this.rightVector);
            this.particleCoordinates[0].scaleAdd(this.particleSize, ParticlesManager.this.usefulVector, this.particleLocation);
            ParticlesManager.this.usefulVector.add(ParticlesManager.this.upVector, ParticlesManager.this.rightVector);
            this.particleCoordinates[1].scaleAdd(this.particleSize, ParticlesManager.this.usefulVector, this.particleLocation);
            ParticlesManager.this.usefulVector.add(ParticlesManager.this.upVector, ParticlesManager.this.rightVector);
            ParticlesManager.this.usefulVector.negate();
            this.particleCoordinates[2].scaleAdd(this.particleSize, ParticlesManager.this.usefulVector, this.particleLocation);
            ParticlesManager.this.usefulVector.sub(ParticlesManager.this.rightVector, ParticlesManager.this.upVector);
            this.particleCoordinates[3].scaleAdd(this.particleSize, ParticlesManager.this.usefulVector, this.particleLocation);
        }
    }
}

