/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils.phong;

import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.loaders.shaders.impl.assembly.AssemblyShaderLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.resources.ResLoc;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShaderProgram;
import org.xith3d.scenegraph.AssemblyShaderProgramContext;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureUnit;

public class ShapeFactory {
    private static AssemblyVertexShader vertexShader = null;
    private static AssemblyFragmentShader pixelShader = null;
    private static final Vector4f[] parameters = new Vector4f[]{new Vector4f()};

    private static final Texture loadTexture(String name) {
        return TextureLoader.getInstance().getTexture(name);
    }

    public static Shape3D getTexturedShape(Geometry geometry, String base, String dot3, String gloss, float ax, float ay, float az, float dx, float dy, float dz, int shininess) {
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setAmbientColor(ax, ay, az);
        material.setDiffuseColor(dx, dy, dz);
        material.setShininess(shininess);
        appearance.setShaderProgramContext(new AssemblyShaderProgramContext(new AssemblyShaderProgram(vertexShader, pixelShader)));
        appearance.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        appearance.setTextureUnits(new TextureUnit(ShapeFactory.loadTexture(base), null, null), new TextureUnit(ShapeFactory.loadTexture(dot3), null, null), new TextureUnit(ShapeFactory.loadTexture(gloss), null, null));
        appearance.setMaterial(material);
        return new Shape3D(geometry, appearance);
    }

    public static void setShaderParameter(Tuple3f cameraPosition) {
        parameters[0].set(cameraPosition);
        vertexShader.setParameter(0, parameters[0]);
    }

    static {
        try {
            vertexShader = AssemblyShaderLoader.getInstance().loadVertexShader(ResLoc.getResource("vertexShader.jcd"));
            vertexShader.setParameters(parameters);
            pixelShader = AssemblyShaderLoader.getInstance().loadFragmentShader(ResLoc.getResource("fragmentShader.jcd"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

