/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.atmosphere;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.Updater;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.primitives.Sphere;

public abstract class AtmosphereFactory
implements Updatable {
    private Sphere sphere;
    private PointLight light;
    private Tuple3f wavelength3 = new Tuple3f(0.65f, 0.57f, 0.475f);

    public void setSphere(Sphere sphere) {
        this.sphere = sphere;
    }

    public final Sphere getSphere() {
        return this.sphere;
    }

    public void setLight(PointLight light) {
        this.light = light;
    }

    public final PointLight getLight() {
        return this.light;
    }

    protected final Point3f getLightPos(Point3f lightPos) {
        this.light.getComputedLocation(lightPos);
        return lightPos;
    }

    public void setWavelength3(Tuple3f wavelength3) {
        this.wavelength3 = wavelength3;
    }

    public final Tuple3f getWavelength3() {
        return this.wavelength3;
    }

    protected abstract void prepareAtmosphere(Sphere var1, float var2, PointLight var3);

    public final void prepareAtmosphere(Sphere sphere, float atmosphereRadius, PointLight light, Updater updater) {
        this.setSphere(sphere);
        this.setLight(light);
        this.prepareAtmosphere(sphere, atmosphereRadius, light);
        updater.addUpdatable(this);
    }

    protected AtmosphereFactory() {
    }
}

