/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.shadows;

import org.jagatoo.opengl.enums.CompareFunction;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.spatial.bodies.Body;
import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.TupleUtils;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.render.preprocessing.RenderBinType;
import org.xith3d.render.preprocessing.ShadowAtom;
import org.xith3d.render.preprocessing.ShapeAtom;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;

public abstract class ShadowMappingFactory
extends ShadowFactory {
    public static final ShadowFactory.ShadowFactoryIdentifier SHADOW_FACTORY_ID = new ShadowFactory.ShadowFactoryIdentifier();
    private static final float DIRECTIONAL_LIGHT_SOURCE_DISTANCE = 1000.0f;
    private final Point3f lightPos = new Point3f();
    private final Vector3f lightDir = new Vector3f();
    private final Transform3D lightProj = new Transform3D();
    private final Transform3D lightModelView = new Transform3D();
    private final Transform3D scaleAndBias = ShadowMappingFactory.createScaleAndBias();
    private final Dim2i lightViewport = new Dim2i();
    private TextureRenderTarget depthTarget = null;
    private HackedRenderBinProvider renderBinProvider = null;
    private RenderPass generationPass = null;
    private Texture2D shadowMap = null;
    private TextureAttributes shadowMapAttribs = null;

    public ShadowFactory.ShadowFactoryIdentifier getShadowFactoryId() {
        return SHADOW_FACTORY_ID;
    }

    private static final Transform3D createScaleAndBias() {
        Transform3D scaleAndBias = new Transform3D();
        scaleAndBias.getMatrix4f().set(0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f);
        return scaleAndBias;
    }

    public TextureRenderTarget getDepthRenderTarget() {
        if (this.depthTarget != null) {
            return this.depthTarget;
        }
        ShadowMappingFactory shadowFactory = (ShadowMappingFactory)EffectFactory.getInstance().getShadowFactory();
        Colorf back = new Colorf(0.0f, 0.0f, 0.0f, 1.0f);
        this.depthTarget = new TextureRenderTarget((GroupNode)new Group(), (Texture)shadowFactory.getShadowMap(), back);
        this.depthTarget.setBackgroundRenderingEnabled(false);
        return this.depthTarget;
    }

    public HackedRenderBinProvider getRenderBinProvider() {
        if (this.renderBinProvider != null) {
            return this.renderBinProvider;
        }
        this.renderBinProvider = new HackedRenderBinProvider();
        return this.renderBinProvider;
    }

    public RenderPass getGenerationPass() {
        if (this.generationPass != null) {
            return this.generationPass;
        }
        this.generationPass = new RenderPass((RenderPassConfig)new BaseRenderPassConfig()){

            protected RenderBinProvider createRenderBinProvider() {
                return ShadowMappingFactory.this.getRenderBinProvider();
            }
        };
        this.generationPass.setRenderTarget(this.getDepthRenderTarget());
        this.generationPass.getConfig().setViewTransform(new Transform3D());
        return this.generationPass;
    }

    private final void findNearAndFarPlanes(Point3f lightPos, RenderBin shadowBin, RenderPassConfig passConfig) {
        float near = Float.MAX_VALUE;
        float far = -3.4028235E38f;
        for (int i = 0; i < shadowBin.size(); ++i) {
            Body bounds = (Body)((Object)shadowBin.getAtom(i).getNode().getWorldBounds());
            float distCenter = lightPos.distance(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
            float radius = bounds.getMaxCenterDistance();
            float tmpNear = distCenter - radius;
            float tmpFar = distCenter + radius;
            if (tmpNear < near) {
                near = tmpNear;
            }
            if (!(tmpFar > far)) continue;
            far = tmpFar;
        }
        near -= (far - near) * 0.1f;
        passConfig.setFrontClipDistance(near);
        passConfig.setBackClipDistance(far);
    }

    protected float calculateScreenScale() {
        return 10.0f;
    }

    protected void calculateTextureMatrix(float fovy, float aspect, float near, float far, Transform3D lightTransform, Transform3D viewTransform, Transform3D textureTransform) {
        if (fovy < 0.0f) {
            float screenScale = this.calculateScreenScale();
            this.lightProj.ortho(-screenScale, screenScale, -screenScale / aspect, screenScale / aspect, near, far);
        } else {
            this.lightProj.perspective(fovy * 2.0f, aspect, near, far);
        }
        this.lightModelView.set(lightTransform);
        this.lightModelView.invert();
        textureTransform.setIdentity();
        textureTransform.mul(this.scaleAndBias);
        textureTransform.mul(this.lightProj);
        textureTransform.mul(this.lightModelView);
    }

    public RenderPass setupRenderPass(View view, Light light, float viewportAspect, RenderBin shadowBin, long frameId, boolean justForCulling) {
        float far;
        float near;
        if (!justForCulling && shadowBin.size() == 0) {
            return null;
        }
        RenderPass generationPass = this.getGenerationPass();
        RenderPassConfig passConfig = generationPass.getConfig();
        if (light instanceof DirectionalLight) {
            ((DirectionalLight)light).getComputedDirection(this.lightDir);
            this.lightPos.set((TupleNf)this.lightDir);
            this.lightPos.negate();
            TupleUtils.normalizeVector(this.lightPos).mul(1000.0f);
            passConfig.setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
            passConfig.setScreenScale(this.calculateScreenScale());
        } else {
            ((SpotLight)light).getComputedDirection(this.lightDir);
            ((SpotLight)light).getComputedLocation(this.lightPos);
            passConfig.setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
        }
        if (justForCulling) {
            if (light instanceof DirectionalLight) {
                near = 0.01f;
                far = 1000.0f;
            } else {
                near = 0.01f;
                far = 2000.0f;
            }
            passConfig.setFrontClipDistance(near);
            passConfig.setBackClipDistance(far);
        } else {
            this.findNearAndFarPlanes(this.lightPos, shadowBin, passConfig);
            near = passConfig.getFrontClipDistance();
            far = passConfig.getBackClipDistance();
        }
        passConfig.getViewTransform().lookAlong(this.lightPos, this.lightDir);
        float fovy = -1.0f;
        if (light instanceof SpotLight) {
            fovy = ((SpotLight)light).getSpreadAngle() * 2.0f;
            passConfig.setFieldOfView(fovy);
        }
        if (!justForCulling) {
            this.calculateTextureMatrix(fovy, viewportAspect, near, far, passConfig.getViewTransform(), view.getTransform(), this.getShadowMapAttributes().getTextureTransform());
            this.getRenderBinProvider().setOpaqueBin(shadowBin);
        }
        return generationPass;
    }

    public Texture2D getShadowMap() {
        if (this.shadowMap != null) {
            return this.shadowMap;
        }
        int texSize = FastMath.pow(2, this.getShadowQuality());
        this.shadowMap = TextureCreator.createTexture(TextureFormat.DEPTH, texSize, texSize);
        this.shadowMap.setName("ShadowMap");
        this.shadowMap.setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_EDGE);
        this.shadowMap.setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_EDGE);
        this.shadowMap.setFilter(TextureFilter.TRILINEAR);
        return this.shadowMap;
    }

    public TextureAttributes getShadowMapAttributes() {
        if (this.shadowMapAttribs != null) {
            return this.shadowMapAttribs;
        }
        this.shadowMapAttribs = new TextureAttributes();
        this.shadowMapAttribs.setTextureTransform(new Transform3D());
        this.shadowMapAttribs.setCompareFunction(CompareFunction.LOWER_OR_EQUAL);
        return this.shadowMapAttribs;
    }

    public ShadowAtom getShadowAtom(Node node2) {
        ShapeAtom shadowAtom = node2 instanceof Shape3D ? _SG_PrivilegedAccess.getAtom((Shape3D)node2) : null;
        return shadowAtom;
    }

    public void verifyLight(Light light) {
        if (light != null && !(light instanceof SpotLight) && !(light instanceof DirectionalLight)) {
            throw new IllegalArgumentException("This shadowFactory accepts SpotLights and DirectionLights only.");
        }
    }

    public boolean needsPerLightCulling() {
        return true;
    }

    public void setShadowQuality(int quality) {
        super.setShadowQuality(quality);
        int texSize = FastMath.pow(2, this.getShadowQuality());
        this.lightViewport.set(texSize, texSize);
    }

    public Sized2iRO getLightViewport() {
        return this.lightViewport;
    }

    public void onOccluderStateChanged(Node node2, boolean isOccluder) {
        if (node2 instanceof GroupNode) {
            GroupNode group = (GroupNode)node2;
            int n = group.numChildren();
            for (int i = 0; i < n; ++i) {
                group.getChild(i).setIsOccluder(isOccluder);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.shadowMap != null) {
            this.shadowMap.setEnabled(enabled);
        }
    }

    public ShadowMappingFactory() {
        this.setShadowQuality(this.getShadowQuality());
    }

    public static class HackedRenderBinProvider
    extends RenderBinProvider {
        public void setOpaqueBin(RenderBin opaqueBin) {
            this.opaqueBin = opaqueBin;
        }

        public HackedRenderBinProvider() {
            super(null, new RenderBin(RenderBinType.MAIN_TRANSPARENT, "Shadow Transparent RenderBin", 0), new RenderBin(RenderBinType.MAIN_OPAQUE, "Shadow Opaque RenderBin", 0));
        }
    }
}

