/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.shadows.occluder;

import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.xith3d.effects.shadows.occluder.OccluderSubmission;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.utils.GeomDrawUtil;
import org.xith3d.utility.comparator.PointComparator;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occluder {
    public Transform3D worldTransform;
    public int nVertices;
    public int nFaces;
    private Point3f lastLightPosition = new Point3f();
    private Transform3D lastTransform = new Transform3D();
    public int[] vertexIndices;
    public float[] planeEquation;
    public int[] neighbourIndices;
    public boolean[] visible;
    public float[] vertices;
    public Geometry buffer = null;

    public Geometry getBuffer() {
        return this.buffer;
    }

    public void determineVisibleEdges(Point3f lightPosition) {
        if (this.worldTransform.compareTo(this.lastTransform) != 0 || !((TupleNf)this.lastLightPosition).equals(lightPosition)) {
            Point3f lp = new Point3f(lightPosition);
            Transform3D t = new Transform3D();
            t.set(this.worldTransform);
            t.invert();
            t.transform(lp);
            int numVisible = 0;
            for (int i = 0; i < this.nFaces; ++i) {
                float side = this.planeEquation[i * 4 + 0] * lp.getX() + this.planeEquation[i * 4 + 1] * lp.getY() + this.planeEquation[i * 4 + 2] * lp.getZ() + this.planeEquation[i * 4 + 3];
                if (side > 0.0f) {
                    this.visible[i] = true;
                    continue;
                }
                this.visible[i] = false;
                ++numVisible;
            }
            if (this.buffer == null) {
                this.buffer = new TriangleArray(this.nFaces * 3 * 6);
            }
            GeomDrawUtil drawer = new GeomDrawUtil(this.buffer);
            float INFINITY = 10000.0f;
            int numFragments = 0;
            drawer.drawStart(1);
            for (int i = 0; i < this.nFaces; ++i) {
                if (!this.visible[i]) continue;
                for (int j = 0; j < 3; ++j) {
                    int neighbourIndex = this.neighbourIndices[i * 3 + j];
                    if (neighbourIndex != -1 && this.visible[neighbourIndex]) continue;
                    ++numFragments;
                    float v1x = this.vertices[this.vertexIndices[i * 3 + j] * 3 + 0];
                    float v1y = this.vertices[this.vertexIndices[i * 3 + j] * 3 + 1];
                    float v1z = this.vertices[this.vertexIndices[i * 3 + j] * 3 + 2];
                    int k = (j + 1) % 3;
                    float v2x = this.vertices[this.vertexIndices[i * 3 + k] * 3 + 0];
                    float v2y = this.vertices[this.vertexIndices[i * 3 + k] * 3 + 1];
                    float v2z = this.vertices[this.vertexIndices[i * 3 + k] * 3 + 2];
                    float v3x = (v1x - lp.getX()) * 10000.0f;
                    float v3y = (v1y - lp.getY()) * 10000.0f;
                    float v3z = (v1z - lp.getZ()) * 10000.0f;
                    float v4x = (v2x - lp.getX()) * 10000.0f;
                    float v4y = (v2y - lp.getY()) * 10000.0f;
                    float v4z = (v2z - lp.getZ()) * 10000.0f;
                    drawer.setCoordinate(v1x, v1y, v1z);
                    drawer.setCoordinate(v1x + v3x, v1y + v3y, v1z + v3z);
                    drawer.setCoordinate(v2x + v4x, v2y + v4y, v2z + v4z);
                    drawer.setCoordinate(v1x, v1y, v1z);
                    drawer.setCoordinate(v2x + v4x, v2y + v4y, v2z + v4z);
                    drawer.setCoordinate(v2x, v2y, v2z);
                }
            }
            this.buffer.setValidVertexCount(this.buffer.getCoordinatesData().getCount() / 3);
        }
    }

    public void build(List<OccluderSubmission> submission) {
        this.nVertices = 0;
        this.nFaces = 0;
        for (OccluderSubmission os : submission) {
            this.nVertices += os.shape.getGeometry().getVertexCount();
        }
        this.nFaces = this.nVertices / 3;
        this.vertexIndices = new int[this.nFaces * 3];
        this.planeEquation = new float[this.nFaces * 4];
        this.neighbourIndices = new int[this.nFaces * 3];
        this.visible = new boolean[this.nFaces];
        Arrays.fill(this.neighbourIndices, -1);
        Point3f p = new Point3f();
        Coord testCoord = new Coord(p);
        TreeMap<Coord, Coord> vertexMap = new TreeMap<Coord, Coord>();
        for (OccluderSubmission os : submission) {
            Geometry ga = os.shape.getGeometry();
            int j0 = ga.getInitialVertexIndex();
            int shapeVertices = ga.getValidVertexCount();
            for (int j = j0; j < shapeVertices; ++j) {
                ga.setCoordinate(j, p);
                Coord newCoord = new Coord(new Point3f(p));
                vertexMap.put(testCoord, newCoord);
                assert (vertexMap.get(testCoord) != null) : "Cannot find the point just entered :" + p;
            }
        }
        int vIndex = 0;
        this.vertices = new float[vertexMap.size() * 3];
        for (Coord c : vertexMap.values()) {
            c.index = vIndex;
            this.vertices[vIndex * 3 + 0] = c.point.getX();
            this.vertices[vIndex * 3 + 1] = c.point.getY();
            this.vertices[vIndex * 3 + 2] = c.point.getZ();
            ++vIndex;
        }
        int curFace = 0;
        for (OccluderSubmission os : submission) {
            Geometry ga = os.shape.getGeometry();
            int shapeVertices = ga.getValidVertexCount();
            for (int j = 0; j < shapeVertices; ++j) {
                ga.getCoordinate(j, p);
                Coord match = (Coord)vertexMap.get(testCoord);
                if (match == null) {
                    String msg = "Cannot find matching coord map for face " + curFace + " corner " + j % 3 + " which has coord " + p;
                    throw new Error(msg);
                }
                this.vertexIndices[j] = match.index;
                if (j % 3 != 2) continue;
                this.calculateFacePlane(curFace);
                ++curFace;
            }
        }
        this.calculateConnectivity();
    }

    private void calculateFacePlane(int face) {
        Point3f v1 = new Point3f();
        Point3f v2 = new Point3f();
        Point3f v3 = new Point3f();
        v1.set(this.vertices[this.vertexIndices[face * 3 + 0] * 3 + 0], this.vertices[this.vertexIndices[face * 3 + 0] * 3 + 1], this.vertices[this.vertexIndices[face * 3 + 0] * 3 + 2]);
        v2.set(this.vertices[this.vertexIndices[face * 3 + 1] * 3 + 0], this.vertices[this.vertexIndices[face * 3 + 1] * 3 + 1], this.vertices[this.vertexIndices[face * 3 + 1] * 3 + 2]);
        v3.set(this.vertices[this.vertexIndices[face * 3 + 2] * 3 + 0], this.vertices[this.vertexIndices[face * 3 + 2] * 3 + 1], this.vertices[this.vertexIndices[face * 3 + 2] * 3 + 2]);
        float a = v1.getY() * (v2.getZ() - v3.getZ()) + v2.getY() * (v3.getZ() - v1.getZ()) + v3.getY() * (v1.getZ() - v2.getZ());
        float b = v1.getZ() * (v2.getX() - v3.getX()) + v2.getZ() * (v3.getX() - v1.getX()) + v3.getZ() * (v1.getX() - v2.getX());
        float c = v1.getX() * (v2.getY() - v3.getY()) + v2.getX() * (v3.getY() - v1.getY()) + v3.getX() * (v1.getY() - v2.getY());
        float d = -(v1.getX() * (v2.getY() * v3.getZ() - v3.getY() * v2.getZ()) + v2.getX() * (v3.getY() * v1.getZ() - v1.getY() * v3.getZ()) + v3.getX() * (v1.getY() * v2.getZ() - v2.getY() * v1.getZ()));
        this.planeEquation[face * 4 + 0] = a;
        this.planeEquation[face * 4 + 1] = b;
        this.planeEquation[face * 4 + 2] = c;
        this.planeEquation[face * 4 + 3] = d;
    }

    private void calculateConnectivity() {
        int numConnected = 0;
        for (int faceA = 0; faceA < this.nFaces; ++faceA) {
            block1: for (int edgeA = 0; edgeA < 3; ++edgeA) {
                if (this.neighbourIndices[faceA * 3 + edgeA] != -1) continue;
                boolean edgeFound = false;
                for (int faceB = 0; faceB < this.nFaces; ++faceB) {
                    if (faceA == faceB) continue;
                    for (int edgeB = 0; edgeB < 3; ++edgeB) {
                        int vertA1 = this.vertexIndices[faceA * 3 + edgeA];
                        int vertA2 = this.vertexIndices[faceA * 3 + (edgeA + 1) % 3];
                        int vertB1 = this.vertexIndices[faceB * 3 + edgeB];
                        int vertB2 = this.vertexIndices[faceB * 3 + (edgeB + 1) % 3];
                        if ((vertA1 != vertB1 || vertA2 != vertB2) && (vertA1 != vertB2 || vertA2 != vertB1)) continue;
                        this.neighbourIndices[faceA * 3 + edgeA] = faceB;
                        this.neighbourIndices[faceB * 3 + edgeB] = faceA;
                        edgeFound = true;
                        ++numConnected;
                        break;
                    }
                    if (edgeFound) continue block1;
                }
            }
        }
        X3DLog.debug("connected ", numConnected, " edges out of ", this.nFaces * 3);
    }

    public void setWorldTransform(Transform3D worldTransform) {
        this.worldTransform = worldTransform;
    }

    public Transform3D getWorldTransform() {
        return this.worldTransform;
    }

    public int[] getNeighbourIndices() {
        return this.neighbourIndices;
    }

    public int getNFaces() {
        return this.nFaces;
    }

    public int getNVertices() {
        return this.nVertices;
    }

    public float[] getPlaneEquation() {
        return this.planeEquation;
    }

    public int[] getVertexIndices() {
        return this.vertexIndices;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public boolean[] getVisible() {
        return this.visible;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Coord
    implements Comparable<Coord> {
        int index;
        Point3f point;

        public Coord(Point3f point) {
            this.point = point;
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public boolean equals(Coord o) {
            Point3f p = o.point;
            return PointComparator.comparePoints(this.point, p, 0.001f) == 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Coord)) {
                return false;
            }
            return this.equals((Coord)o);
        }

        @Override
        public int compareTo(Coord o) {
            return PointComparator.comparePoints(this.point, o.point, 0.001f);
        }
    }
}

