/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input.modules.fpih;

import java.util.ArrayList;
import org.openmali.FastMath;
import org.xith3d.input.modules.fpih.FPIHConfigListener;

public class FPIHConfig {
    public static final float DEFAULT_MOUSE_X_SPEED = 1.0f;
    public static final float DEFAULT_MOUSE_Y_SPEED = 1.0f;
    public static boolean DEFAULT_MOUSE_Y_INVERTED = true;
    public static final float DEFAULT_MOVEMENT_FORWARD_SPEED = 1.0f;
    public static final float DEFAULT_MOVEMENT_BACKWARD_SPEED = 1.0f;
    public static final float DEFAULT_MOVEMENT_SIDEWARD_SPEED = 1.0f;
    public static final float DEFAULT_MAX_ANGLE_UP_DOWN = FastMath.toRad(80.0f);
    private float mouseXSpeed = 1.0f;
    private float mouseYSpeed = 1.0f;
    private float movementSpeedForward = 1.0f;
    private float movementSpeedBackward = 1.0f;
    private float movementSpeedSideward = 1.0f;
    private final ArrayList<FPIHConfigListener> listeners = new ArrayList();

    public void addListener(FPIHConfigListener l) {
        this.listeners.add(l);
    }

    public void removeListener(FPIHConfigListener l) {
        this.listeners.remove(l);
    }

    protected void onSettingChanged(String setting, float oldValue, float value) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onSettingChanged(setting, oldValue, value);
        }
    }

    public void setMouseXSpeed(float speedX) {
        float oldValue = this.mouseXSpeed;
        this.mouseXSpeed = speedX;
        if (speedX != oldValue) {
            this.onSettingChanged("MouseXSpeed", oldValue, speedX);
        }
    }

    public final float getMouseXSpeed() {
        return this.mouseXSpeed;
    }

    public void setMouseYSpeed(float speedY) {
        float oldValue = this.mouseYSpeed;
        this.mouseYSpeed = speedY;
        if (speedY != oldValue) {
            this.onSettingChanged("MouseYSpeed", oldValue, speedY);
        }
    }

    public final float getMouseYSpeed() {
        return this.mouseYSpeed;
    }

    public void flipMouseYAxis() {
        this.setMouseYSpeed(-this.getMouseYSpeed());
    }

    public final float getMovementSpeed() {
        return (this.movementSpeedForward + this.movementSpeedBackward + this.movementSpeedSideward) / 3.0f;
    }

    public void setMovementSpeedForward(float speed) {
        float oldValue = this.movementSpeedForward;
        this.movementSpeedForward = speed;
        if (speed != oldValue) {
            this.onSettingChanged("MovementSpeedForward", oldValue, speed);
        }
    }

    public final float getMovementSpeedForward() {
        return this.movementSpeedForward;
    }

    public void setMovementSpeedBackward(float speed) {
        float oldValue = this.movementSpeedBackward;
        this.movementSpeedBackward = speed;
        if (speed != oldValue) {
            this.onSettingChanged("MovementSpeedBackward", oldValue, speed);
        }
    }

    public final float getMovementSpeedBackward() {
        return this.movementSpeedBackward;
    }

    public void setMovementSpeedSideward(float speed) {
        float oldValue = this.movementSpeedSideward;
        this.movementSpeedSideward = speed;
        if (speed != oldValue) {
            this.onSettingChanged("MovementSpeedSideward", oldValue, speed);
        }
    }

    public final float getMovementSpeedSideward() {
        return this.movementSpeedSideward;
    }

    public void setMovementSpeed(float speed) {
        float oldValueForward = this.movementSpeedForward;
        float oldValueBackward = this.movementSpeedBackward;
        float oldValueSideward = this.movementSpeedSideward;
        this.movementSpeedForward = speed;
        this.movementSpeedBackward = speed;
        this.movementSpeedSideward = speed;
        if (speed != oldValueForward || speed != oldValueBackward || speed != oldValueSideward) {
            this.onSettingChanged("MovementSpeed", (oldValueForward + oldValueBackward + oldValueSideward) / 3.0f, speed);
        }
    }

    public FPIHConfig(float mouseXSpeed, float mouseYSpeed, float movementSpeedForeward, float movementSpeedBackward, float movementSpeedSideward) {
        this.setMouseXSpeed(mouseXSpeed);
        this.setMouseYSpeed(mouseYSpeed);
        this.setMovementSpeedForward(movementSpeedForeward);
        this.setMovementSpeedBackward(movementSpeedBackward);
        this.setMovementSpeedSideward(movementSpeedSideward);
    }

    public FPIHConfig(float mouseXSpeed, float mouseYSpeed, float movementSpeed) {
        this(mouseXSpeed, mouseYSpeed, movementSpeed, movementSpeed, movementSpeed);
    }

    public FPIHConfig() {
        this(1.0f, DEFAULT_MOUSE_Y_INVERTED ? -1.0f : 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

