/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input.modules.fpih;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.spatial.AxisIndicator;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.input.modules.ColliderCheckCallback;
import org.xith3d.input.modules.SlidingColliderCheckCallback;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Capsule;

public class FPIHPhysics {
    private final SimulationWorld simWorld;
    private final float width;
    private final float height;
    private final float halfWidthEpsilon;
    private final float halfHeightEpsilon;
    private final float maxHalfEpsilon;
    private final Collideable collider;
    private final Body body;
    private final Node colliderDebugger;
    private final TransformGroup colliderDebuggerTG;
    private boolean collisionsEnabled = true;
    private boolean simulationEnabled = true;
    private Vector3f colliderOffset = null;
    private ColliderCheckCallback colliderCallback = null;
    private long lastGameMicros = 0L;
    private long lastCollisionTime = -999999999L;
    private boolean isJumping = false;
    private final Tuple3f lastBodyPos = new Tuple3f();
    private final Vector3f lastCollisionDirection = new Vector3f();

    public void setCollisionsEnabled(boolean enabled) {
        this.collisionsEnabled = enabled;
        if (this.colliderDebuggerTG != null) {
            this.colliderDebuggerTG.setRenderable(enabled);
        }
    }

    public final boolean areCollisionsEnabled() {
        return this.collisionsEnabled;
    }

    public void setSimulationEnabled(boolean enabled) {
        this.simulationEnabled = enabled;
    }

    public final boolean isSimulationEnabled() {
        return this.simulationEnabled;
    }

    public final void updateGameTime(long gameMicros) {
        this.lastGameMicros = gameMicros;
    }

    public final long getLastGameTime() {
        return this.lastGameMicros;
    }

    public final Collideable getCollider() {
        return this.collider;
    }

    public final Body getBody() {
        return this.body;
    }

    public final Node getDebugNode() {
        return this.colliderDebuggerTG;
    }

    public void setColliderOffset(float offsetX, float offsetY, float offsetZ) {
        if (offsetX == 0.0f && offsetY == 0.0f && offsetZ == 0.0f) {
            this.colliderOffset = null;
            return;
        }
        if (this.colliderOffset == null) {
            this.colliderOffset = new Vector3f(offsetX, offsetY, offsetZ);
        } else {
            this.colliderOffset.set(offsetX, offsetY, offsetZ);
        }
    }

    public void setColliderOffset(Tuple3f offset) {
        if (offset == null) {
            this.colliderOffset = null;
            return;
        }
        this.setColliderOffset(offset.getX(), offset.getY(), offset.getZ());
    }

    public Vector3f getColliderOffset() {
        return this.colliderOffset;
    }

    public boolean startJump(AxisIndicator upAxis) {
        if (this.lastGameMicros <= this.lastCollisionTime + 100000L && this.lastCollisionDirection.getY() < 0.0f) {
            if (this.simulationEnabled && this.body != null) {
                Vector3f vel = this.body.getLinearVelocity();
                switch (upAxis) {
                    case POSITIVE_X_AXIS: {
                        this.body.setLinearVelocity(5.0f, vel.getY(), vel.getZ());
                        break;
                    }
                    case NEGATIVE_X_AXIS: {
                        this.body.setLinearVelocity(-5.0f, vel.getY(), vel.getZ());
                        break;
                    }
                    case POSITIVE_Y_AXIS: {
                        this.body.setLinearVelocity(vel.getX(), 5.0f, vel.getZ());
                        break;
                    }
                    case NEGATIVE_Y_AXIS: {
                        this.body.setLinearVelocity(vel.getX(), -5.0f, vel.getZ());
                        break;
                    }
                    case POSITIVE_Z_AXIS: {
                        this.body.setLinearVelocity(vel.getX(), vel.getY(), 5.0f);
                        break;
                    }
                    case NEGATIVE_Z_AXIS: {
                        this.body.setLinearVelocity(vel.getX(), vel.getY(), -5.0f);
                    }
                }
            }
            this.isJumping = true;
            return true;
        }
        return false;
    }

    public void updateFromView(Tuple3f viewPosition) {
        if (this.body != null) {
            Tuple3f tmp = Tuple3f.fromPool(viewPosition);
            if (this.colliderOffset != null) {
                tmp.sub(this.colliderOffset);
            }
            this.body.setPosition(tmp);
            this.collider.setPosition(tmp);
            this.lastBodyPos.set((TupleNf)tmp);
            this.body.resetLinearVelocity();
            this.body.resetAngularVelocity();
            Tuple3f.toPool(tmp);
        }
    }

    private void updateFromCollider(Transformable view, Vector3f tpOffset2) {
        Tuple3f pos = Tuple3f.fromPool();
        this.collider.getPosition(pos);
        if (this.simulationEnabled && this.body != null) {
            this.body.setPosition(pos);
            this.lastBodyPos.set((TupleNf)pos);
        }
        if (tpOffset2 != null) {
            pos.add(tpOffset2);
        }
        if (this.colliderOffset != null) {
            pos.sub(this.colliderOffset);
        }
        view.getTransform().setTranslation(pos);
        if (this.colliderDebuggerTG != null) {
            this.colliderDebuggerTG.getTransform().setTranslation(pos);
            this.colliderDebuggerTG.updateTransform();
        }
        Tuple3f.toPool(pos);
    }

    private boolean updateAndCheckCollider(Vector3f colliderPosition) {
        this.collider.setPosition(colliderPosition);
        if (this.colliderCallback != null && this.colliderCallback.checkCollision(this.collider)) {
            this.lastCollisionDirection.sub(colliderPosition, this.collider.getPosition());
            this.collider.getPosition(colliderPosition);
            return true;
        }
        return false;
    }

    public void update(long gameMicros, long frameMicros, Transformable view, Vector3f deltaMovement, float rotX, float rotY, Vector3f thirdPersonOffset) {
        if (!this.collisionsEnabled) {
            return;
        }
        Vector3f colliderPosition = Vector3f.fromPool();
        Vector3f bodyDelta = Vector3f.fromPool(0.0f, 0.0f, 0.0f);
        Vector3f totalDelta = Vector3f.fromPool();
        view.getTransform().getTranslation(colliderPosition);
        if (this.colliderOffset != null) {
            colliderPosition.add(this.colliderOffset);
        }
        colliderPosition.sub(thirdPersonOffset);
        if (this.simulationEnabled && this.body != null) {
            bodyDelta.sub(this.body.getPosition(), this.lastBodyPos);
            colliderPosition.add(bodyDelta);
        }
        totalDelta.add(deltaMovement, bodyDelta);
        float totalDeltaLength = totalDelta.length();
        boolean hasCollision = false;
        if (totalDeltaLength <= this.maxHalfEpsilon && (!this.simulationEnabled || this.body == null || frameMicros <= this.simWorld.getMaxStepSize())) {
            hasCollision = this.updateAndCheckCollider(colliderPosition);
        } else {
            float distanceStepFraction0 = totalDeltaLength / this.maxHalfEpsilon;
            float timeStepFraction0 = (float)frameMicros / (this.simulationEnabled && this.body != null ? (float)this.simWorld.getMaxStepSize() : 1.0f);
            float stepFraction0 = distanceStepFraction0 > timeStepFraction0 ? distanceStepFraction0 : timeStepFraction0;
            Vector3f oldColliderPosition = Vector3f.fromPool();
            oldColliderPosition.sub(colliderPosition, deltaMovement);
            oldColliderPosition.sub(bodyDelta);
            int step = 0;
            for (float stepFraction = stepFraction0; stepFraction > 0.0f && !hasCollision; stepFraction -= 1.0f) {
                colliderPosition.set((TupleNf)totalDelta);
                colliderPosition.mul((float)(++step) / stepFraction0);
                colliderPosition.add(oldColliderPosition);
                hasCollision = this.updateAndCheckCollider(colliderPosition);
            }
            Vector3f.toPool(oldColliderPosition);
        }
        if (hasCollision) {
            if (this.simulationEnabled && this.body != null && (!this.isJumping || gameMicros > this.lastCollisionTime + 100000L)) {
                this.body.resetLinearVelocity();
                this.isJumping = false;
            }
            this.updateFromCollider(view, thirdPersonOffset);
            this.collider.getPosition(colliderPosition);
            this.lastCollisionTime = gameMicros;
        } else if (this.simulationEnabled && this.body != null) {
            this.updateFromCollider(view, thirdPersonOffset);
        }
        if (this.colliderDebuggerTG != null) {
            this.colliderDebuggerTG.getTransform().setEuler(0.0f, rotY, 0.0f);
            this.colliderDebuggerTG.getTransform().setTranslation(colliderPosition);
            this.colliderDebuggerTG.updateTransform();
        }
        Vector3f.toPool(totalDelta);
        Vector3f.toPool(bodyDelta);
        Vector3f.toPool(colliderPosition);
    }

    public void setColliderCheckCallback(ColliderCheckCallback ccc) {
        this.colliderCallback = ccc;
    }

    public SlidingColliderCheckCallback setSlidingColliderCheckCallback(CollisionEngine collEngine, CollideableGroup collGroup) {
        SlidingColliderCheckCallback ccc = new SlidingColliderCheckCallback(collEngine, collGroup);
        this.setColliderCheckCallback(ccc);
        return ccc;
    }

    public void init(Transformable view, Vector3f tpOffset) {
        Vector3f viewPosition = Vector3f.fromPool();
        view.getPosition(viewPosition);
        if (tpOffset != null) {
            Vector3f tpOffset2 = Vector3f.fromPool();
            view.getTransform().getMatrix4f().transform(tpOffset, tpOffset2);
            viewPosition.add(tpOffset2);
            Vector3f.toPool(tpOffset2);
        }
        if (this.colliderOffset != null) {
            viewPosition.add(this.colliderOffset);
        }
        if (this.body == null) {
            this.collider.setPosition(viewPosition);
        } else {
            this.body.setPosition(viewPosition);
        }
        if (this.colliderDebuggerTG != null) {
            this.colliderDebuggerTG.getTransform().setTranslation(viewPosition);
            this.colliderDebuggerTG.setTransform(this.colliderDebuggerTG.getTransform());
        }
        Vector3f.toPool(viewPosition);
    }

    protected Collideable createCollideable(CollisionEngine collEngine, float width, float height) {
        CollideableGroup group = collEngine.newGroup("Simple");
        SphereCollideable sphereTop = collEngine.newSphere(width / 2.0f);
        sphereTop.setPositionZ((height - width) / 2.0f);
        group.addCollideable(sphereTop);
        SphereCollideable sphereBottom = collEngine.newSphere(width / 2.0f);
        sphereBottom.setPositionZ(-(height - width) / 2.0f);
        group.addCollideable(sphereBottom);
        return group;
    }

    protected Node createCollideableDebugger(AxisIndicator upAxis, float width, float height) {
        Capsule colliderDebugger = new Capsule(width / 2.0f, height - width, 8, 4, Colorf.BLUE);
        switch (upAxis) {
            case POSITIVE_X_AXIS: {
                StaticTransform.rotateZ(colliderDebugger, 1.5707964f);
                break;
            }
            case NEGATIVE_X_AXIS: {
                StaticTransform.rotateZ(colliderDebugger, 1.5707964f);
                break;
            }
            case POSITIVE_Y_AXIS: 
            case NEGATIVE_Y_AXIS: {
                break;
            }
            case POSITIVE_Z_AXIS: {
                StaticTransform.rotateX(colliderDebugger, 1.5707964f);
                break;
            }
            case NEGATIVE_Z_AXIS: {
                StaticTransform.rotateX(colliderDebugger, 1.5707964f);
            }
        }
        colliderDebugger.getAppearance(true).getPolygonAttributes(true).setDrawMode(DrawMode.LINE);
        return colliderDebugger;
    }

    public FPIHPhysics(AxisIndicator upAxis, float width, float height, Vector3f offset, CollisionEngine collEngine, SimulationEngine simEngine, SimulationWorld simWorld, boolean integrateWithSimulation, boolean addDebugShape) {
        this.simWorld = simWorld;
        this.width = width;
        this.height = height;
        this.halfWidthEpsilon = this.width / 2.0f * 0.9f;
        this.halfHeightEpsilon = this.height / 2.0f * 0.9f;
        this.maxHalfEpsilon = Math.max(this.halfWidthEpsilon, this.halfHeightEpsilon);
        this.collider = this.createCollideable(collEngine, width, height);
        if (integrateWithSimulation) {
            if (simWorld != null) {
                this.body = simWorld.newBody();
                this.body.setMass(85.0f);
                switch (upAxis) {
                    case POSITIVE_X_AXIS: {
                        this.body.setRotation(0.0f, 1.5707964f, 0.0f);
                        break;
                    }
                    case NEGATIVE_X_AXIS: {
                        this.body.setRotation(0.0f, 1.5707964f, 0.0f);
                        break;
                    }
                    case POSITIVE_Y_AXIS: {
                        this.body.setRotation(1.5707964f, 0.0f, 0.0f);
                        break;
                    }
                    case NEGATIVE_Y_AXIS: {
                        this.body.setRotation(-1.5707964f, 0.0f, 0.0f);
                        break;
                    }
                    case POSITIVE_Z_AXIS: {
                        break;
                    }
                }
                this.body.addCollideable(this.collider);
                simWorld.addBody(this.body);
            } else {
                this.body = null;
            }
        } else {
            switch (upAxis) {
                case POSITIVE_X_AXIS: {
                    this.collider.setRotation(0.0f, 1.5707964f, 0.0f);
                    break;
                }
                case NEGATIVE_X_AXIS: {
                    this.collider.setRotation(0.0f, 1.5707964f, 0.0f);
                    break;
                }
                case POSITIVE_Y_AXIS: {
                    this.collider.setRotation(1.5707964f, 0.0f, 0.0f);
                    break;
                }
                case NEGATIVE_Y_AXIS: {
                    this.collider.setRotation(-1.5707964f, 0.0f, 0.0f);
                    break;
                }
                case POSITIVE_Z_AXIS: {
                    break;
                }
            }
            this.body = null;
        }
        this.colliderOffset = offset;
        if (addDebugShape) {
            this.colliderDebugger = this.createCollideableDebugger(upAxis, width, height);
            this.colliderDebuggerTG = new TransformGroup();
            this.colliderDebuggerTG.addChild(this.colliderDebugger);
            this.colliderDebuggerTG.setPickableRecursive(false);
        } else {
            this.colliderDebugger = null;
            this.colliderDebuggerTG = null;
        }
    }

    public FPIHPhysics(float width, float height, Vector3f offset, CollisionEngine collEngine, SimulationEngine simEngine, SimulationWorld simWorld, boolean integrateWithSimulation, boolean addDebugShape) {
        this(AxisIndicator.POSITIVE_Y_AXIS, width, height, offset, collEngine, simEngine, simWorld, integrateWithSimulation, addDebugShape);
    }

    public FPIHPhysics(float width, float height, Vector3f offset, CollisionEngine collEngine, SimulationEngine simEngine, boolean integrateWithSimulation, boolean addDebugShape) {
        this(width, height, offset, collEngine, simEngine, null, integrateWithSimulation, addDebugShape);
    }

    public FPIHPhysics(float width, float height, Vector3f offset, PhysicsEngine physEngine, SimulationWorld simWorld, boolean integrateWithSimulation, boolean addDebugShape) {
        this(width, height, offset, physEngine.getCollisionEngine(), physEngine.getSimulationEngine(), simWorld, integrateWithSimulation, addDebugShape);
    }

    public FPIHPhysics(float width, float height, Vector3f offset, PhysicsEngine physEngine, boolean integrateWithSimulation, boolean addDebugShape) {
        this(width, height, offset, physEngine.getCollisionEngine(), physEngine.getSimulationEngine(), integrateWithSimulation, addDebugShape);
    }

    public FPIHPhysics(float width, float height, Vector3f offset, CollisionEngine collEngine, boolean addDebugShape) {
        this(width, height, offset, collEngine, null, false, addDebugShape);
    }

    public FPIHPhysics(float width, float height, Vector3f offset, CollisionEngine collEngine) {
        this(width, height, offset, collEngine, false);
    }
}

