/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.xith3d.io.InvalidFormat;
import org.xith3d.io.Scribable;
import org.xith3d.io.ScribeInputStream;
import org.xith3d.io.ScribeOutputStream;
import org.xith3d.io.UnscribableNodeEncountered;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive
implements Comparator<String> {
    private static final boolean USE_MAP = true;
    private static final long CLEAN = 876236278L;
    private static final int BLOCK_SIZE = 20000;
    private static final long LONG_SIZE = 8L;
    private static final long CLEAN_LOC = 0L;
    private static final long DIR_START_LOC = 8L;
    private static final long FREE_START_LOC = 16L;
    private static final long EXPAND_START_LOC = 24L;
    private static final long INITIAL_EXPAND_LOC = 32L;
    private RandomAccessFile file;
    private TreeMap<String, DirEntry> index = new TreeMap(this);
    private LinkedList<Block> free = new LinkedList();
    private long freelistLoc = 0L;
    private long dirlistLoc = 0L;
    private long expandLoc;
    private boolean readOnly;
    private MappedByteBuffer bb;

    public Archive(String filename, boolean readonly) throws IOException {
        this.readOnly = readonly;
        File f = new File(filename);
        if (!f.exists()) {
            if (readonly) {
                throw new IOException("No such file " + filename);
            }
            this.file = new RandomAccessFile(filename, "rw");
            this.initializeFile();
        } else if (readonly) {
            FileInputStream fs = new FileInputStream(f);
            FileChannel fc = fs.getChannel();
            this.bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, f.length());
        } else {
            this.file = new RandomAccessFile(filename, readonly ? "r" : "rw");
        }
        if (this.readOnly) {
            this.readHeaderViaMap();
        } else {
            this.readHeader();
        }
        if (!this.readOnly) {
            this.readFreeList();
        }
        if (this.readOnly) {
            this.readDirectoryViaMap();
        } else {
            this.readDirectory();
        }
    }

    public boolean exists(String name) {
        DirEntry d = this.index.get(name);
        X3DLog.debug("Archive search for ", name + " : ", d != null);
        return d != null;
    }

    public void close() throws IOException {
        if (!this.readOnly) {
            this.writeDirectory();
            this.writeFreeList();
            this.file.seek(24L);
            this.file.writeLong(this.expandLoc);
            this.file.seek(0L);
            this.file.writeLong(876236278L);
        }
        this.file.close();
    }

    private void readHeader() throws IOException {
        this.file.seek(0L);
        long value = this.file.readLong();
        if (value != 876236278L) {
            throw new Error("Archive is corrupt");
        }
        if (!this.readOnly) {
            this.file.seek(0L);
            this.file.writeLong(0L);
        }
        this.file.seek(8L);
        this.dirlistLoc = this.file.readLong();
        X3DLog.debug("Directory root = ", this.dirlistLoc);
        this.file.seek(16L);
        this.freelistLoc = this.file.readLong();
        X3DLog.debug("Free root = ", this.freelistLoc);
        this.file.seek(24L);
        this.expandLoc = this.file.readLong();
        X3DLog.debug("Expand loc = ", this.expandLoc);
    }

    private void readHeaderViaMap() {
        this.bb.position(0);
        long value = this.bb.getLong();
        if (value != 876236278L) {
            throw new Error("Archive is corrupt");
        }
        this.bb.position(8);
        this.dirlistLoc = this.bb.getLong();
        X3DLog.debug("Directory root = ", this.dirlistLoc);
        this.bb.position(16);
        this.freelistLoc = this.bb.getLong();
        X3DLog.debug("Free root = ", this.freelistLoc);
        this.bb.position(24);
        this.expandLoc = this.bb.getLong();
        X3DLog.debug("Expand loc = ", this.expandLoc);
    }

    private long allocateSpace(long size) {
        Block minBlock = null;
        for (Block b : this.free) {
            if (b.length == size) {
                this.free.remove(b);
                return b.loc;
            }
            if (b.length <= size) continue;
            if (minBlock == null) {
                minBlock = b;
                continue;
            }
            if (minBlock.length <= size) continue;
            minBlock = b;
        }
        if (minBlock != null && (double)minBlock.length < (double)size * 1.2) {
            this.free.remove(minBlock);
            return minBlock.loc;
        }
        long loc = this.expandLoc;
        this.expandLoc += size;
        return loc;
    }

    private void initializeFile() throws IOException {
        this.file.setLength(0L);
        this.file.seek(8L);
        this.file.writeLong(0L);
        this.file.seek(16L);
        this.file.writeLong(0L);
        this.file.seek(24L);
        this.file.writeLong(32L);
        this.file.seek(0L);
        this.file.writeLong(876236278L);
    }

    private void writeFreeList() throws IOException {
        X3DLog.debug("Writing free list");
        if (this.free.size() == 0) {
            this.file.seek(16L);
            this.file.writeLong(0L);
        } else {
            Block first = this.free.getFirst();
            this.file.seek(16L);
            this.file.writeLong(first.loc);
            int n = this.free.size();
            for (int i = 0; i < n; ++i) {
                Block bcur = this.free.get(i);
                Block next = null;
                if (i < n - 1) {
                    next = this.free.get(i + 1);
                }
                this.file.seek(bcur.loc);
                this.file.writeLong(bcur.length);
                if (next == null) {
                    this.file.writeLong(0L);
                } else {
                    this.file.writeLong(next.loc);
                }
                X3DLog.debug("   bfree block pos=", bcur.loc, ", len = ", bcur.length);
            }
        }
    }

    private void readFreeList() throws IOException {
        X3DLog.debug("Reading free list");
        this.free.clear();
        long loc = this.freelistLoc;
        while (loc != 0L) {
            this.file.seek(loc);
            Block b = new Block();
            b.length = this.file.readLong();
            b.loc = loc;
            loc = this.file.readLong();
            this.free.add(b);
            X3DLog.debug("   bfree block pos=", b.loc, ", len = ", b.length, ", next=", loc);
        }
    }

    private void writeDirectory() throws IOException {
        long pad = 10L;
        if (this.index.size() == 0) {
            this.file.seek(8L);
            this.file.writeLong(0L);
        } else {
            long loc = this.allocateSpace(20000L);
            this.file.seek(8L);
            this.file.writeLong(loc);
            long stopLoc = loc + 20000L;
            this.file.seek(loc);
            this.file.writeLong(20000L);
            for (DirEntry d : this.index.values()) {
                if (d.estimateSize() + loc + pad > stopLoc) {
                    loc = this.allocateSpace(20000L);
                    this.file.writeByte(0);
                    this.file.writeLong(loc);
                    this.file.seek(loc);
                    this.file.writeLong(20000L);
                    stopLoc = loc + 20000L;
                }
                this.file.writeByte(1);
                d.write();
                loc = this.file.getFilePointer();
                if (loc < stopLoc) continue;
                throw new Error("Writing directory exceeded block size");
            }
            this.file.writeByte(0);
            this.file.writeLong(0L);
        }
    }

    private void readDirectory() throws IOException {
        X3DLog.debug("Reading directory");
        int num = 0;
        this.index.clear();
        long loc = this.dirlistLoc;
        while (loc != 0L) {
            this.file.seek(loc);
            Block b = new Block();
            b.length = this.file.readLong();
            b.loc = loc;
            this.free.add(b);
            ++num;
            byte marker = this.file.readByte();
            while (marker == 1) {
                DirEntry d = new DirEntry();
                d.read();
                marker = this.file.readByte();
                this.index.put(d.name, d);
            }
            loc = this.file.readLong();
        }
        X3DLog.debug("  Found ", this.index.size(), " items in ", num, " block");
    }

    private void readDirectoryViaMap() throws IOException {
        X3DLog.debug("Reading directory");
        int num = 0;
        this.index.clear();
        long loc = this.dirlistLoc;
        while (loc != 0L) {
            this.bb.position((int)loc);
            Block b = new Block();
            b.length = this.bb.getLong();
            b.loc = loc;
            this.free.add(b);
            ++num;
            byte marker = this.bb.get();
            while (marker == 1) {
                DirEntry d = new DirEntry();
                d.readViaMap();
                marker = this.bb.get();
                this.index.put(d.name, d);
            }
            loc = this.bb.getLong();
        }
        X3DLog.debug("  Found ", this.index.size(), " items in ", num, " block");
    }

    @Override
    public int compare(String a, String b) {
        return a.compareTo(b);
    }

    public void write(String name, Scribable object, boolean compress) throws IOException, UnscribableNodeEncountered {
        DirEntry d = this.index.get(name);
        if (d != null) {
            Block b = new Block();
            b.length = d.length;
            b.loc = d.pos;
            this.free.add(b);
        } else {
            d = new DirEntry();
            d.name = name;
            this.index.put(name, d);
        }
        d.compressed = compress;
        ZipOutputStream zip = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10000);
        OutputStream out = bout;
        if (compress) {
            zip = new ZipOutputStream(out);
            zip.putNextEntry(new ZipEntry("object"));
            out = zip;
        }
        ScribeOutputStream sout = new ScribeOutputStream(out);
        if (object == null) {
            System.out.println("Object is null");
        }
        sout.writeScribable(object);
        if (compress) {
            zip.closeEntry();
        }
        out.close();
        byte[] data = bout.toByteArray();
        d.pos = this.allocateSpace(data.length);
        d.length = data.length;
        this.file.seek(d.pos);
        this.file.write(data, 0, data.length);
        X3DLog.debug("Wrote out ", d.length, " bytes for ", name);
    }

    public Scribable read(String name) throws IOException, InvalidFormat {
        ByteArrayInputStream bin;
        DirEntry d = this.index.get(name);
        if (d == null) {
            return null;
        }
        byte[] data = new byte[(int)d.length];
        if (this.readOnly) {
            this.bb.position((int)d.pos);
            this.bb.get(data);
        } else {
            this.file.seek(d.pos);
            this.file.read(data, 0, data.length);
        }
        ZipInputStream zip = null;
        InputStream in = bin = new ByteArrayInputStream(data);
        if (d.compressed) {
            zip = new ZipInputStream(in);
            zip.getNextEntry();
            in = zip;
        }
        ScribeInputStream sin = new ScribeInputStream(in);
        Scribable object = sin.readScribable();
        ((InputStream)in).close();
        return object;
    }

    public void remove(String name) {
        DirEntry d = this.index.get(name);
        if (d != null) {
            Block b = new Block();
            b.length = d.length;
            b.loc = d.pos;
            this.free.add(b);
            this.index.remove(d.name);
        }
    }

    private String readUTF() throws IOException {
        int utflen = this.bb.getShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        this.bb.get(bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        UTFDataFormatException ex = new UTFDataFormatException();
                        X3DLog.print(ex);
                        throw ex;
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        UTFDataFormatException ex = new UTFDataFormatException();
                        X3DLog.print(ex);
                        throw ex;
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        UTFDataFormatException ex = new UTFDataFormatException();
                        X3DLog.print(ex);
                        throw ex;
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        UTFDataFormatException ex = new UTFDataFormatException();
                        X3DLog.print(ex);
                        throw ex;
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            UTFDataFormatException ex = new UTFDataFormatException();
            X3DLog.print(ex);
            throw ex;
        }
        return new String(str);
    }

    class DirEntry {
        long pos;
        String name;
        long length;
        boolean compressed;

        DirEntry() {
        }

        void read() throws IOException {
            this.pos = Archive.this.file.readLong();
            this.name = Archive.this.file.readUTF();
            this.length = Archive.this.file.readLong();
            this.compressed = Archive.this.file.readBoolean();
        }

        void readViaMap() throws IOException {
            this.pos = Archive.this.bb.getLong();
            this.name = Archive.this.readUTF();
            this.length = Archive.this.bb.getLong();
            this.compressed = Archive.this.bb.get() != 0;
        }

        void write() throws IOException {
            Archive.this.file.writeLong(this.pos);
            Archive.this.file.writeUTF(this.name);
            Archive.this.file.writeLong(this.length);
            Archive.this.file.writeBoolean(this.compressed);
        }

        long estimateSize() {
            return this.name.length() + 4 + 25;
        }
    }

    class Block {
        public long loc;
        public long length;

        Block() {
        }
    }
}

