/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationType;
import org.xith3d.loaders.models.animations.KeyFrame;
import org.xith3d.loaders.models.animations.ModelAnimation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyFrameController {
    private static final float UPDATE_DELAY = 0.015625f;
    private final AnimationType animType;
    private final KeyFrame[] frames;
    private KeyFrame lastFrame = null;
    private float nextAnimTime = -3.4028235E38f;
    private float previousAbsAnimTime = -3.4028235E38f;

    public final AnimationType getAnimationType() {
        return this.animType;
    }

    public final int getNumFrames() {
        return this.frames.length;
    }

    public final KeyFrame[] getKeyFrames() {
        return this.frames;
    }

    public final KeyFrame getKeyFrame(int index) {
        return this.frames[index];
    }

    public abstract Object getTarget();

    public void reset() {
        this.lastFrame = null;
        this.nextAnimTime = -3.4028235E38f;
        this.previousAbsAnimTime = -3.4028235E38f;
    }

    protected boolean checkUpdateConditions(boolean forced, float absAnimTime, int frame, float animDuration) {
        if (!forced && this.previousAbsAnimTime < absAnimTime && (this.getNumFrames() <= 1 ? this.getKeyFrame(frame) == this.lastFrame : absAnimTime < this.nextAnimTime)) {
            return false;
        }
        this.previousAbsAnimTime = absAnimTime;
        this.lastFrame = this.getKeyFrame(frame);
        this.nextAnimTime = (absAnimTime + 0.015625f) % animDuration;
        return true;
    }

    protected abstract void updateTarget(float var1, int var2, int var3, float var4, ModelAnimation var5);

    public void update(boolean forced, float absAnimTime, int baseFrame, int nextFrame, float alpha, ModelAnimation animation) {
        if (this.checkUpdateConditions(forced, absAnimTime, alpha > 0.5f ? nextFrame : baseFrame, animation.getDuration())) {
            this.updateTarget(absAnimTime, baseFrame, nextFrame, alpha, animation);
        }
    }

    public int update(boolean forced, float absAnimTime, ModelAnimation animation) {
        if (this.getNumFrames() == 1) {
            this.update(forced, absAnimTime, 0, 0, 0.5f, animation);
            return 0;
        }
        float time = absAnimTime / animation.getDuration();
        float frameDuration = animation.getDuration() / (float)this.getNumFrames();
        int baseFrame = (int)((float)this.getNumFrames() * time);
        int nextFrame = baseFrame == this.getNumFrames() - 1 ? 0 : baseFrame + 1;
        float frameT = absAnimTime % animation.getDuration() - (float)baseFrame * frameDuration;
        float alpha = frameT / frameDuration;
        this.update(forced, absAnimTime, baseFrame, nextFrame, alpha, animation);
        return baseFrame;
    }

    public abstract KeyFrameController sharedCopy(Map<String, NamedObject> var1);

    public KeyFrameController(AnimationType animType, KeyFrame[] frames) {
        this.animType = animType;
        this.frames = frames;
    }
}

