/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.animations;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AnimationType;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.MeshDeformationKeyFrame;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshDeformationKeyFrameController
extends KeyFrameController {
    private final Shape3D shape;

    public final MeshDeformationKeyFrame getFrame(int index) {
        return (MeshDeformationKeyFrame)this.getKeyFrame(index);
    }

    @Override
    public final Shape3D getTarget() {
        return this.shape;
    }

    @Override
    protected void updateTarget(float absAnimTime, int baseFrameIndex, int nextFrameIndex, float alpha, ModelAnimation animation) {
        int j;
        MeshDeformationKeyFrame baseFrame = this.getFrame(baseFrameIndex);
        MeshDeformationKeyFrame nextFrame = this.getFrame(nextFrameIndex);
        float[] coords0 = baseFrame.getCoordinates();
        float[] coords1 = nextFrame.getCoordinates();
        Geometry geom = this.shape.getGeometry();
        float[] buffer = new float[3];
        if (baseFrame == nextFrame) {
            geom.setCoordinates(0, coords0);
        } else {
            j = 0;
            for (int i = 0; i < coords0.length; i += 3) {
                buffer[0] = coords0[i + 0] + (coords1[i + 0] - coords0[i + 0]) * alpha;
                buffer[1] = coords0[i + 1] + (coords1[i + 1] - coords0[i + 1]) * alpha;
                buffer[2] = coords0[i + 2] + (coords1[i + 2] - coords0[i + 2]) * alpha;
                geom.setCoordinate(j++, buffer);
            }
        }
        if (baseFrame.getNormals() != null) {
            float[] normals0 = baseFrame.getNormals();
            float[] normals1 = nextFrame.getNormals();
            if (baseFrame == nextFrame) {
                geom.setNormals(0, normals0);
            } else {
                j = 0;
                for (int i = 0; i < normals0.length; i += 3) {
                    buffer[0] = normals0[i + 0] + (normals1[i + 0] - normals0[i + 0]) * alpha;
                    buffer[1] = normals0[i + 1] + (normals1[i + 1] - normals0[i + 1]) * alpha;
                    buffer[2] = normals0[i + 2] + (normals1[i + 2] - normals0[i + 2]) * alpha;
                    geom.setNormal(j++, buffer);
                }
            }
        }
    }

    @Override
    public MeshDeformationKeyFrameController sharedCopy(Map<String, NamedObject> namedObjects) {
        String shapeName = this.shape.getName();
        Shape3D newShape = (Shape3D)namedObjects.get(shapeName);
        if (newShape == null) {
            throw new Error("Can't clone this AnimationController!");
        }
        return new MeshDeformationKeyFrameController((MeshDeformationKeyFrame[])this.getKeyFrames(), newShape);
    }

    public MeshDeformationKeyFrameController(MeshDeformationKeyFrame[] frames, Shape3D shape) {
        super(AnimationType.MESH_DEFORMATION, frames);
        this.shape = shape;
    }
}

