/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.cal3d;

import org.jagatoo.loaders.models.cal3d.Cal3dController;
import org.jagatoo.loaders.models.cal3d.core.CalCoreAnimation;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalMesh;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSubmesh;
import org.openmali.spatial.bounds.BoundingBox;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.impl.cal3d.Cal3dSubmesh;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Node;

public class Cal3dModel
extends Model {
    private CalModel calModel;
    private Cal3dController controller;
    private float fps = 25.0f;
    private Appearance appearance;

    public CalModel getInternalModel() {
        return this.calModel;
    }

    public Cal3dController getCalController() {
        return this.controller;
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float fps) {
        this.fps = fps;
    }

    private float frameIndexToTime(int frameIndex) {
        return (float)frameIndex / this.fps;
    }

    private int timeToFrameIndex(float time) {
        return (int)(time * this.fps);
    }

    public void updateController(float time) {
        this.calModel.update(time);
        int numChildren = this.numChildren();
        for (int i = 0; i < numChildren; ++i) {
            Node spatial = this.getChild(i);
            if (!(spatial instanceof Cal3dSubmesh)) continue;
            Cal3dSubmesh tmp = (Cal3dSubmesh)spatial;
            tmp.doUpdate(this.calModel);
            tmp.updateBounds(false);
        }
    }

    public void interpolateAnimation(float animStartTime, float absAnimTime) {
        if (this.getCurrentAnimation() != null) {
            this.calModel.getMixer().clearAllAnims();
            this.calModel.getMixer().scrubToTime(this.getCurrentAnimation().getName(), absAnimTime);
            this.updateController(1000.0f);
        }
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    private void initializeNode() {
        int myCounter = 0;
        for (CalMesh mesh : this.calModel.getMeshes()) {
            for (CalSubmesh submesh : mesh.getSubmeshes()) {
                Cal3dSubmesh xithMesh = new Cal3dSubmesh("mesh : " + myCounter, submesh);
                ++myCounter;
                if (mesh.getCoreMesh().skin != null && !mesh.getCoreMesh().skin.equals("")) {
                    xithMesh.getAppearance().setTexture(0, mesh.getCoreMesh().skin);
                }
                if (mesh.getCoreMesh().material != null && !mesh.getCoreMesh().material.equals("")) {
                    CalCoreMaterial mat = this.calModel.getCoreModel().getCoreMaterial(mesh.getCoreMesh().material.toExternalForm());
                    Colorf ambient = mat.getAmbientColor();
                    Colorf diffuse = mat.getDiffuseColor();
                    Colorf specular = mat.getSpecularColor();
                    float shine = mat.getShininess();
                    Material mstate = new Material();
                    mstate.setShininess(shine);
                    mstate.setAmbientColor(ambient.getRed(), ambient.getGreen(), ambient.getBlue());
                    mstate.setDiffuseColor(diffuse.getRed(), diffuse.getGreen(), diffuse.getBlue());
                    mstate.setSpecularColor(specular.getRed(), specular.getGreen(), specular.getBlue());
                    mstate.setEmissiveColor(0.0f, 0.0f, 0.0f);
                    xithMesh.getAppearance().setMaterial(mstate);
                }
                xithMesh.setBounds(new BoundingBox());
                xithMesh.updateBounds(false);
                this.addChild(xithMesh);
                this.appearance = xithMesh.getAppearance();
            }
        }
    }

    protected void init(CalModel calModel) {
        this.calModel = calModel;
        this.initializeNode();
        ModelAnimation[] anims = new ModelAnimation[calModel.getCoreModel().getCoreAnimations().size()];
        int i = 0;
        for (CalCoreAnimation calAnim : calModel.getCoreModel().getCoreAnimations().values()) {
            anims[i++] = new ModelAnimation(calAnim.getName(), (int)(calAnim.getDuration() * this.fps), this.fps, null, calAnim);
        }
        this.setAnimations(anims);
        this.controller = new Cal3dController(calModel);
    }

    public Cal3dModel getSharedInstance() {
        Cal3dModel copy = new Cal3dModel();
        copy.setName(this.getName());
        copy.init(this.calModel);
        return copy;
    }

    protected Cal3dModel() {
    }
}

