/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.animations;

import org.jagatoo.loaders.models._util.AnimationType;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrame;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrameController;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.animations.PrecomputedAnimationKeyFrame;
import org.xith3d.loaders.models.animations.PrecomputedAnimationKeyFrameController;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransformGroup;

public class AnimationTools {
    private static Geometry copyGeometry(Geometry sourceGeom) {
        Geometry copy = sourceGeom.cloneNodeComponent(true);
        if (!sourceGeom.hasVertexAttributes() && !sourceGeom.isInterleaved()) {
            if (sourceGeom.hasColors()) {
                copy.setColorData(sourceGeom.getColorData());
            }
            if (sourceGeom.hasTextureCoordinates()) {
                for (int i = 0; i < sourceGeom.getNumTextureUnits(); ++i) {
                    copy.setTexCoordData(i, sourceGeom.getTexCoordsData(i));
                }
            }
        }
        return copy;
    }

    public static void precomputeAnimations(Model model, float fps) {
        ModelAnimation[] animations = model.getAnimations();
        for (int i = 0; i < animations.length; ++i) {
            for (int j = 0; j < animations[i].getControllers().length; ++j) {
                AnimationType animType = animations[i].getControllers()[j].getAnimationType();
                if (animType != AnimationType.MESH_TRANSFORM && animType != AnimationType.PRECOMPUTED) continue;
                throw new Error("Cannot precompute an animation of the type " + (Object)((Object)animType));
            }
        }
        ModelAnimation[] newAnimations = new ModelAnimation[animations.length];
        for (int i = 0; i < animations.length; ++i) {
            ModelAnimation animation = animations[i];
            int numFrames = (int)(fps * animation.getDuration());
            KeyFrameController[] controllers = new PrecomputedAnimationKeyFrameController[animation.getControllers().length];
            for (int j = 0; j < animation.getControllers().length; ++j) {
                KeyFrameController sourceController = animation.getControllers()[j];
                Shape3D shape = (Shape3D)sourceController.getTarget();
                PrecomputedAnimationKeyFrame[] frames = new PrecomputedAnimationKeyFrame[numFrames];
                for (int k = 0; k < numFrames; ++k) {
                    float absAnimTime = (float)k * animation.getDuration() / (float)numFrames;
                    sourceController.update(true, absAnimTime, animation);
                    Matrix4f[] mountTransforms = null;
                    if (model.getMountTransforms() != null) {
                        mountTransforms = new Matrix4f[model.getMountTransforms().length];
                        for (int m = 0; m < mountTransforms.length; ++m) {
                            model.getMountTransform(m).getTransform().get(mountTransforms[m]);
                        }
                    }
                    frames[k] = new PrecomputedAnimationKeyFrame(AnimationTools.copyGeometry(shape.getGeometry()));
                }
                controllers[j] = new PrecomputedAnimationKeyFrameController(frames, shape);
            }
            newAnimations[i] = new ModelAnimation(animation.getName(), numFrames, fps, controllers);
            newAnimations[i].setMountTransformFrames(animation.getMountTransformFrames());
        }
        model.setAnimations(newAnimations);
    }

    public static MeshTransformKeyFrameController createRotationalKeyFrameController(Vector3f axis, float startAngle, float stopAngle, boolean backwards, int numFrames, TransformGroup target) {
        float totalAngleDelta = stopAngle - startAngle;
        Matrix3f rot = Matrix3f.fromPool();
        MeshTransformKeyFrame[] frames = new MeshTransformKeyFrame[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            float time = (float)i / (float)numFrames;
            float angle = (startAngle + totalAngleDelta * time) % ((float)Math.PI * 2);
            if (backwards) {
                angle = (float)Math.PI * 2 - angle;
            }
            MatrixUtils.getRotationMatrix(axis, angle, rot);
            Matrix4f transform = new Matrix4f(rot);
            frames[i] = new MeshTransformKeyFrame(time, transform);
        }
        Matrix3f.toPool(rot);
        return new MeshTransformKeyFrameController(frames, target);
    }

    public static MeshTransformKeyFrameController createRotationalKeyFrameController(Vector3f axis, boolean backwards, int numFrames, TransformGroup target) {
        return AnimationTools.createRotationalKeyFrameController(axis, 0.0f, (float)Math.PI * 2, backwards, numFrames, target);
    }
}

