/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.util.specific;

import java.io.IOException;
import java.net.URL;
import org.jagatoo.loaders.models.md2.MD2TagFile;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.errorhandling.ParsingException;
import org.openmali.vecmath2.Matrix4f;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.scenegraph.TransformGroup;

public class MD2Tools {
    public static void readMD2Tags(URL tagFileURL, boolean convertZup2Yup, float scale, Model targetModel) throws IOException, IncorrectFormatException, ParsingException {
        MD2TagFile tagFile = new MD2TagFile(tagFileURL.openStream(), convertZup2Yup, scale);
        String[] tagNames = tagFile.getTagNames();
        Matrix4f[][] matrices = tagFile.getMatrices();
        TransformGroup[] mountTransforms = new TransformGroup[tagFile.getNumTags()];
        for (int i = 0; i < tagNames.length; ++i) {
            String tagName = tagNames[i];
            mountTransforms[i] = new TransformGroup(matrices[0][i]);
            mountTransforms[i].setName(tagName);
        }
        targetModel.setMountTransforms(mountTransforms);
        int offset = 0;
        for (int i = 0; i < targetModel.getAnimationsCount(); ++i) {
            ModelAnimation anim = targetModel.getAnimation(i);
            if (offset == 0 && matrices.length == anim.getNumFrames()) {
                anim.setMountTransformFrames(matrices);
            } else {
                Matrix4f[][] matrices2 = new Matrix4f[anim.getNumFrames()][];
                System.arraycopy(matrices, offset, matrices2, 0, anim.getNumFrames());
            }
            offset += anim.getNumFrames();
        }
    }

    public static void readMD2Tags(URL tagFile, Model targetModel) throws IOException, IncorrectFormatException, ParsingException {
        MD2Tools.readMD2Tags(tagFile, true, 1.0f, targetModel);
    }

    public static Model loadMultipartMD2Model(URL bodyURL, String bodySkin, URL bodyTagFile, String headMount, URL headURL, String headSkin, String weaponMount, URL weaponURL, String weaponSkin, float scale) throws IOException, IncorrectFormatException, ParsingException {
        ModelLoader loader = ModelLoader.getInstance();
        boolean convertZup2Yup = loader.getFlag(64) || loader.getFlag(32);
        Model body = loader.loadModel(bodyURL, bodySkin, scale);
        MD2Tools.readMD2Tags(bodyTagFile, convertZup2Yup, scale, body);
        if (headURL != null) {
            TransformGroup mt;
            Model head = loader.loadModel(headURL, headSkin, scale);
            if (head.hasAnimations()) {
                body.getAnimations()[0].attachAnimation(head.getAnimations()[0]);
            }
            if ((mt = body.getMountTransform(headMount)) != null) {
                mt.addChild(head);
            }
        }
        if (weaponURL != null) {
            TransformGroup mt2;
            Model weapon = loader.loadModel(weaponURL, weaponSkin, scale);
            if (weapon.hasAnimations()) {
                body.getAnimations()[0].attachAnimation(weapon.getAnimations()[0]);
            }
            if ((mt2 = body.getMountTransform(weaponMount)) != null) {
                mt2.addChild(weapon);
            }
        }
        return body;
    }

    public static Model loadMultipartMD2Model(URL bodyURL, String bodySkin, URL bodyTagFile, URL headURL, String headSkin, URL weaponURL, String weaponSkin, float scale) throws IOException, IncorrectFormatException, ParsingException {
        return MD2Tools.loadMultipartMD2Model(bodyURL, bodySkin, bodyTagFile, "tag_head", headURL, headSkin, "tag_rweapon", weaponURL, weaponSkin, scale);
    }

    public static Model loadMultipartMD2Model(URL bodyURL, String bodySkin, URL bodyTagFile, URL headURL, String headSkin, URL weaponURL, String weaponSkin) throws IOException, IncorrectFormatException, ParsingException {
        return MD2Tools.loadMultipartMD2Model(bodyURL, bodySkin, bodyTagFile, headURL, headSkin, weaponURL, weaponSkin, 1.0f);
    }
}

