/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.texture;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import org.jagatoo.loaders.textures.MipmapGenerator;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessor;
import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.util.image.ImageUtility;
import org.openmali.types.twodee.Dim2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loaders.texture.Xith3DTextureFactory2D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage2D;

public class TextureCreator {
    private static TextureCreator singletonInstance = null;
    private static Graphics2D metricsGraphics = null;
    private static BICache imageCache = new BICache(64, 30000L);
    public static final int TEXT_ALIGNMENT_HORIZONTAL_LEFT = 0;
    public static final int TEXT_ALIGNMENT_HORIZONTAL_CENTER = 1;
    public static final int TEXT_ALIGNMENT_HORIZONTAL_RIGHT = 2;

    @Deprecated
    public static TextureCreator getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new TextureCreator();
        }
        return singletonInstance;
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, int width, int height, Texture2D tex) {
        int orgWidth = img.getWidth();
        int orgHeight = img.getHeight();
        if (orgWidth != width || orgHeight != height) {
            img = ImageUtility.scaleImage(img, width, height, format.hasAlpha());
        }
        boolean flip = flipVertically != null ? flipVertically.getBooleanValue() : true;
        PixelProcessor pp = PixelProcessor.selectPixelProcessor(img, format);
        TextureImage2D ic = (TextureImage2D)pp.createTextureImage(img, orgWidth, orgHeight, format, flip, Xith3DTextureFactory2D.getInstance());
        tex.setImage(0, ic);
        if (mipmapMode == null || mipmapMode.booleanValue()) {
            MipmapGenerator.createMipMaps(ic, tex, Xith3DTextureFactory2D.getInstance());
        }
        return tex;
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, int width, int height) {
        Texture2D tex = new Texture2D(format);
        return TextureCreator.createTexture(img, flipVertically, format, mipmapMode, width, height, tex);
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, boolean allowStreching) {
        int height;
        int width;
        if (allowStreching) {
            width = ImageUtility.roundUpPower2(img.getWidth());
            height = ImageUtility.roundUpPower2(img.getHeight());
        } else {
            width = img.getWidth();
            height = img.getHeight();
        }
        return TextureCreator.createTexture(img, flipVertically, format, mipmapMode, width, height);
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return TextureCreator.createTexture(img, flipVertically, format, mipmapMode, true);
    }

    public static Texture2D createTexture(BufferedImage img, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return TextureCreator.createTexture(img, (TextureLoader.FlipMode)null, format, mipmapMode);
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, Texture.MipmapMode mipmapMode) {
        return TextureCreator.createTexture(img, flipVertically, TextureFormat.RGBA, mipmapMode);
    }

    public static Texture2D createTexture(BufferedImage img, Texture.MipmapMode mipmapMode) {
        return TextureCreator.createTexture(img, (TextureLoader.FlipMode)null, mipmapMode);
    }

    public static Texture2D createTexture(BufferedImage img, TextureFormat format, Texture.MipmapMode mipmapMode, int width, int height) {
        return TextureCreator.createTexture(img, null, format, mipmapMode, width, height);
    }

    public static Texture2D createTexture(BufferedImage img, TextureLoader.FlipMode flipVertically, Texture.MipmapMode mipmapMode, int width, int height) {
        return TextureCreator.createTexture(img, flipVertically, TextureFormat.RGBA, mipmapMode, width, height);
    }

    public static Texture2D createTexture(BufferedImage img, Texture.MipmapMode mipmapMode, int width, int height) {
        return TextureCreator.createTexture(img, (TextureLoader.FlipMode)null, mipmapMode, width, height);
    }

    public static Texture2D createTexture(TextureFormat format, int width, int height, Colorf color) {
        if (format == TextureFormat.LUMINANCE) {
            throw new UnsupportedOperationException("Creating Luminance Textures is not yet supported.");
        }
        TextureImageFormat tiFormat = format.getDefaultTextureImageFormat();
        Texture2D tex = new Texture2D(format);
        TextureImage2D ic = new TextureImage2D(tiFormat, width, height, width, height, false);
        ic.setImageData(null, ic.getDataSize());
        if (color != null) {
            ic.clear(color, false, null);
        } else {
            ic.clear(false, null);
        }
        tex.setImage(0, ic);
        return tex;
    }

    public static Texture2D createTexture(TextureFormat format, int width, int height) {
        return TextureCreator.createTexture(format, width, height, null);
    }

    private static TextMetrics getTextMetrics(String[] lines, Font font) {
        if (metricsGraphics == null) {
            BufferedImage image = new BufferedImage(1024, 128, 6);
            metricsGraphics = image.createGraphics();
        }
        int maxWidth = 0;
        int totalHeight = 0;
        FontMetrics metrics = metricsGraphics.getFontMetrics(font);
        int ascend = metrics.getAscent();
        int descend = metrics.getDescent();
        int lineHeight = ascend + descend;
        int[] lineWidths = new int[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            lineWidths[i] = metrics.stringWidth(lines[i]);
            if (lineWidths[i] > maxWidth) {
                maxWidth = lineWidths[i];
            }
            totalHeight += lineHeight;
        }
        return new TextMetrics(maxWidth, totalHeight, lineWidths, lineHeight, ascend, descend);
    }

    public static Texture2D createTexture(String text, Colorf color, Font font, int horizontalAlignment, boolean paddSizetoPower2) {
        int height;
        int width;
        String[] lines = text.split("\\n");
        TextMetrics metrics = TextureCreator.getTextMetrics(lines, font);
        if (paddSizetoPower2) {
            width = ImageUtility.roundUpPower2(metrics.width);
            height = ImageUtility.roundUpPower2(metrics.height);
        } else {
            width = metrics.width;
            height = metrics.height;
        }
        BufferedImage image = imageCache.getImage(width, height);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g2.clearRect(0, 0, width, height);
        if (color == null) {
            g2.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        } else {
            g2.setColor(color.getAWTColor());
        }
        g2.setFont(font);
        int left = 0;
        for (int i = 0; i < lines.length; ++i) {
            left = horizontalAlignment == 1 ? (metrics.width - metrics.lineWidths[i]) / 2 : (horizontalAlignment == 2 ? metrics.width - metrics.lineWidths[i] : 0);
            g2.drawString(lines[i], left, metrics.lineHeight * i + metrics.ascend);
        }
        Texture2D texture = TextureCreator.createTexture(image, TextureFormat.RGBA, Texture.MipmapMode.BASE_LEVEL);
        texture.setBoundaryModeS(TextureBoundaryMode.CLAMP);
        texture.setBoundaryModeT(TextureBoundaryMode.CLAMP);
        texture.setFilter(TextureFilter.TRILINEAR);
        if (paddSizetoPower2) {
            texture.setUserData("EFFECTIVE_SIZE", new Dim2i(metrics.width, metrics.height));
        }
        if (text.length() > 30) {
            texture.setName("Text: \"" + text.substring(0, 27) + "...\"");
        } else {
            texture.setName("Text: \"" + text + "\"");
        }
        return texture;
    }

    public static Texture2D createTexture(String text, Colorf color, Font font, int horizontalAlignment) {
        return TextureCreator.createTexture(text, color, font, horizontalAlignment, true);
    }

    public static class TextMetrics
    extends Dimension {
        private static final long serialVersionUID = 1L;
        private int lineHeight;
        private int ascend;
        private int descend;
        private int[] lineWidths;

        public final int getLineHeight() {
            return this.lineHeight;
        }

        public final int getAscend() {
            return this.ascend;
        }

        public final int getDescend() {
            return this.descend;
        }

        public TextMetrics(int width, int height, int[] lineWidths, int lineHeight, int ascend, int descend) {
            super(width, height);
            this.lineWidths = lineWidths;
            this.lineHeight = lineHeight;
            this.ascend = ascend;
            this.descend = descend;
        }
    }

    private static class BICache {
        private LinkedList<BIEntry> images = new LinkedList();
        private int capacity;
        private long maxAge;

        public BICache(int capacity, long maxAge) {
            this.capacity = capacity;
            this.maxAge = maxAge;
        }

        public BufferedImage getImage(int width, int height) {
            BIEntry candidate = null;
            BIEntry match = null;
            int size = this.images.size();
            Iterator it = this.images.iterator();
            for (int i = 0; i < size; ++i) {
                candidate = (BIEntry)it.next();
                if (candidate.image.getWidth() != width || candidate.image.getHeight() != height) continue;
                match = candidate;
                it.remove();
                break;
            }
            if (match == null) {
                match = new BIEntry(new BufferedImage(width, height, 6));
            }
            match.touch();
            this.images.addFirst(match);
            this.housekeep();
            return match.image;
        }

        public void housekeep() {
            if (this.images.size() > this.capacity || System.currentTimeMillis() > this.images.getLast().lastUsed + this.maxAge) {
                this.images.getLast();
            }
        }

        private static class BIEntry {
            final BufferedImage image;
            long lastUsed;

            public BIEntry(BufferedImage referent) {
                this.image = referent;
            }

            public void touch() {
                this.lastUsed = System.currentTimeMillis();
            }
        }
    }
}

