/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.texture;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import org.jagatoo.loaders.textures.AbstractTexture;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.AbstractTextureLoader;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.xith3d.loaders.texture.Xith3DTextureFactory2D;
import org.xith3d.loaders.texture.Xith3DTextureFactory3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture3D;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.TextureImage3D;

public class TextureLoader
extends AbstractTextureLoader {
    protected static Texture2D fallbackTexture = null;
    private static final TextureLoader instance = new TextureLoader();

    public static Texture2D getFallbackTexture() {
        if (fallbackTexture == null || fallbackTexture.getImage(0).getDataBuffer() == null) {
            fallbackTexture = new Texture2D(TextureFormat.RGB);
            fallbackTexture.setImage(0, new TextureImage2D(TextureImageFormat.LUMINANCE, 2, 2, new byte[]{0, -1, -1, 0}));
            fallbackTexture.setName("Fallback-Texture");
        }
        return fallbackTexture;
    }

    public static boolean isFallbackTexture(Texture tex) {
        return tex == TextureLoader.getFallbackTexture();
    }

    public static TextureLoader getInstance() {
        return instance;
    }

    public TextureImage2D loadTextureImage(String name, FlipMode flipVertically, TextureFormat format, boolean allowStreching) {
        boolean acceptAlpha;
        boolean flip = flipVertically == null || flipVertically.getBooleanValue();
        AbstractTextureImage texImg = this.loadTextureImage(name, flip, acceptAlpha = format == null || format.hasAlpha(), allowStreching, Xith3DTextureFactory2D.getInstance());
        if (texImg == null) {
            return (TextureImage2D)TextureLoader.getFallbackTexture().getImage(0);
        }
        return (TextureImage2D)texImg;
    }

    public final TextureImage2D loadTextureImage(String name, FlipMode flipVertically, TextureFormat format) {
        return this.loadTextureImage(name, flipVertically, format, true);
    }

    public final TextureImage2D loadTextureImage(String name, TextureFormat format) {
        return this.loadTextureImage(name, null, format, true);
    }

    public final TextureImage2D loadTextureImage(String name) {
        return this.loadTextureImage(name, null, null, true);
    }

    protected void onTextureLoaded(AbstractTexture texture, String resourceName) {
        ((Texture)texture).setResourceName(resourceName);
    }

    public Texture2D getTexture(String name, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, boolean allowStreching, boolean useCache, boolean writeToCache) {
        boolean loadMipmaps;
        boolean acceptAlpha;
        boolean flip = flipVertically == null || flipVertically.getBooleanValue();
        AbstractTexture tex = this.loadOrGetTexture(name, flip, acceptAlpha = format == null || format.hasAlpha(), loadMipmaps = mipmapMode == null || mipmapMode.booleanValue(), allowStreching, Xith3DTextureFactory2D.getInstance(), useCache, writeToCache);
        if (tex == null) {
            return TextureLoader.getFallbackTexture();
        }
        return (Texture2D)tex;
    }

    public Texture2D getTexture(String name, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, boolean allowStreching) {
        return this.getTexture(name, flipVertically, format, mipmapMode, allowStreching, true, true);
    }

    public final Texture2D getTexture(String name, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.getTexture(name, flipVertically, format, mipmapMode, true);
    }

    public Texture2D getTexture(String name, FlipMode flipVertically) {
        return this.getTexture(name, flipVertically, null, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
    }

    public Texture2D getTexture(String name) {
        return this.getTexture(name, (FlipMode)null);
    }

    public Texture2D getTexture(String name, FlipMode flipVertically, Texture.MipmapMode mipmapMode) {
        return this.getTexture(name, flipVertically, null, mipmapMode);
    }

    public Texture2D getTexture(String name, TextureFormat format) {
        return this.getTexture(name, null, format, null);
    }

    public Texture2D getTexture(String name, Texture.MipmapMode mipmapMode) {
        return this.getTexture(name, (FlipMode)null, mipmapMode);
    }

    public Texture2D getTexture(String name, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.getTexture(name, null, format, mipmapMode);
    }

    public Texture2D getTextureOrNull(String textureName, Texture.MipmapMode mipmapMode) {
        Texture2D texture = this.getTexture(textureName, mipmapMode);
        if (TextureLoader.isFallbackTexture(texture)) {
            return null;
        }
        return texture;
    }

    public Texture2D getTextureOrNull(String textureName) {
        return this.getTextureOrNull(textureName, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
    }

    public Texture2D loadTexture(URL imageURL, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, boolean allowStreching) {
        boolean loadMipmaps;
        boolean acceptAlpha;
        boolean flip = flipVertically == null || flipVertically.getBooleanValue();
        AbstractTexture tex = this.loadTextureFromURL(imageURL, flip, acceptAlpha = format == null || format.hasAlpha(), loadMipmaps = mipmapMode == null || mipmapMode.booleanValue(), allowStreching, Xith3DTextureFactory2D.getInstance());
        if (tex == null) {
            return TextureLoader.getFallbackTexture();
        }
        return (Texture2D)tex;
    }

    public Texture2D loadTexture(URL imageURL, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(imageURL, flipVertically, format, mipmapMode, true);
    }

    public Texture2D loadTexture(URL imageURL, FlipMode flipVertically) {
        return this.loadTexture(imageURL, flipVertically, (TextureFormat)null, (Texture.MipmapMode)null);
    }

    public Texture2D loadTexture(URL imageURL) {
        return this.loadTexture(imageURL, (FlipMode)null);
    }

    public Texture2D loadTexture(URL imageURL, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(imageURL, (FlipMode)null, mipmapMode);
    }

    public Texture2D loadTexture(URL imageURL, TextureFormat format) {
        return this.loadTexture(imageURL, (FlipMode)null, format, (Texture.MipmapMode)null);
    }

    public Texture2D loadTexture(URL imageURL, FlipMode flipVertically, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(imageURL, flipVertically, (TextureFormat)null, mipmapMode);
    }

    public Texture2D loadTexture(URL imageURL, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(imageURL, (FlipMode)null, format, mipmapMode);
    }

    public Texture2D loadTexture(InputStream in, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode, boolean allowStreching) {
        boolean loadMipmaps;
        boolean acceptAlpha;
        boolean flip;
        AbstractTexture tex;
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        if ((tex = this.loadTextureFromStream((BufferedInputStream)in, flip = flipVertically == null || flipVertically.getBooleanValue(), acceptAlpha = format == null || format.hasAlpha(), loadMipmaps = mipmapMode == null || mipmapMode.booleanValue(), allowStreching, Xith3DTextureFactory2D.getInstance())) == null) {
            return TextureLoader.getFallbackTexture();
        }
        return (Texture2D)tex;
    }

    public Texture2D loadTexture(InputStream in, FlipMode flipVertically, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(in, flipVertically, format, mipmapMode, true);
    }

    public Texture2D loadTexture(InputStream in, FlipMode flipVertically) {
        return this.loadTexture(in, flipVertically, (TextureFormat)null, (Texture.MipmapMode)null);
    }

    public Texture2D loadTexture(InputStream in) {
        return this.loadTexture(in, (FlipMode)null);
    }

    public Texture2D loadTexture(InputStream in, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(in, (FlipMode)null, mipmapMode);
    }

    public Texture2D loadTexture(InputStream in, TextureFormat format) {
        return this.loadTexture(in, (FlipMode)null, format, (Texture.MipmapMode)null);
    }

    public Texture2D loadTexture(InputStream in, FlipMode flipVertically, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(in, flipVertically, (TextureFormat)null, mipmapMode);
    }

    public Texture2D loadTexture(InputStream in, TextureFormat format, Texture.MipmapMode mipmapMode) {
        return this.loadTexture(in, (FlipMode)null, format, mipmapMode);
    }

    public Texture3D loadTexture3D(String[] names, FlipMode flipVertically, TextureFormat format) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("names must not be null or of length 0.");
        }
        int depth = names.length;
        boolean flip = flipVertically == null || flipVertically.getBooleanValue();
        boolean acceptAlpha = format == null || format.hasAlpha();
        Xith3DTextureFactory3D texFactory = new Xith3DTextureFactory3D(depth);
        TextureImage3D texImg = null;
        for (int i = 0; i < depth; ++i) {
            AbstractTextureImage absTexImg = this.loadTextureImage(names[i], flip, acceptAlpha, true, texFactory);
            if (absTexImg == null) {
                texFactory.skipOneImage();
                continue;
            }
            texImg = (TextureImage3D)absTexImg;
        }
        if (texImg == null) {
            return null;
        }
        TextureFormat actualFormat = format;
        Texture3D tex = new Texture3D(actualFormat);
        tex.setImage(0, texImg);
        return tex;
    }

    public final Texture3D loadTexture3D(String[] names, TextureFormat format) {
        return this.loadTexture3D(names, null, format);
    }

    public final Texture3D loadTexture3D(String[] names) {
        return this.loadTexture3D(names, null, null);
    }

    private TextureLoader() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlipMode {
        NOT_FLIPPED,
        FLIPPED_VERTICALLY;


        public final boolean getBooleanValue() {
            return this == FLIPPED_VERTICALLY;
        }
    }
}

