/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loop.opscheduler.impl;

import java.util.ArrayList;
import java.util.List;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BunchAnimatable
implements Animatable {
    private final boolean persistent;
    private boolean alive = false;
    private boolean animating = false;
    private final ArrayList<Animatable> subAnims;
    private long lastGameTime = 0L;
    private UpdatingThread.TimingMode lastTimingMode = UpdatingThread.TimingMode.MICROSECONDS;

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void startAnimation(long gameTime, UpdatingThread.TimingMode timingMode) {
        this.animating = true;
        for (int i = 0; i < this.subAnims.size(); ++i) {
            this.subAnims.get(i).startAnimation(gameTime, timingMode);
        }
    }

    @Override
    public void stopAnimation() {
        this.animating = false;
        for (int i = 0; i < this.subAnims.size(); ++i) {
            this.subAnims.get(i).stopAnimation();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animating;
    }

    public final void addAnimatable(Animatable animatable) {
        this.subAnims.add(animatable);
        if (this.isAnimating()) {
            for (int i = 0; i < this.subAnims.size(); ++i) {
                this.subAnims.get(i).startAnimation(this.lastGameTime, this.lastTimingMode);
            }
        }
    }

    public final boolean removeAnimatable(Animatable animatable) {
        return this.subAnims.remove(animatable);
    }

    public final ArrayList<Animatable> getAnimatables() {
        return this.subAnims;
    }

    @Override
    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        this.lastGameTime = gameTime;
        this.lastTimingMode = timingMode;
        int i = 0;
        while (i < this.subAnims.size()) {
            Animatable anim = this.subAnims.get(i);
            if (anim.isAlive()) {
                anim.update(gameTime, frameTime, timingMode);
                ++i;
                continue;
            }
            this.subAnims.remove(i);
        }
    }

    public BunchAnimatable(boolean persistent, List<Animatable> subAnims) {
        this.persistent = persistent;
        if (subAnims != null && subAnims instanceof ArrayList) {
            this.subAnims = (ArrayList)subAnims;
        } else {
            this.subAnims = new ArrayList(subAnims.size());
            for (int i = 0; i < subAnims.size(); ++i) {
                this.subAnims.add(subAnims.get(i));
            }
        }
    }

    public BunchAnimatable(boolean persistent, Animatable[] subAnims) {
        this.persistent = persistent;
        if (subAnims == null) {
            this.subAnims = new ArrayList();
        } else {
            this.subAnims = new ArrayList(subAnims.length);
            for (int i = 0; i < subAnims.length; ++i) {
                this.subAnims.add(subAnims[i]);
            }
        }
    }

    public BunchAnimatable(boolean persistent) {
        this(persistent, (List<Animatable>)null);
    }

    public BunchAnimatable() {
        this(true, (List<Animatable>)null);
    }
}

