/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics;

import java.util.Vector;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.Joint;
import org.xith3d.physics.simulation.joints.FixedJoint;
import org.xith3d.physics.simulation.joints.Hinge2Joint;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Line;

public class PhysicsGFXManager
implements Updatable {
    private final Vector<Collideable> colliders = new Vector();
    private final Vector<TransformGroup> colliderNodes = new Vector();
    private final Vector<Body> bodies = new Vector();
    private final Vector<TransformGroup> bodyNodes = new Vector();
    private final boolean inverse;

    public final boolean isInverse() {
        return this.inverse;
    }

    public final int getNumItems() {
        return this.colliders.size() + this.bodies.size();
    }

    public final TransformGroup directAdd(Collideable collider, TransformGroup node2, GroupNode parentGroup) {
        this.colliders.add(collider);
        this.colliderNodes.add(node2);
        PhysicsGFXManager.update(collider, node2);
        if (parentGroup != null) {
            parentGroup.addChild(node2);
        }
        return node2;
    }

    public final TransformGroup directAdd(Collideable collider, GroupNode parentGroup) {
        TransformGroup node2 = new TransformGroup();
        Node gfx = collider.getBaseGFX();
        gfx.detach();
        node2.addChild(gfx);
        return this.directAdd(collider, node2, parentGroup);
    }

    public final TransformGroup directAdd(Body body, TransformGroup node2, GroupNode parentGroup) {
        this.bodies.add(body);
        this.bodyNodes.add(node2);
        PhysicsGFXManager.update(body, node2);
        if (parentGroup != null) {
            parentGroup.addChild(node2);
        }
        return node2;
    }

    public final TransformGroup directAdd(Body body, GroupNode parentGroup) {
        TransformGroup node2 = new TransformGroup();
        int n = body.getCollideablesCount();
        for (int i = 0; i < n; ++i) {
            Collideable collider = body.getCollideable(i);
            Node gfx = collider.getBaseGFX();
            gfx.detach();
            node2.addChild(gfx);
            this.directAdd(body, node2, parentGroup);
        }
        return node2;
    }

    public final void directAdd(Joint joint, GroupNode parentGroup, Colorf lineColor, float lineWidth) {
        TransformGroup node1 = null;
        if (joint.getBody1() != null) {
            node1 = this.directAdd(joint.getBody1(), parentGroup);
        }
        if (joint.getBody2() != null) {
            this.directAdd(joint.getBody2(), parentGroup);
        }
        if (joint instanceof FixedJoint) {
            Vector3f vec = Vector3f.fromPool();
            vec.sub(joint.getBody2().getPosition(), joint.getBody1().getPosition());
            Line line = new Line((Tuple3f)vec, lineWidth, lineColor);
            node1.addChild(line);
            Vector3f.toPool(vec);
        } else if (joint instanceof HingeJoint) {
            HingeJoint hJoint = (HingeJoint)joint;
            Vector3f vec = Vector3f.fromPool();
            vec.sub(hJoint.getAnchor(), joint.getBody1().getPosition());
            Line line = new Line((Tuple3f)vec, lineWidth, lineColor);
            node1.addChild(line);
            Vector3f.toPool(vec);
        } else if (joint instanceof Hinge2Joint) {
            Hinge2Joint h2Joint = (Hinge2Joint)joint;
            Vector3f vec = Vector3f.fromPool();
            vec.sub(joint.getBody1().getPosition(), h2Joint.getAnchor());
            Line line = new Line((Tuple3f)vec, lineWidth, lineColor);
            node1.addChild(line);
            Vector3f.toPool(vec);
        }
    }

    public final TransformGroup add(Collideable collider, TransformGroup node2) {
        return this.directAdd(collider, node2, null);
    }

    public final TransformGroup add(Collideable collider) {
        return this.directAdd(collider, null);
    }

    public final void removeCollider(int index) {
        this.colliders.remove(index);
        this.colliderNodes.remove(index);
    }

    public final void remove(Collideable collider) {
        int index = this.colliders.indexOf(collider);
        if (index >= 0) {
            this.removeCollider(index);
        }
    }

    public final TransformGroup add(Body body, TransformGroup node2) {
        return this.directAdd(body, node2, null);
    }

    public final TransformGroup add(Body body) {
        return this.directAdd(body, null);
    }

    public final void removeBody(int index) {
        this.bodies.remove(index);
        this.bodyNodes.remove(index);
    }

    public final void remove(Body body) {
        int index = this.bodies.indexOf(body);
        if (index >= 0) {
            this.removeBody(index);
        }
    }

    public final void remove(Joint joint) {
        if (joint.getBody1() != null) {
            this.remove(joint.getBody1());
        }
        if (joint.getBody2() != null) {
            this.remove(joint.getBody2());
        }
    }

    public final void remove(TransformGroup node2) {
        int index = this.colliderNodes.indexOf(node2);
        if (index >= 0) {
            this.removeCollider(index);
        } else {
            index = this.bodyNodes.indexOf(node2);
            if (index >= 0) {
                this.removeBody(index);
            }
        }
    }

    public final void clear() {
        this.colliders.clear();
        this.colliderNodes.clear();
        this.bodies.clear();
        this.bodyNodes.clear();
    }

    public final Collideable getCollider(int index) {
        return this.colliders.get(index);
    }

    public final Body getBody(int index) {
        return this.bodies.get(index);
    }

    public final TransformGroup getColliderGFX(int index) {
        return this.colliderNodes.get(index);
    }

    public final TransformGroup getBodyGFX(int index) {
        return this.bodyNodes.get(index);
    }

    private static final void update(Collideable collider, TransformGroup node2) {
        Transform3D t3d = node2.getTransform();
        t3d.setRotation(collider.getWorldRotMat());
        t3d.setTranslation(collider.getWorldPos());
        node2.setTransform(t3d);
    }

    private static final void update(Body body, TransformGroup node2) {
        Transform3D t3d = node2.getTransform();
        t3d.setRotation(body.getRotationMatrix());
        t3d.setTranslation(body.getPosition());
        node2.setTransform(t3d);
    }

    private static final void updateInverse(Collideable collider, TransformGroup node2) {
        Matrix3f m = Matrix3f.fromPool();
        collider.setRotationMatrix(node2.getTransform().getRotation(m));
        Matrix3f.toPool(m);
        Vector3f t = Vector3f.fromPool();
        collider.setPosition(node2.getTransform().getTranslation(t));
        Vector3f.toPool(t);
    }

    private static final void updateInverse(Body body, TransformGroup node2) {
        Matrix3f m = Matrix3f.fromPool();
        body.setRotationMatrix(node2.getTransform().getRotation(m));
        Matrix3f.toPool(m);
        Vector3f t = Vector3f.fromPool();
        body.setPosition(node2.getTransform().getTranslation(t));
        Vector3f.toPool(t);
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.inverse) {
            int i;
            for (i = 0; i < this.colliders.size(); ++i) {
                PhysicsGFXManager.updateInverse(this.colliders.get(i), this.colliderNodes.get(i));
            }
            for (i = 0; i < this.bodies.size(); ++i) {
                PhysicsGFXManager.updateInverse(this.bodies.get(i), this.bodyNodes.get(i));
            }
        } else {
            int i;
            for (i = 0; i < this.colliders.size(); ++i) {
                PhysicsGFXManager.update(this.colliders.get(i), this.colliderNodes.get(i));
            }
            for (i = 0; i < this.bodies.size(); ++i) {
                PhysicsGFXManager.update(this.bodies.get(i), this.bodyNodes.get(i));
            }
        }
    }

    public PhysicsGFXManager(boolean inverse) {
        this.inverse = inverse;
    }

    public PhysicsGFXManager() {
        this(false);
    }
}

