/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision;

import java.util.ArrayList;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollideableGroupType;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;

public abstract class CollideableGroupBase
extends CollideableBase
implements CollideableGroup {
    private final CollideableGroupType type;
    private final ArrayList<Collideable> collideables;

    public Group getBaseGFX() {
        Group group = new Group();
        for (int i = 0; i < this.collideables.size(); ++i) {
            Node node2 = this.collideables.get(i).getBaseGFX();
            if (node2 == null) continue;
            group.addChild(node2);
        }
        return group;
    }

    public Group getDebugGFX() {
        Group group = new Group();
        for (int i = 0; i < this.collideables.size(); ++i) {
            Node node2 = this.collideables.get(i).getDebugGFX();
            if (node2 == null) continue;
            group.addChild(node2);
        }
        return group;
    }

    public final String getInfo() {
        return this.type.getInfo();
    }

    public final CollideableGroupType getGroupType() {
        return this.type;
    }

    public final String getType() {
        return this.type.getName();
    }

    public void addCollideable(Collideable c) {
        this.collideables.add(c);
    }

    public void removeCollideable(Collideable c) {
        this.collideables.remove(c);
    }

    public final void removeAllCollideables() {
        for (int i = this.collideables.size() - 1; i >= 0; --i) {
            this.removeCollideable(this.collideables.get(i));
        }
    }

    public final Collideable getChild(int i) {
        return this.collideables.get(i);
    }

    public final int getChildrenCount() {
        return this.collideables.size();
    }

    public CollideableGroupBase(CollisionEngine engine, CollideableGroupType type) {
        super(engine);
        this.type = type;
        this.collideables = new ArrayList();
    }
}

