/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Box;

public abstract class BoxCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Box gfxObject = null;
    private final Tuple3f size;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Texture texture) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        defaultAppearance.setTexture(texture);
    }

    public static void setDefaultAppearance(String texture) {
        BoxCollideable.setDefaultAppearance(TextureLoader.getInstance().getTexture(texture));
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A box collideable. One can adjust its x,y,z size";
    }

    public final String getType() {
        return "Box";
    }

    public Box getBaseGFX() {
        if (this.gfxObject == null) {
            this.gfxObject = defaultAppearance == null ? new Box(this.size.getX(), this.size.getY(), this.size.getZ(), 11, false, 2) : new Box(this.size.getX(), this.size.getY(), this.size.getZ(), defaultAppearance.cloneNodeComponent(false));
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Box getDebugGFX() {
        Box shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public void setSize(float width, float height, float depth) {
        if (this.gfxObject != null) {
            float qx = width / this.size.getX();
            float qy = height / this.size.getY();
            float qz = depth / this.size.getZ();
            StaticTransform.scale(this.gfxObject, qx, qy, qz);
        }
        this.size.set(width, height, depth);
    }

    public final void setSize(Tuple3f size) {
        this.setSize(size.getX(), size.getY(), size.getZ());
    }

    public final Tuple3f getSize() {
        return this.size.getReadOnly();
    }

    public BoxCollideable(CollisionEngine eng, float xSize, float ySize, float zSize) {
        super(eng);
        this.size = new Tuple3f(xSize, ySize, zSize);
    }

    public BoxCollideable(CollisionEngine eng, Tuple3f size) {
        this(eng, size.getX(), size.getY(), size.getZ());
    }
}

