/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Quad;
import org.xith3d.scenegraph.primitives.Rectangle;

public abstract class PlaneCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Quad gfxObject;
    private Vector3f normal;
    private float d;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Texture texture) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        texture.setFilter(TextureFilter.TRILINEAR);
        defaultAppearance.setTexture(texture);
    }

    public static void setDefaultAppearance(String texture) {
        PlaneCollideable.setDefaultAppearance(TextureLoader.getInstance().getTexture(texture));
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A plane is like a rectangle that extends infinitely in all directions..it is not placeable but has a normal and a point which it should contain";
    }

    public final String getType() {
        return "Plane";
    }

    public Quad getBaseGFX() {
        if (this.gfxObject == null) {
            Rectangle shape;
            float INF = 100.0f;
            if (defaultAppearance != null) {
                shape = new Rectangle(100.0f, 100.0f, defaultAppearance.getTexture());
                shape.setAppearance(defaultAppearance.cloneNodeComponent(false));
                shape.setTexturePosition(new Tuple2f(shape.getWidth(), shape.getHeight()));
            } else {
                shape = new Rectangle(100.0f, 100.0f, new Colorf(1.0f, 0.7f, 0.6f, 0.0f));
            }
            StaticTransform.translate(shape, 0.0f, 0.0f, this.getD());
            Vector3f n0 = new Vector3f(0.0f, 0.0f, 1.0f);
            Vector3f normal = this.getNormal();
            Vector3f axis = new Vector3f();
            axis.cross(n0, normal);
            float angle = n0.angle(normal);
            if (angle > 3.1405928f) {
                axis.set((TupleNf)Vector3f.POSITIVE_Y_AXIS);
            } else if (angle < 0.001f) {
                axis.set((TupleNf)Vector3f.NEGATIVE_Y_AXIS);
            }
            StaticTransform.rotate(shape, (Tuple3f)axis, angle);
            this.gfxObject = shape;
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Quad getDebugGFX() {
        Quad shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public final Vector3f getNormal() {
        return this.normal.getReadOnly();
    }

    public void setD(float d) {
        this.d = d;
    }

    public final float getD() {
        return this.d;
    }

    public PlaneCollideable(CollisionEngine eng, float a, float b, float c, float d) {
        super(eng);
        this.normal = new Vector3f(a, b, c);
        this.d = d;
        this.gfxObject = null;
    }

    public PlaneCollideable(CollisionEngine eng, Vector3f normal, float d) {
        this(eng, normal.getX(), normal.getY(), normal.getZ(), d);
    }

    public PlaneCollideable(CollisionEngine eng, Vector3f normal, Point3f point) {
        this(eng, normal, point.getX() * normal.getX() + point.getY() * normal.getY() + point.getZ() * normal.getZ());
    }
}

