/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import net.java.dev.joode.geom.Box;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.joode.JoodeBody;

public class JoodeBoxCollideable
extends BoxCollideable
implements JoodeCollideable {
    private final Box joodeGeom;
    private Matrix3 rotMatrix3 = null;

    public void setBody(Body body) {
        super.setBody(body);
        this.getJOODEGeom().setBody(((JoodeBody)this.getBody()).getJOODEBody());
    }

    public JoodeBoxCollideable(JoodeCollisionEngine eng, Tuple3f size) {
        this(eng, size.getX(), size.getY(), size.getZ());
    }

    public JoodeBoxCollideable(JoodeCollisionEngine eng, float xSize, float ySize, float zSize) {
        super(eng, xSize, ySize, zSize);
        this.joodeGeom = new Box(null, xSize, ySize, zSize);
        this.init(eng, this.joodeGeom);
    }

    public void setSize(float width, float height, float depth) {
        super.setSize(width, height, depth);
        this.joodeGeom.setSide(width, height, depth);
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE(this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData(this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final Box getJOODEGeom() {
        return this.joodeGeom;
    }

    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

