/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.java.dev.joode.collision.Contact;
import net.java.dev.joode.collision.collider.Colliders;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import org.jagatoo.util.versioning.Version;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollideableGroupType;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionEngineVendorInformation;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.collideable.CapsuleCollideable;
import org.xith3d.physics.collision.collideable.PlaneCollideable;
import org.xith3d.physics.collision.collideable.RayCollideable;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.physics.collision.joode.JoodeBoxCollideable;
import org.xith3d.physics.collision.joode.JoodeCapsuleCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideableGroup;
import org.xith3d.physics.collision.joode.JoodeCylinderCollideable;
import org.xith3d.physics.collision.joode.JoodePlaneCollideable;
import org.xith3d.physics.collision.joode.JoodeRayCollideable;
import org.xith3d.physics.collision.joode.JoodeSphereCollideable;
import org.xith3d.physics.collision.joode.JoodeTriMeshCollideable;
import org.xith3d.physics.joode.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoodeCollisionEngine
extends CollisionEngine
implements NearCallback {
    private static CollisionEngineVendorInformation vendorInfo;
    private final Contact[] contactsBuffer = new Contact[1000];
    private boolean ignoreStatic = false;
    private int collisionsCount = 0;

    private final void fillContactBuffer() {
        int i = 0;
        while (i < this.contactsBuffer.length) {
            this.contactsBuffer[i] = new Contact();
            ++i;
        }
    }

    public JoodeCollisionEngine() {
        this.fillContactBuffer();
    }

    private static final JoodeCollideable getCollideable(Geom geom) {
        return (JoodeCollideable)geom.getUserData();
    }

    @Override
    public void call(Object userData, Geom geom1, Geom geom2) {
        if (userData instanceof CollisionListener) {
            CollisionListener listener = (CollisionListener)userData;
            this.checkCollisions(geom1, geom2, this.ignoreStatic, null, listener);
        } else {
            ArrayList collisions = (ArrayList)userData;
            this.checkCollisions(geom1, geom2, this.ignoreStatic, collisions, null);
        }
    }

    @Override
    public boolean ignoreStatic() {
        return this.ignoreStatic;
    }

    private final void checkCollisions_1x1(Geom geom1, Geom geom2, ArrayList<Collision> collisions, CollisionListener listener) {
        JoodeCollideable c1 = JoodeCollisionEngine.getCollideable(geom1);
        JoodeCollideable c2 = JoodeCollisionEngine.getCollideable(geom2);
        int count = Colliders.collide(geom1, geom2, this.contactsBuffer, 0, this.ignoreStatic);
        int i = 0;
        while (i < count) {
            Collision collision;
            Contact contact = this.contactsBuffer[i];
            if (listener == null) {
                collision = new Collision(Convert.toXithPoint(contact.getPosition()), Convert.toXith(contact.getNormal()), contact.getDepth(), c1, c2);
                collisions.add(collision);
            } else {
                collision = Collision.fromPool(null, null, contact.getDepth(), c1, c2);
                Convert.toXith(contact.getPosition(), collision.getPosition());
                Convert.toXith(contact.getNormal(), collision.getNormal());
                listener.onCollision(collision);
                Collision.toPool(collision);
            }
            ++this.collisionsCount;
            ++i;
        }
    }

    private final void checkCollisions_1xn(Geom geom, Space space, ArrayList<Collision> collisions, CollisionListener listener) {
        if (listener == null) {
            space.collide(collisions, geom, false, this);
        } else {
            space.collide(listener, geom, false, this);
        }
    }

    private final void checkCollisions_nx1(Space space, Geom geom, ArrayList<Collision> collisions, CollisionListener listener) {
        if (listener == null) {
            space.collide(collisions, geom, true, this);
        } else {
            space.collide(listener, geom, true, this);
        }
    }

    private final void checkCollisions_nxn(Space space1, Space space2, ArrayList<Collision> collisions, CollisionListener listener) {
        if (listener == null) {
            space1.collide(collisions, space2, true, this);
        } else {
            space1.collide(listener, space2, true, this);
        }
    }

    private final void checkCollisions(Geom geom1, Geom geom2, boolean ignoreStatic, ArrayList<Collision> collisions, CollisionListener listener) {
        this.ignoreStatic = ignoreStatic;
        try {
            boolean c1_isSpace = geom1 instanceof Space;
            boolean c2_isSpace = geom2 instanceof Space;
            if (c1_isSpace && c2_isSpace) {
                this.checkCollisions_nxn((Space)geom1, (Space)geom2, collisions, listener);
            } else if (!c1_isSpace && c2_isSpace) {
                this.checkCollisions_1xn(geom1, (Space)geom2, collisions, listener);
            } else if (c1_isSpace && !c2_isSpace) {
                this.checkCollisions_nx1((Space)geom1, geom2, collisions, listener);
            } else if (!c1_isSpace && !c2_isSpace) {
                this.checkCollisions_1x1(geom1, geom2, collisions, listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final int checkCollisions(Collideable c1, Collideable c2, boolean ignoreStatic, ArrayList<Collision> collisions) {
        this.collisionsCount = 0;
        collisions.clear();
        Geom geom1 = ((JoodeCollideable)c1).getJOODEGeom();
        Geom geom2 = ((JoodeCollideable)c2).getJOODEGeom();
        this.checkCollisions(geom1, geom2, ignoreStatic, collisions, null);
        return this.collisionsCount;
    }

    @Override
    public final int checkCollisions(Collideable c1, Collideable c2, boolean ignoreStatic, CollisionListener listener) {
        this.collisionsCount = 0;
        Geom geom1 = ((JoodeCollideable)c1).getJOODEGeom();
        Geom geom2 = ((JoodeCollideable)c2).getJOODEGeom();
        this.checkCollisions(geom1, geom2, ignoreStatic, null, listener);
        return this.collisionsCount;
    }

    private final void checkCollisions(CollideableGroup group, boolean ignoreStatic, ArrayList<Collision> collisions, CollisionListener listener) {
        this.ignoreStatic = ignoreStatic;
        Space space = ((JoodeCollideableGroup)group).getJOODEGeom();
        if (listener == null) {
            space.collideAll(collisions, this);
        } else {
            space.collideAll(listener, this);
        }
    }

    @Override
    public final int checkCollisions(CollideableGroup group, boolean ignoreStatic, ArrayList<Collision> collisions) {
        this.collisionsCount = 0;
        collisions.clear();
        this.checkCollisions(group, ignoreStatic, collisions, null);
        return this.collisionsCount;
    }

    @Override
    public final int checkCollisions(CollideableGroup group, boolean ignoreStatic, CollisionListener listener) {
        this.collisionsCount = 0;
        this.checkCollisions(group, ignoreStatic, null, listener);
        return this.collisionsCount;
    }

    @Override
    public List<CollideableGroupType> getGroupTypes() {
        return JoodeCollideableGroup.getTypes();
    }

    @Override
    public CollideableGroup newGroup(String type) {
        JoodeCollideableGroup s = null;
        try {
            s = new JoodeCollideableGroup(this, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("The JOODE implementation\nof the Xith3D Physics Abstraction layer doesn't have the\nspace type \"" + type + "\" available... Check you have" + "\nused the correct case, e.g. \"Simple\", not \"simple\"" + "Complete exception : " + e);
        }
        return s;
    }

    @Override
    public CollideableGroup newGroup() {
        return this.newGroup("Simple");
    }

    @Override
    public CollisionEngineVendorInformation getVendorInformation() {
        if (vendorInfo == null) {
            URL url = null;
            try {
                url = new URL("http://joode.sourceforge.net/");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            vendorInfo = new CollisionEngineVendorInformation("JOODE", url, new Version(1, 0, 0, "", 0), "Implementation of the Xith3D Collision Detection Abstraction Layer with the JOODE Collision Engine -- Amos Wenger, Marvin Froehlich");
        }
        return vendorInfo;
    }

    @Override
    public RayCollideable newRay(float originX, float originY, float originZ, float directionX, float directionY, float directionZ) {
        return new JoodeRayCollideable(this, originX, originY, originZ, directionX, directionY, directionZ);
    }

    @Override
    public BoxCollideable newBox(float xSize, float ySize, float zSize) {
        return new JoodeBoxCollideable(this, xSize, ySize, zSize);
    }

    @Override
    public JoodeCylinderCollideable newCylinder(float radius, float length) {
        return new JoodeCylinderCollideable(this, radius, length);
    }

    @Override
    public CapsuleCollideable newCapsule(float radius, float length) {
        return new JoodeCapsuleCollideable(this, radius, length);
    }

    @Override
    public SphereCollideable newSphere(float radius) {
        return new JoodeSphereCollideable(this, radius);
    }

    @Override
    public TriMeshCollideable newTriMesh(Tuple3f[] vertices, int[] indices) {
        if (indices == null) {
            indices = new int[vertices.length];
            int i = 0;
            while (i < indices.length) {
                indices[i] = i;
                ++i;
            }
        }
        return new JoodeTriMeshCollideable(this, Convert.toJOODE(vertices), indices);
    }

    @Override
    public PlaneCollideable newPlane(Vector3f normal, Point3f point) {
        return new JoodePlaneCollideable(this, normal, point);
    }

    @Override
    public PlaneCollideable newPlane(Vector3f normal, float d) {
        return new JoodePlaneCollideable(this, normal, d);
    }

    @Override
    public PlaneCollideable newPlane(float a, float b, float c, float d) {
        return new JoodePlaneCollideable(this, a, b, c, d);
    }
}

