/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.joode;

import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.collideable.RayCollideable;
import org.xith3d.physics.collision.joode.JoodeCollideable;
import org.xith3d.physics.collision.joode.JoodeCollisionEngine;
import org.xith3d.physics.joode.Convert;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.joode.JoodeBody;

public class JoodeRayCollideable
extends RayCollideable
implements JoodeCollideable {
    private final Matrix3f rotOffset = new Matrix3f(Matrix3f.IDENTITY);
    private final Ray joodeGeom = new Ray(null, this.getLength());
    private Matrix3 rotMatrix3 = null;

    public void setBody(Body body) {
        super.setBody(body);
        this.getJOODEGeom().setBody(((JoodeBody)this.getBody()).getJOODEBody());
    }

    public JoodeRayCollideable(JoodeCollisionEngine eng, Tuple3f origin, Tuple3f direction) {
        this(eng, origin.getX(), origin.getY(), origin.getZ(), direction.getX(), direction.getY(), direction.getZ());
    }

    public JoodeRayCollideable(JoodeCollisionEngine eng, float originX, float originY, float originZ, float directionX, float directionY, float directionZ) {
        super(eng, originX, originY, originZ, directionX, directionY, directionZ);
        this.setOrigin(originX, originY, originZ);
        this.setDirection(directionX, directionY, directionZ);
        this.init(eng, this.joodeGeom);
    }

    public void setOrigin(float x, float y, float z) {
        super.setOrigin(x, y, z);
        this.joodeGeom.setPosition(x, y, z);
    }

    public void setDirection(float x, float y, float z) {
        super.setDirection(x, y, z);
        MatrixUtils.computeRotation(x, y, z, 0.0f, 0.0f, 1.0f, 1, this.rotOffset);
    }

    protected void recomputeWorldRotMat(Matrix3f worldRot, boolean applyToImplementation) {
        if (this.getParent() == null) {
            worldRot.setIdentity();
        } else {
            this.getParent().getWorldRotMat(worldRot);
        }
        worldRot.mul(this.getRotationMatrix());
        worldRot.mul(this.rotOffset);
        if (applyToImplementation) {
            this.applyWorldRotation(worldRot);
        }
    }

    private final void init(JoodeCollisionEngine engine, Geom geom) {
        boolean cfr_ignored_0 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setPosition(Convert.toJOODE(this.getWorldPos()));
        }
        boolean cfr_ignored_1 = geom instanceof Space;
        if (geom.isPlaceable()) {
            geom.setRotation(Convert.toJOODE(this.getWorldRotMat()));
        }
        geom.setUserData(this);
    }

    public void finalize() {
        this.joodeGeom.setUserData(null);
    }

    public JoodeCollisionEngine getEngine() {
        return (JoodeCollisionEngine)super.getEngine();
    }

    public final Ray getJOODEGeom() {
        return this.joodeGeom;
    }

    public void setParent(CollideableGroup parent) {
        super.setParent(parent);
    }

    public final void setEnabled(boolean enabled) {
        this.getJOODEGeom().setEnabled(enabled);
    }

    public final boolean isEnabled() {
        return this.getJOODEGeom().isEnabled();
    }

    protected void applyWorldRotation(Matrix3f worldRot) {
        if (this.rotMatrix3 == null) {
            this.rotMatrix3 = new Matrix3();
        }
        Convert.toJOODE(worldRot, this.rotMatrix3);
        this.joodeGeom.setRotation(this.rotMatrix3);
    }

    protected void applyWorldPosition(Tuple3f worldPos) {
        this.joodeGeom.setPosition(worldPos.getX(), worldPos.getY(), worldPos.getZ());
    }
}

