/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.simulation.joode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.java.dev.joode.World;
import net.java.dev.joode.collision.Contact;
import net.java.dev.joode.force.NewtonGravity;
import net.java.dev.joode.joint.JointContact;
import net.java.dev.joode.joint.JointGroupID;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.joode.Convert;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.Joint;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.SurfaceParameters;
import org.xith3d.physics.simulation.joints.BallJoint;
import org.xith3d.physics.simulation.joints.FixedJoint;
import org.xith3d.physics.simulation.joints.Hinge2Joint;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.physics.simulation.joints.SliderJoint;
import org.xith3d.physics.simulation.joode.JoodeBody;
import org.xith3d.physics.simulation.joode.JoodeJoint;
import org.xith3d.physics.simulation.joode.JoodeSimulationEngine;
import org.xith3d.physics.simulation.joode.JoodeSurfaceParameters;
import org.xith3d.physics.simulation.joode.joints.JoodeBallJoint;
import org.xith3d.physics.simulation.joode.joints.JoodeFixedJoint;
import org.xith3d.physics.simulation.joode.joints.JoodeHinge2Joint;
import org.xith3d.physics.simulation.joode.joints.JoodeHingeJoint;
import org.xith3d.physics.simulation.joode.joints.JoodeSliderJoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoodeSimulationWorld
extends SimulationWorld {
    private final JoodeSimulationEngine joodeEngine;
    private final World joodeWorld;
    private final JointGroupID contactGroup = new JointGroupID();
    private final HashMap<String, Integer> stepperFunctions;
    private final String DEFAULT_STEPPER_FUNCTION;
    private String stepperFunction;
    private final NewtonGravity newtonGravity;
    private final ArrayList<JointContact> jointContactCache = new ArrayList(128);
    private int nextJointContact = 0;

    public JoodeSimulationWorld(JoodeSimulationEngine engine) {
        super(engine);
        this.joodeEngine = engine;
        this.joodeWorld = new World();
        this.newtonGravity = new NewtonGravity(this.joodeWorld, this.getGravity().getX(), this.getGravity().getY(), this.getGravity().getZ());
        this.stepperFunctions = new HashMap();
        this.stepperFunctions.put("AccurateSimple", 4);
        this.stepperFunctions.put("Simple", 2);
        this.stepperFunctions.put("Euler", 0);
        this.stepperFunctions.put("Rk4", 1);
        this.stepperFunctions.put("QuickStep", 3);
        this.DEFAULT_STEPPER_FUNCTION = "Euler";
        this.setStepperFunction(null);
        int i = 0;
        while (i < 128) {
            this.jointContactCache.add(new JointContact(null, new Contact()));
            ++i;
        }
    }

    @Override
    public JoodeSimulationEngine getEngine() {
        return this.joodeEngine;
    }

    public World getJOODEWorld() {
        return this.joodeWorld;
    }

    @Override
    protected void setGravityImpl(float x, float y, float z) {
        this.newtonGravity.setGravity(x, y, z);
    }

    @Override
    protected Body newBodyImpl() {
        return new JoodeBody(this);
    }

    @Override
    protected void addBodyImpl(Body body) {
        this.joodeWorld.addBody(((JoodeBody)body).getJOODEBody());
    }

    @Override
    protected void removeBodyImpl(Body body) {
        this.joodeWorld.removeBody(((JoodeBody)body).getJOODEBody());
    }

    @Override
    protected BallJoint newBallJointImpl(Body body1, Body body2) {
        return new JoodeBallJoint(this, body1, body2);
    }

    @Override
    protected FixedJoint newFixedJointImpl(Body body1, Body body2) {
        return new JoodeFixedJoint(this, body1, body2);
    }

    @Override
    protected HingeJoint newHingeJointImpl(Body body1, Body body2) {
        return new JoodeHingeJoint(this, body1, body2);
    }

    @Override
    protected Hinge2Joint newHinge2JointImpl(Body body1, Body body2) {
        return new JoodeHinge2Joint(this, body1, body2);
    }

    @Override
    protected SliderJoint newSliderJointImpl(Body body1, Body body2) {
        return new JoodeSliderJoint(this, body1, body2);
    }

    @Override
    protected void addJointImpl(Joint joint) {
        this.joodeWorld.addJoint(((JoodeJoint)((Object)joint)).getJOODEJoint());
    }

    @Override
    protected void removeJointImpl(Joint joint) {
        this.joodeWorld.removeJoint(((JoodeJoint)((Object)joint)).getJOODEJoint());
    }

    @Override
    public Set<String> getStepperFunctions() {
        return this.stepperFunctions.keySet();
    }

    @Override
    public void setStepperFunction(String stepperFunction) {
        if (stepperFunction == null) {
            this.stepperFunction = this.DEFAULT_STEPPER_FUNCTION;
        } else if (this.stepperFunctions.keySet().contains(stepperFunction)) {
            this.stepperFunction = stepperFunction;
        } else {
            if (this.stepperFunction == null) {
                this.stepperFunction = this.DEFAULT_STEPPER_FUNCTION;
            }
            System.err.println("The stepper function : " + stepperFunction + " isn't recognized as" + "\n one of JOODE's supported stepper functions. It has been ignored." + "\n Valid stepperFunctions are : " + this.stepperFunctions.keySet() + "\n This list can be obtained via the getStepperFunctions() method");
        }
        this.joodeWorld.setStepFunction(this.stepperFunctions.get(this.stepperFunction));
    }

    @Override
    public String getStepperFunction() {
        return this.stepperFunction;
    }

    @Override
    protected final void beforeStep() {
    }

    @Override
    protected void stepImpl(long stepMicros) {
        this.joodeWorld.step((float)stepMicros / 1000000.0f);
        this.contactGroup.clear();
        this.joodeWorld.removeJointContacts();
        this.nextJointContact = 0;
    }

    @Override
    protected final void afterStep() {
    }

    private final JointContact aquireJointContact(SurfaceParameters surfParams) {
        JointContact jointContact;
        net.java.dev.joode.collision.SurfaceParameters joodeSurfaceParams = ((JoodeSurfaceParameters)surfParams).getJOODESurfaceParameters();
        if (this.jointContactCache.size() <= this.nextJointContact) {
            jointContact = new JointContact(null, new Contact(joodeSurfaceParams, null));
            this.jointContactCache.add(jointContact);
        } else {
            jointContact = this.jointContactCache.get(this.nextJointContact);
            jointContact.getContact().init();
            jointContact.getContact().setSurfaceParameters(joodeSurfaceParams);
        }
        ++this.nextJointContact;
        return jointContact;
    }

    private static final void translateFDir(Object fdirObj, Contact contact) {
        if (fdirObj == null) {
            contact.setFDir1(null);
            return;
        }
        if (!(fdirObj instanceof Vector3f)) {
            System.err.println("Unsupported fdir value " + fdirObj);
            return;
        }
        if (contact.getFDir1() == null) {
            contact.setFDir1(Convert.toJOODE((Vector3f)fdirObj));
        } else {
            Convert.toJOODE((Vector3f)fdirObj, contact.getFDir1());
        }
    }

    @Override
    public void resolveCollision(Collision collision, Body body1, Body body2, SurfaceParameters surfParams) {
        JointContact jointContact = this.aquireJointContact(surfParams);
        Contact contact = jointContact.getContact();
        contact.getSurfaceParameters().setMu(surfParams.getFloatParameter("mu"));
        JoodeSimulationWorld.translateFDir(surfParams.getParameter("fdir1"), contact);
        Convert.toJOODE(collision.getPosition(), contact.getPosition());
        Convert.toJOODE(collision.getNormal(), contact.getNormal());
        contact.setDepth(collision.getDepth());
        jointContact.attach(body1 == null ? null : ((JoodeBody)body1).getJOODEBody(), body2 == null ? null : ((JoodeBody)body2).getJOODEBody());
        this.joodeWorld.addJoint(jointContact);
        this.contactGroup.add(jointContact);
    }
}

