/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickDispatcher
implements PickListener {
    private final LinkedList<PickListener> listeners = new LinkedList();
    private PickListener[] copy = new PickListener[8];

    public void addPickListener(PickListener listener) {
        this.listeners.add(listener);
    }

    public void removePickListener(PickListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean testIntersectionsInWorldSpaceForPicking() {
        if (this.listeners.size() > 0) {
            return this.listeners.getFirst().testIntersectionsInWorldSpaceForPicking();
        }
        return false;
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        this.copy = this.listeners.toArray(this.copy);
        int length = this.listeners.size();
        for (int i = 0; i < length; ++i) {
            PickListener pickListener = this.copy[i];
            try {
                pickListener.onObjectPicked(nearest, userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        Arrays.fill(this.copy, null);
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        this.copy = this.listeners.toArray(this.copy);
        int length = this.listeners.size();
        for (int i = 0; i < length; ++i) {
            PickListener pickListener = this.copy[i];
            try {
                pickListener.onObjectsPicked(pickResults, userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        Arrays.fill(this.copy, null);
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        this.copy = this.listeners.toArray(this.copy);
        int length = this.listeners.size();
        for (int i = 0; i < length; ++i) {
            PickListener pickListener = this.copy[i];
            try {
                pickListener.onPickingMissed(userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        Arrays.fill(this.copy, null);
    }
}

