/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jagatoo.input.devices.components.MouseButton;
import org.openmali.spatial.polygons.Triangle;
import org.openmali.vecmath2.Ray3f;
import org.xith3d.picking.PickRay;
import org.xith3d.picking.PickRequest;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.utility.general.CircularArray;
import org.xith3d.utility.general.SortableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PickPool {
    private static CircularArray<PickRequest> pickRequests = new CircularArray(32);
    private static CircularArray<List<GroupNode>> groupLists = new CircularArray(128);
    private static CircularArray<PickRay> pickRays = new CircularArray(128);
    private static CircularArray<Ray3f> rays = new CircularArray(128);
    private static CircularArray<Triangle> triangles = new CircularArray(128);
    private static CircularArray<SortableList<PickResult>> prLists = new CircularArray(128);
    private static CircularArray<Stack<Node>> nodeStacks = new CircularArray(128);
    private static CircularArray<PickResult> pickResults = new CircularArray(512);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PickRequest allocatePickRequest(RenderPass renderPass, List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, Object pl, Object userObject, boolean pickAll) {
        CircularArray<PickRequest> circularArray = pickRequests;
        synchronized (circularArray) {
            PickRequest preq = pickRequests.isEmpty() ? new PickRequest() : pickRequests.pop();
            if (groups.size() == 1) {
                preq.init(renderPass, groups.get(0), canvas, button, mouseX, mouseY, pl, userObject, pickAll);
            } else {
                new Error("Picking on more than one group is not yet supported").printStackTrace();
            }
            return preq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PickRequest allocatePickRequest(RenderPass renderPass, GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, Object pl, Object userObject, boolean pickAll) {
        CircularArray<PickRequest> circularArray = pickRequests;
        synchronized (circularArray) {
            PickRequest preq = pickRequests.isEmpty() ? new PickRequest() : pickRequests.pop();
            preq.init(renderPass, group, canvas, button, mouseX, mouseY, pl, userObject, pickAll);
            return preq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deallocatePickRequest(PickRequest preq) {
        CircularArray<PickRequest> circularArray = pickRequests;
        synchronized (circularArray) {
            pickRequests.push(preq);
        }
    }

    public static List<GroupNode> allocateGroupList() {
        if (groupLists.isEmpty()) {
            return new ArrayList<GroupNode>();
        }
        List<GroupNode> list = groupLists.pop();
        list.clear();
        return list;
    }

    public static void deallocateGroupList(List<GroupNode> groupList) {
        groupLists.push(groupList);
    }

    public static PickRay allocatePickRay() {
        if (pickRays.isEmpty()) {
            return new PickRay();
        }
        return pickRays.pop();
    }

    public static void deallocatePickRay(PickRay pickRay) {
        pickRays.push(pickRay);
    }

    public static Ray3f allocateRay3f() {
        if (rays.isEmpty()) {
            return new Ray3f();
        }
        return rays.pop();
    }

    public static void deallocateRay3f(Ray3f ray) {
        rays.push(ray);
    }

    public static Triangle allocateTriangle() {
        Triangle result = triangles.isEmpty() ? new Triangle() : triangles.pop();
        result.setFeatures(1);
        return result;
    }

    public static void deallocateTriangle(Triangle triangle) {
        triangles.push(triangle);
    }

    public static SortableList<PickResult> allocatePickResultList() {
        if (prLists.isEmpty()) {
            return new SortableList<PickResult>();
        }
        SortableList<PickResult> list = prLists.pop();
        list.clear();
        return list;
    }

    public static void deallocatePickResultList(SortableList<PickResult> prList) {
        prLists.push(prList);
    }

    public static Stack<Node> allocateNodeStack() {
        if (nodeStacks.isEmpty()) {
            return new Stack<Node>();
        }
        return nodeStacks.pop();
    }

    public static void deallocateNodeStack(Stack<Node> nodeStack) {
        nodeStacks.push(nodeStack);
    }

    public static PickResult allocatePickResult() {
        if (pickResults.isEmpty()) {
            return new PickResult();
        }
        return pickResults.pop();
    }

    public static void deallocatePickResult(PickResult pickResult) {
        pickResults.push(pickResult);
    }

    private PickPool() {
    }
}

