/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.devices.components.MouseButton;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.loop.opscheduler.util.SchedOpsPool;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.GroupNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledPicker
extends ScheduledOperationImpl {
    private List<GroupNode> groups;
    private Canvas3D canvas;
    private MouseButton button;
    private int posX;
    private int posY;
    private AllPickListener allPickListener;
    private NearestPickListener nearestPickListener;
    private Object userObject;
    private boolean pickAll;

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public AllPickListener getAllPickListener() {
        return this.allPickListener;
    }

    public NearestPickListener getNearestPickListener() {
        return this.nearestPickListener;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    public int getMouseX() {
        return this.posX;
    }

    public int getMouseY() {
        return this.posY;
    }

    @Override
    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (!this.pickAll) {
            PickingLibrary.pickNearest(this.groups, this.canvas, this.button, this.getMouseX(), this.getMouseY(), this.nearestPickListener, this.getUserObject());
        } else {
            PickingLibrary.pickAll(this.groups, this.canvas, this.button, this.getMouseX(), this.getMouseY(), this.allPickListener, this.getUserObject());
        }
        SchedOpsPool.deallocateScheduledPicker(this);
    }

    public void init(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this.groups.clear();
        for (int i = 0; i < groups.size(); ++i) {
            this.groups.add(groups.get(i));
        }
        this.canvas = canvas;
        this.button = button;
        this.posX = mouseX;
        this.posY = mouseY;
        this.allPickListener = pl;
        this.setUserObject(userObject);
        this.pickAll = true;
    }

    public void init(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this.groups.clear();
        for (int i = 0; i < groups.size(); ++i) {
            this.groups.add(groups.get(i));
        }
        this.canvas = canvas;
        this.button = button;
        this.posX = mouseX;
        this.posY = mouseY;
        this.nearestPickListener = pl;
        this.setUserObject(userObject);
        this.pickAll = false;
    }

    public ScheduledPicker() {
        super(false);
        this.groups = ScheduledPicker.createGsList(null);
    }

    public ScheduledPicker(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        super(false);
        this.init(groups, canvas, button, mouseX, mouseY, pl, userObject);
    }

    private static List<GroupNode> createGsList(GroupNode group) {
        ArrayList<GroupNode> groups = new ArrayList<GroupNode>();
        if (group != null) {
            groups.add(group);
        }
        return groups;
    }

    public ScheduledPicker(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl, Object userObject) {
        this(ScheduledPicker.createGsList(group), canvas, button, mouseX, mouseY, pl, userObject);
    }

    public ScheduledPicker(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this(groups, canvas, button, mouseX, mouseY, pl, (Object)null);
    }

    public ScheduledPicker(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, AllPickListener pl) {
        this(group, canvas, button, mouseX, mouseY, pl, (Object)null);
    }

    public ScheduledPicker(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        super(false);
        this.init(groups, canvas, button, mouseX, mouseY, pl, userObject);
    }

    public ScheduledPicker(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl, Object userObject) {
        this(ScheduledPicker.createGsList(group), canvas, button, mouseX, mouseY, pl, userObject);
    }

    public ScheduledPicker(List<? extends GroupNode> groups, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this(groups, canvas, button, mouseX, mouseY, pl, (Object)null);
    }

    public ScheduledPicker(GroupNode group, Canvas3D canvas, MouseButton button, int mouseX, int mouseY, NearestPickListener pl) {
        this(group, canvas, button, mouseX, mouseY, pl, (Object)null);
    }
}

