/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;

public final class Canvas3DFactory {
    private static DisplayMode createDisplayMode(OpenGLLayer layer, int width, int height, int bpp, int frequency) {
        DisplayModeSelector modeSelector = DisplayModeSelector.getImplementation(layer);
        DisplayMode displayMode = modeSelector.getBestMode(width, height, bpp, frequency);
        if (displayMode == null) {
            displayMode = new DisplayMode(null, null, width, height, DisplayMode.getDefaultBPP(), DisplayMode.getDefaultFrequency());
        }
        return displayMode;
    }

    private static DisplayMode createDisplayMode(OpenGLLayer layer, int width, int height, int bpp) {
        return Canvas3DFactory.createDisplayMode(layer, width, height, bpp, DisplayMode.getDefaultFrequency());
    }

    private static DisplayMode createDisplayMode(OpenGLLayer layer, int width, int height) {
        return Canvas3DFactory.createDisplayMode(layer, width, height, DisplayMode.getDefaultBPP());
    }

    private static OpenGLLayer getOpenGLLayer(DisplayMode dspMode) {
        if (dspMode.getOpenGLLayer() == null) {
            return OpenGLLayer.getDefault();
        }
        return dspMode.getOpenGLLayer();
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthbufferSize, Object owner) {
        CanvasPeer canvasPeer;
        Class<?> canvasPeerClass;
        assert (layer != null);
        assert (dspMode != null);
        assert (fsaa != null);
        try {
            canvasPeerClass = Class.forName(layer.getCanvasPeerImplClassName());
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        Object[] params = new Object[]{owner, dspMode, fullscreen, vsync, fsaa, depthbufferSize};
        try {
            canvasPeer = (CanvasPeer)canvasPeerClass.getConstructors()[0].newInstance(params);
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new Error(t.getMessage(), t);
        }
        Canvas3D canvas = new Canvas3D(canvasPeer);
        canvas.enableLighting();
        return canvas;
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, vsync, fsaa, 16, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, DisplayMode.VSYNC_ENABLED, fsaa, owner);
    }

    public Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, Object owner) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, vsync, FSAA.OFF, owner);
    }

    public Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, Object owner) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, FSAA.OFF, owner);
    }

    public static Canvas3D create(CanvasConstructionInfo canvasInfo, Object owner) {
        Canvas3D canvas = Canvas3DFactory.create(canvasInfo.getOpenGLLayer(), canvasInfo.getDisplayMode(), canvasInfo.getFullscreenMode(), canvasInfo.isVSyncEnabled(), canvasInfo.getFSAAMode(), owner);
        if (!canvasInfo.getFullscreenMode().isFullscreen()) {
            canvas.setTitle(canvasInfo.getTitle());
        }
        return canvas;
    }

    public static Canvas3D create(CanvasConstructionInfo canvasInfo, String windowTitle) {
        Canvas3D canvas = Canvas3DFactory.create(canvasInfo.getOpenGLLayer(), canvasInfo.getDisplayMode(), canvasInfo.getFullscreenMode(), canvasInfo.isVSyncEnabled(), canvasInfo.getFSAAMode(), (Object)null);
        if (!canvasInfo.getFullscreenMode().isFullscreen()) {
            if (windowTitle == null) {
                windowTitle = canvasInfo.getTitle();
            }
            if (windowTitle == null) {
                canvas.setTitle("Powered by Xith3D");
            } else {
                canvas.setTitle(windowTitle);
            }
        }
        return canvas;
    }

    public static Canvas3D create(CanvasConstructionInfo canvasInfo) {
        return Canvas3DFactory.create(canvasInfo, canvasInfo.getTitle());
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        Canvas3D canvas = Canvas3DFactory.create(layer, dspMode, fullscreen, vsync, fsaa, (Object)null);
        canvas.setTitle(title);
        return canvas;
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        Canvas3D canvas = Canvas3DFactory.create(layer, dspMode, fullscreen, fsaa, (Object)null);
        canvas.setTitle(title);
        return canvas;
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, vsync, FSAA.OFF, title);
    }

    public static Canvas3D create(OpenGLLayer layer, DisplayMode dspMode, DisplayMode.FullscreenMode fullscreen, String title) {
        return Canvas3DFactory.create(layer, dspMode, fullscreen, FSAA.OFF, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, fsaa, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, fsaa, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, FSAA.OFF, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, FSAA.OFF, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, vsync, fsaa, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, fsaa, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(null, width, height), fullscreen, vsync, FSAA.OFF, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, Object owner) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(null, width, height), fullscreen, FSAA.OFF, owner);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, fsaa, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, fsaa, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, vsync, FSAA.OFF, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height, bpp), fullscreen, FSAA.OFF, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, vsync, fsaa, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, fsaa, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, vsync, FSAA.OFF, title);
    }

    public static Canvas3D create(OpenGLLayer layer, int width, int height, DisplayMode.FullscreenMode fullscreen, String title) {
        return Canvas3DFactory.create(layer, Canvas3DFactory.createDisplayMode(layer, width, height), fullscreen, FSAA.OFF, title);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, vsync, fsaa, owner);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, Object owner) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, fsaa, owner);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, Object owner) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, vsync, FSAA.OFF, owner);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, Object owner) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, FSAA.OFF, owner);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, vsync, fsaa, title);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, FSAA fsaa, String title) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, fsaa, title);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, boolean vsync, String title) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, vsync, FSAA.OFF, title);
    }

    public static Canvas3D create(int width, int height, int bpp, DisplayMode.FullscreenMode fullscreen, String title) {
        return Canvas3DFactory.create(OpenGLLayer.getDefault(), Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), width, height, bpp), fullscreen, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, DisplayMode dspMode, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, dspMode, DisplayMode.WINDOWED, fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, DisplayMode dspMode, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, dspMode, DisplayMode.WINDOWED, fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, DisplayMode dspMode, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(layer, dspMode, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, DisplayMode dspMode, String title) {
        return Canvas3DFactory.createWindowed(layer, dspMode, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, int bpp, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, width, height, bpp, DisplayMode.WINDOWED, vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, int bpp, FSAA fsaa, String title) {
        return Canvas3DFactory.create(layer, width, height, bpp, DisplayMode.WINDOWED, fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, int bpp, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, bpp, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, int bpp, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, bpp, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, DisplayMode.getDefaultBPP(), vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, DisplayMode.getDefaultBPP(), fsaa, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(OpenGLLayer layer, int width, int height, String title) {
        return Canvas3DFactory.createWindowed(layer, width, height, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(int width, int height, int bpp, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(OpenGLLayer.getDefault(), width, height, bpp, vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(int width, int height, int bpp, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(OpenGLLayer.getDefault(), width, height, bpp, fsaa, title);
    }

    public static Canvas3D createWindowed(int width, int height, int bpp, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(width, height, bpp, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(int width, int height, int bpp, String title) {
        return Canvas3DFactory.createWindowed(width, height, bpp, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(int width, int height, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(width, height, DisplayMode.getDefaultBPP(), vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(int width, int height, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(width, height, DisplayMode.getDefaultBPP(), fsaa, title);
    }

    public static Canvas3D createWindowed(int width, int height, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(width, height, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(int width, int height, String title) {
        return Canvas3DFactory.createWindowed(width, height, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(DisplayMode dspMode, boolean vsync, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(DisplayMode dspMode, FSAA fsaa, String title) {
        return Canvas3DFactory.createWindowed(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, fsaa, title);
    }

    public static Canvas3D createWindowed(DisplayMode dspMode, boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(DisplayMode dspMode, String title) {
        return Canvas3DFactory.createWindowed(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(boolean vsync, FSAA fsaa, String title) {
        Dimension dtsSize = Toolkit.getDefaultToolkit().getScreenSize();
        return Canvas3DFactory.createWindowed(Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), dtsSize.width, dtsSize.height), vsync, fsaa, title);
    }

    public static Canvas3D createWindowed(FSAA fsaa, String title) {
        Dimension dtsSize = Toolkit.getDefaultToolkit().getScreenSize();
        return Canvas3DFactory.createWindowed(Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), dtsSize.width, dtsSize.height), fsaa, title);
    }

    public static Canvas3D createWindowed(boolean vsync, String title) {
        return Canvas3DFactory.createWindowed(vsync, FSAA.OFF, title);
    }

    public static Canvas3D createWindowed(String title) {
        return Canvas3DFactory.createWindowed(FSAA.OFF, title);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, DisplayMode dspMode, boolean vsync, FSAA fsaa) {
        return Canvas3DFactory.create(layer, dspMode, DisplayMode.FULLSCREEN, vsync, fsaa, (Object)null);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, DisplayMode dspMode, FSAA fsaa) {
        return Canvas3DFactory.create(layer, dspMode, DisplayMode.FULLSCREEN, fsaa, (Object)null);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, DisplayMode dspMode, boolean vsync) {
        return Canvas3DFactory.createFullscreen(layer, dspMode, vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, DisplayMode dspMode) {
        return Canvas3DFactory.createFullscreen(layer, dspMode, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, int bpp, boolean vsync, FSAA fsaa) {
        return Canvas3DFactory.create(layer, width, height, bpp, DisplayMode.FULLSCREEN, vsync, fsaa, (Object)null);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, int bpp, FSAA fsaa) {
        return Canvas3DFactory.create(layer, width, height, bpp, DisplayMode.FULLSCREEN, fsaa, (Object)null);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, int bpp, boolean vsync) {
        return Canvas3DFactory.createFullscreen(layer, width, height, bpp, vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, int bpp) {
        return Canvas3DFactory.createFullscreen(layer, width, height, bpp, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, boolean vsync, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(layer, width, height, DisplayMode.getDefaultBPP(), vsync, fsaa);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(layer, width, height, DisplayMode.getDefaultBPP(), fsaa);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height, boolean vsync) {
        return Canvas3DFactory.createFullscreen(layer, width, height, vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(OpenGLLayer layer, int width, int height) {
        return Canvas3DFactory.createFullscreen(layer, width, height, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(int width, int height, boolean vsync, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(OpenGLLayer.getDefault(), width, height, vsync, fsaa);
    }

    public static Canvas3D createFullscreen(int width, int height, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(OpenGLLayer.getDefault(), width, height, fsaa);
    }

    public static Canvas3D createFullscreen(int width, int height, boolean vsync) {
        return Canvas3DFactory.createFullscreen(width, height, vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(int width, int height) {
        return Canvas3DFactory.createFullscreen(width, height, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(DisplayMode dspMode, boolean vsync, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, vsync, fsaa);
    }

    public static Canvas3D createFullscreen(DisplayMode dspMode, FSAA fsaa) {
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, fsaa);
    }

    public static Canvas3D createFullscreen(DisplayMode dspMode, boolean vsync) {
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(DisplayMode dspMode) {
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.getOpenGLLayer(dspMode), dspMode, FSAA.OFF);
    }

    public static Canvas3D createFullscreen(boolean vsync, FSAA fsaa) {
        Dimension dtsSize = Toolkit.getDefaultToolkit().getScreenSize();
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), dtsSize.width, dtsSize.height), vsync, fsaa);
    }

    public static Canvas3D createFullscreen(FSAA fsaa) {
        Dimension dtsSize = Toolkit.getDefaultToolkit().getScreenSize();
        return Canvas3DFactory.createFullscreen(Canvas3DFactory.createDisplayMode(OpenGLLayer.getDefault(), dtsSize.width, dtsSize.height), fsaa);
    }

    public static Canvas3D createFullscreen(boolean vsync) {
        return Canvas3DFactory.createFullscreen(vsync, FSAA.OFF);
    }

    public static Canvas3D createFullscreen() {
        return Canvas3DFactory.createFullscreen(FSAA.OFF);
    }

    private Canvas3DFactory() {
    }
}

