/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.render.Cursor;
import org.jagatoo.input.render.InputSourceWindow;
import org.openmali.types.twodee.Rect2i;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLInfo;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.DisplayModeSelector;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.util.WindowClosingListener;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanvasPeer
implements InputSourceWindow {
    private Canvas3D canvas3D;
    private final RenderPeer renderPeer;
    private DisplayMode displayMode;
    private boolean isFullscreen;
    private final boolean isUndecorated;
    private Boolean fullscreenSwitchRequest = null;
    private boolean vsync;
    private FSAA fsaa;
    private int depthBufferSize;
    private Cursor cursor = Cursor.DEFAULT_CURSOR;
    private final Object renderLock = new Object();
    private final ArrayList<WindowClosingListener> closingListeners = new ArrayList();
    private boolean isClosingListenerRegistered = false;
    private OpenGLCapabilities openGLCapabilities = null;
    protected OpenGLInfo oglInfo = null;
    private long triangles = 0L;
    private float gamma = 1.0f;
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    protected boolean isGammaChanged = false;
    private Rect2i viewport = null;
    private static int nextCanvasID = 1;
    private static final HashSet<Integer> freedCanvasIDs = new HashSet();
    private final int canvasID;
    private boolean destroyed;
    private final HashSet<SceneGraphOpenGLReference> destroyableReferences = new HashSet();

    protected abstract RenderPeer createRenderPeer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CanvasPeer(DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        this.renderPeer = this.createRenderPeer();
        this.displayMode = this.checkDisplayMode(displayMode, this.getType());
        this.isFullscreen = fullscreen.isFullscreen();
        this.isUndecorated = fullscreen == DisplayMode.FullscreenMode.WINDOWED_UNDECORATED;
        this.vsync = vsync;
        this.fsaa = fsaa;
        this.depthBufferSize = depthBufferSize;
        CanvasPeer canvasPeer = this;
        synchronized (canvasPeer) {
            int newCanvasID = nextCanvasID++;
            for (int i = newCanvasID - 1; i >= 1; --i) {
                if (!freedCanvasIDs.contains(i)) continue;
                newCanvasID = i;
                freedCanvasIDs.remove(i);
                --nextCanvasID;
                break;
            }
            this.canvasID = newCanvasID;
        }
        this.destroyed = false;
    }

    public RenderPeer getRenderPeer() {
        return this.renderPeer;
    }

    protected void setCanvas3D(Canvas3D canvas) {
        this.canvas3D = canvas;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas3D;
    }

    public abstract OpenGLLayer getType();

    public final int getCanvasID() {
        return this.canvasID;
    }

    public final OpenGLInfo getOpenGLInfo() {
        return this.oglInfo;
    }

    public final Object getRenderLock() {
        return this.renderLock;
    }

    protected final Boolean getFullscreenSwitchRequest() {
        return this.fullscreenSwitchRequest;
    }

    protected final void resetFullscreenSwitchRequest() {
        this.fullscreenSwitchRequest = null;
    }

    public boolean setFullscreen(boolean fullscreen) {
        boolean oldState = this.isFullscreen;
        if (oldState == fullscreen) {
            return oldState;
        }
        this.fullscreenSwitchRequest = fullscreen;
        this.isFullscreen = fullscreen;
        return oldState;
    }

    public final boolean isFullscreen() {
        return this.isFullscreen;
    }

    public final boolean isUndecorated() {
        return this.isUndecorated;
    }

    protected abstract Class<?> getExpectedNativeDisplayModeClass();

    private final DisplayMode checkDisplayMode(DisplayMode displayMode, OpenGLLayer oglLayer) {
        if (displayMode == null) {
            throw new IllegalArgumentException("displayMode must not be null");
        }
        if ((displayMode.getNativeMode() == null || displayMode.getNativeMode().getClass() != this.getExpectedNativeDisplayModeClass()) && (displayMode = DisplayModeSelector.getImplementation(oglLayer).getBestMode(displayMode.getWidth(), displayMode.getHeight(), displayMode.getBPP(), displayMode.getFrequency())) == null) {
            throw new RuntimeException("No DisplayMode found!");
        }
        return displayMode;
    }

    protected abstract boolean setDisplayModeImpl(DisplayMode var1);

    protected final void setDisplayModeRef(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public final boolean setDisplayMode(DisplayMode displayMode) {
        boolean result = this.setDisplayModeImpl(displayMode = this.checkDisplayMode(displayMode, this.getType()));
        if (result) {
            this.setDisplayModeRef(displayMode);
        }
        return result;
    }

    public final DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public final int getBPP() {
        return this.displayMode.getBPP();
    }

    public final int getFrequency() {
        return this.displayMode.getFrequency();
    }

    public void setVSyncEnabled(boolean vsync) {
        this.vsync = vsync;
    }

    public final boolean isVSyncEnabled() {
        return this.vsync;
    }

    public final FSAA getFSAA() {
        return this.fsaa;
    }

    protected void setDepthBufferSize(int size) {
        this.depthBufferSize = size;
    }

    public final int getDepthBufferSize() {
        return this.depthBufferSize;
    }

    protected final boolean isClosingListenerRegistered() {
        return this.isClosingListenerRegistered;
    }

    protected void addWindowClosingListener(WindowClosingListener l) {
        this.closingListeners.add(l);
        this.isClosingListenerRegistered = true;
    }

    protected void removeWindowClosingListener(WindowClosingListener l) {
        this.closingListeners.remove(l);
        this.isClosingListenerRegistered = this.closingListeners.size() > 0;
    }

    protected void fireClosingEvent() {
        for (int i = 0; i < this.closingListeners.size(); ++i) {
            this.closingListeners.get(i).onWindowCloseRequested(this.canvas3D);
        }
    }

    protected final void setOpenGLCapabilities(OpenGLCapabilities caps) {
        this.openGLCapabilities = caps;
    }

    public final OpenGLCapabilities getOpenGLCapabilities() {
        return this.openGLCapabilities;
    }

    public final int getMaxTextureSize() {
        return this.openGLCapabilities.getMaxTextureSize();
    }

    public final int getMaxTextureUnits() {
        return this.openGLCapabilities.getMaxTextureUnits();
    }

    public final int getMaxVertexAttributes() {
        return this.openGLCapabilities.getMaxVertexAttributes();
    }

    public final void setTriangles(long num) {
        this.triangles = num;
    }

    public final void addTriangles(long num) {
        this.triangles += num;
    }

    public final long getTriangles() {
        return this.triangles;
    }

    public abstract long getRenderedFrames();

    public abstract Object getWindow();

    public abstract Object getComponent();

    public abstract void setIcon(URL var1) throws IOException;

    protected void setCursorImpl(Cursor cursor) {
        if (!InputSystem.hasInstance() || !InputSystem.getInstance().hasMouse()) {
            return;
        }
        InputSystem is = InputSystem.getInstance();
        int n = is.getMousesCount();
        for (int i = 0; i < n; ++i) {
            Mouse mouse = is.getMouse(i);
            if (mouse.getSourceWindow() != this) continue;
            this.refreshCursor(mouse);
        }
    }

    @Override
    public final void setCursor(Cursor cursor) {
        if (!(this.cursor != cursor || cursor != null && cursor.isDirty())) {
            return;
        }
        this.cursor = cursor;
        this.setCursorImpl(cursor);
    }

    @Override
    public final Cursor getCursor() {
        return this.cursor;
    }

    public abstract void setTitle(String var1);

    public abstract String getTitle();

    public final InputDeviceFactory getInputDeviceFactory() {
        return this.getInputDeviceFactory(InputSystem.getInstance());
    }

    public abstract boolean setLocation(int var1, int var2);

    public abstract int getLeft();

    public abstract int getTop();

    public abstract boolean setSize(int var1, int var2);

    @Override
    public abstract int getWidth();

    @Override
    public abstract int getHeight();

    public abstract Rect2i getMaxViewport();

    public void setViewport(Rect2i viewport) {
        this.viewport = viewport;
    }

    public Rect2i getViewport() {
        return this.viewport;
    }

    public void setGamma(float gamma, float brightness, float contrast) {
        if (brightness < -1.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("brightness must be in range [-1.0, +1.0]");
        }
        if (contrast < 0.0f || contrast > 1.0f) {
            throw new IllegalArgumentException("contrast must be in range [0.0, +1.0]");
        }
        this.gamma = gamma;
        this.brightness = brightness;
        this.contrast = contrast;
        this.isGammaChanged = true;
    }

    public float getGamma() {
        return this.gamma;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getContrast() {
        return this.contrast;
    }

    public abstract boolean isRendering();

    public abstract void beforeThreadChanged();

    protected abstract Object initRenderingImpl(View var1, List<RenderPass> var2, boolean var3, long var4, long var6, long var8, PickRequest var10);

    public abstract void clear();

    public final boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDestroyableObject(SceneGraphOpenGLReference ref) {
        HashSet<SceneGraphOpenGLReference> hashSet = this.destroyableReferences;
        synchronized (hashSet) {
            this.destroyableReferences.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyGLNames(boolean onlyGCed) {
        if (!onlyGCed) {
            SceneGraphOpenGLReferences.destroyObjects(this);
        }
        if (this.destroyableReferences.size() > 0) {
            HashSet<SceneGraphOpenGLReference> hashSet = this.destroyableReferences;
            synchronized (hashSet) {
                for (SceneGraphOpenGLReference ref : this.destroyableReferences) {
                    ref.destroyObject();
                }
                this.destroyableReferences.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!this.isDestroyed()) {
            CanvasPeer canvasPeer = this;
            synchronized (canvasPeer) {
                this.setCursor(Cursor.DEFAULT_CURSOR);
                if (InputSystem.hasInstance()) {
                    try {
                        InputSystem.getInstance().destroy(this);
                    }
                    catch (InputSystemException e) {
                        e.printStackTrace();
                        X3DLog.print(e);
                    }
                }
                this.destroyGLNames(false);
                this.destroyed = true;
                freedCanvasIDs.add(this.getCanvasID());
            }
        }
    }

    private final File getNewScreenshotFilename(String filenameBase, boolean forceOverwrite) {
        String postfix = filenameBase.endsWith(".png") ? "" : ".png";
        File file = new File(filenameBase + postfix);
        while (!forceOverwrite && file.exists()) {
            file = new File(filenameBase + new SimpleDateFormat("_yyyy-MM-dd-HHmmss").format(new GregorianCalendar().getTime()) + postfix);
        }
        return file;
    }

    public void takeScreenshot(File file, boolean alpha) {
        this.getRenderPeer().takeScreenshot(file, alpha);
    }

    public final File takeScreenshot(String filenameBase, boolean alpha) {
        File file = filenameBase.endsWith(".png") ? this.getNewScreenshotFilename(filenameBase, true) : this.getNewScreenshotFilename(filenameBase, false);
        this.takeScreenshot(file, alpha);
        return file;
    }

    public final File takeScreenshot(boolean alpha) {
        return this.takeScreenshot("screenshot", alpha);
    }
}

