/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Point3f;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRequest;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.Renderer;
import org.xith3d.render.ScenegraphModificationsManager;
import org.xith3d.render.preprocessing.FrustumCuller;
import org.xith3d.render.preprocessing.sorting.FrontToBackRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.OrderedStateRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRenderer
extends Renderer {
    private static final FrontToBackRenderBinSorter frontToBackSorter = new FrontToBackRenderBinSorter();
    private RenderBinSorter opaqueRenderBinSorter = new OrderedStateRenderBinSorter();
    private RenderBinSorter transparentRenderBinSorter = new FrontToBackRenderBinSorter();
    private Renderer.OpaqueSortingPolicy opaqueSortingPolicy = Renderer.OpaqueSortingPolicy.SORT_BY_STATES;
    private Renderer.TransparentSortingPolicy transparentSortingPolicy = Renderer.TransparentSortingPolicy.SORT_FRONT_TO_BACK;
    private final FrustumCuller frustumCuller;
    private final ScenegraphModificationsManager modManager;
    private final ArrayList<ScenegraphModificationsListener> modListeners;
    private final ArrayList<Canvas3D> canvasList;
    private final ArrayList<RenderTarget> renderTargets;
    private final HashMap<RenderTarget, RenderPass> renderTargetRenderPassMap = new HashMap();
    private final ArrayList<RenderPass> renderPasses;
    private final ArrayList<RenderPass> tmpRenderPasses;
    private final ArrayList<RenderPass> tmpRenderPasses2;
    private final ArrayList<RenderPass> effectiveRenderPasses;
    private final ArrayList<ArrayList<GroupNode>> tmpGroupsListsLists;
    private final ArrayList<GroupNode> tmpGroupList;
    private boolean layeredMode = false;
    private Point3f viewPosition2 = new Point3f();
    private List<PickRequest> pickRequests;
    private boolean recullForced = false;
    private long frameId = 0L;
    private volatile boolean isRendering;
    private long shapesRendered = 0L;
    private long trianglesRendered = 0L;

    @Override
    public final SoundProcessor getSoundProcessor() {
        return SoundProcessor.getInstance();
    }

    public ScenegraphModificationsManager getScenegraphModificationsManager() {
        return this.modManager;
    }

    @Override
    public void addScenegraphModificationListener(ScenegraphModificationsListener modListener) {
        this.modListeners.add(modListener);
    }

    @Override
    public void removeScenegraphModificationListener(ScenegraphModificationsListener modListener) {
        this.modListeners.remove(modListener);
    }

    @Override
    public List<ScenegraphModificationsListener> getScenegraphModificationListeners() {
        return this.modListeners;
    }

    @Override
    protected final void addCanvas3D(Canvas3D canvas) {
        this.canvasList.add(canvas);
        canvas.setRenderer(this);
    }

    @Override
    protected final void removeCanvas3D(Canvas3D canvas) {
        this.canvasList.remove(canvas);
        canvas.setRenderer(null);
    }

    @Override
    protected final Canvas3D removeCanvas3D(int i) {
        Canvas3D canvas = this.canvasList.remove(i);
        canvas.setRenderer(null);
        return canvas;
    }

    @Override
    public final int getNumberOfCanvas3Ds() {
        return this.canvasList.size();
    }

    @Override
    public final Canvas3D getCanvas3D(int index) {
        return this.canvasList.get(index);
    }

    @Override
    public final void addRenderTarget(RenderTarget renderTarget, RenderPass renderPass) {
        this.renderTargets.add(renderTarget);
        renderPass.setRenderTarget(renderTarget);
        this.renderTargetRenderPassMap.put(renderTarget, renderPass);
    }

    @Override
    public final RenderPass addRenderTarget(RenderTarget renderTarget, RenderPassConfig passConfig) {
        RenderPass pass = new RenderPass(passConfig);
        this.addRenderTarget(renderTarget, pass);
        return pass;
    }

    @Override
    public final void removeRenderTarget(RenderTarget renderTarget) {
        this.renderTargets.remove(renderTarget);
        this.renderTargetRenderPassMap.remove(renderTarget);
    }

    @Override
    public List<RenderTarget> getRenderTargets() {
        return this.renderTargets;
    }

    @Override
    protected final RenderPass addRenderPass(RenderPass renderPass) {
        if (renderPass == null) {
            throw new IllegalArgumentException("renderPass must not be null.");
        }
        this.renderPasses.add(renderPass);
        return renderPass;
    }

    @Override
    protected final RenderPass addRenderPass(int index, RenderPass renderPass) {
        if (renderPass == null) {
            throw new IllegalArgumentException("renderPass must not be null.");
        }
        this.renderPasses.add(index, renderPass);
        return renderPass;
    }

    @Override
    protected final boolean removeRenderPasses(BranchGroup branchGroup) {
        List<RenderPass> passes = this.getRenderPasses(branchGroup);
        int n = 0;
        for (int i = 0; i < passes.size(); ++i) {
            if (!this.renderPasses.remove(passes.get(i))) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    protected final boolean removeRenderPass(RenderPass renderPass) {
        return this.removeRenderPasses(renderPass.getBranchGroup());
    }

    @Override
    protected final boolean removeRenderPass(int index) {
        RenderPass removedPass = this.renderPasses.remove(index);
        return removedPass != null;
    }

    @Override
    protected void removeAllRenderPasses() {
        this.renderPasses.clear();
    }

    @Override
    public final int getRenderPassesCount() {
        return this.renderPasses.size();
    }

    @Override
    public final List<RenderPass> getRenderPasses(BranchGroup branchGroup) {
        this.tmpRenderPasses2.clear();
        for (int i = 0; i < this.renderPasses.size(); ++i) {
            RenderPass rp = this.renderPasses.get(i);
            if (rp.getBranchGroup() != branchGroup) continue;
            this.tmpRenderPasses2.add(rp);
        }
        return this.tmpRenderPasses2;
    }

    @Override
    public final RenderPass getRenderPass(int index) {
        return this.renderPasses.get(index);
    }

    @Override
    public final List<RenderPass> getRenderPasses() {
        return this.renderPasses;
    }

    @Override
    public final void setLayeredMode(boolean layeredMode) {
        this.layeredMode = layeredMode;
    }

    @Override
    public final boolean isLayeredMode() {
        return this.layeredMode;
    }

    @Override
    public final void setOpaqueSorter(RenderBinSorter sorter) {
        this.opaqueRenderBinSorter = sorter;
        this.opaqueSortingPolicy = Renderer.OpaqueSortingPolicy.CUSTOM;
    }

    @Override
    public final RenderBinSorter getOpaqueSorter() {
        return this.opaqueRenderBinSorter;
    }

    @Override
    public final void setTransparentSorter(RenderBinSorter sorter) {
        this.transparentRenderBinSorter = sorter;
        this.transparentSortingPolicy = Renderer.TransparentSortingPolicy.CUSTOM;
    }

    @Override
    public final RenderBinSorter getTransparentSorter() {
        return this.transparentRenderBinSorter;
    }

    @Override
    public final void setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy policy) {
        this.opaqueRenderBinSorter = policy.getSorter();
        this.opaqueSortingPolicy = policy;
    }

    @Override
    public final Renderer.OpaqueSortingPolicy getOpaqueSortingPolicy() {
        return this.opaqueSortingPolicy;
    }

    @Override
    public final void setTransparentSortingPolicy(Renderer.TransparentSortingPolicy policy) {
        this.transparentRenderBinSorter = policy.getSorter();
        this.transparentSortingPolicy = policy;
    }

    @Override
    public final Renderer.TransparentSortingPolicy getTransparentSortingPolicy() {
        return this.transparentSortingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPickRequest(PickRequest pickRequest) {
        List<PickRequest> list = this.pickRequests;
        synchronized (list) {
            this.pickRequests.add(pickRequest);
        }
    }

    private final void sortAllAtoms(RenderPass pass, Transform3D viewTransform) {
        RenderBinSorter transparentSorter;
        RenderBinSorter opaqueSorter;
        RenderPassConfig passConfig = pass.getConfig();
        if (passConfig != null) {
            opaqueSorter = passConfig.getOpaqueSorter();
            transparentSorter = passConfig.getTransparentSorter();
            if (passConfig.getOpaqueSortingPolicy() == null) {
                opaqueSorter = this.getOpaqueSorter();
            }
            if (passConfig.getTransparentSortingPolicy() == null) {
                transparentSorter = this.getTransparentSorter();
            }
        } else {
            opaqueSorter = this.getOpaqueSorter();
            transparentSorter = this.getTransparentSorter();
        }
        pass.getRenderBinProvider().sortAllAtoms(opaqueSorter, transparentSorter, viewTransform);
    }

    protected Object doRender(List<RenderPass> renderPasses, Canvas3D canvas, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        while (canvas.getPeer().isRendering()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return canvas.getPeer().initRenderingImpl(canvas.getView(), renderPasses, this.layeredMode, frameId, nanoTime, nanoStep, pickRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object renderOnceInternal(List<RenderPass> renderPasses, List<? extends List<GroupNode>> groupLists, Canvas3D canvas, long nanoTime, long nanoStep, PickRequest pickRequest) {
        Object object = canvas.getPeer().getRenderLock();
        synchronized (object) {
            RenderPass renderPass;
            int i;
            int i2;
            ++this.frameId;
            canvas.checkForResized();
            X3DLog.println("\nSTARTING FRAME\n");
            this.shapesRendered = 0L;
            this.trianglesRendered = 0L;
            this.isRendering = true;
            OpenGLCapabilities glCaps = canvas.getPeer().getOpenGLCapabilities();
            ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "Renderer:renderOnce");
            if (groupLists != null && this.modManager.hasAnythingChanged()) {
                for (i2 = 0; i2 < groupLists.size(); ++i2) {
                    List<GroupNode> groups = groupLists.get(i2);
                    for (int j = 0; j < groups.size(); ++j) {
                        GroupNode group = groups.get(j);
                        group.setModListener(this.modManager);
                    }
                }
            } else if (renderPasses != null && this.modManager.hasAnythingChanged()) {
                for (i2 = 0; i2 < renderPasses.size(); ++i2) {
                    RenderPass renderPass2 = renderPasses.get(i2);
                    BranchGroup bg = renderPass2.getBranchGroup();
                    bg.setModListener(this.modManager);
                }
            }
            Point3f viewPosition = canvas.getView().getPosition();
            List<RenderPass> rps = renderPasses;
            if (pickRequest == null) {
                if (this.renderTargets.size() > 0) {
                    this.effectiveRenderPasses.clear();
                    for (i = 0; i < this.renderTargets.size(); ++i) {
                        Point3f viewPos;
                        RenderTarget renderTarget = this.renderTargets.get(i);
                        RenderPass renderPass3 = this.renderTargetRenderPassMap.get(renderTarget);
                        renderPass3.getRenderCallbackNotifier().notifyBeforeRenderPassIsProcessed(renderPass3);
                        if (renderPass3.getConfig().getViewTransform() == null) {
                            viewPos = viewPosition;
                        } else {
                            renderPass3.getConfig().getViewTransform().getTranslation(this.viewPosition2);
                            viewPos = this.viewPosition2;
                        }
                        this.frustumCuller.cullAtoms(renderPass3, renderTarget.getGroup(), canvas, viewPos, glCaps, this.frameId, nanoTime, nanoStep, null);
                        this.effectiveRenderPasses.add(renderPass3);
                        renderPass3.getRenderCallbackNotifier().notifyAfterRenderPassIsProcessed(renderPass3);
                    }
                    for (int j = 0; j < renderPasses.size(); ++j) {
                        this.effectiveRenderPasses.add(renderPasses.get(j));
                    }
                    rps = this.effectiveRenderPasses;
                }
                this.shapesRendered = this.frustumCuller.cullAtoms(renderPasses, groupLists, canvas, glCaps, this.frameId, nanoTime, nanoStep, null);
                this.trianglesRendered = canvas.getPeer().getTriangles();
                for (i = 0; i < rps.size(); ++i) {
                    renderPass = rps.get(i);
                    Transform3D viewTransform = renderPass.getConfig().getViewTransform() == null ? canvas.getView().getTransform() : renderPass.getConfig().getViewTransform();
                    this.sortAllAtoms(renderPass, viewTransform);
                }
                this.modManager.resetAnythingChanged();
                _SG_PrivilegedAccess.setChanged(canvas.getView().getTransform(), false);
                this.recullForced = false;
            } else if (this.modManager.hasAnythingChanged() || canvas.getView().getTransform().isChanged() || this.recullForced) {
                this.frustumCuller.cullAtoms(null, null, canvas, viewPosition, glCaps, this.frameId, nanoTime, nanoStep, pickRequest);
                for (i = 0; i < pickRequest.getRenderPasses().size(); ++i) {
                    renderPass = pickRequest.getRenderPasses().get(i);
                    renderPass.getRenderCallbackNotifier().notifyBeforeRenderPassIsProcessed(renderPass);
                    Transform3D viewTransform = renderPass.getConfig().getViewTransform() == null ? canvas.getView().getTransform() : renderPass.getConfig().getViewTransform();
                    renderPass.getRenderBinProvider().sortAllAtoms(frontToBackSorter, frontToBackSorter, viewTransform);
                    renderPass.getRenderCallbackNotifier().notifyAfterRenderPassIsProcessed(renderPass);
                }
            }
            Object result = pickRequest == null ? this.doRender(rps, canvas, this.frameId, nanoTime, nanoStep, pickRequest) : this.doRender(pickRequest.getRenderPasses(), canvas, this.frameId, nanoTime, nanoStep, pickRequest);
            ProfileTimer.endProfile();
            this.isRendering = false;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long performPickings(Canvas3D canvas, long nanoTime, long nanoStep) {
        List<PickRequest> list = this.pickRequests;
        synchronized (list) {
            for (int i = 0; i < this.pickRequests.size(); ++i) {
                long t0 = System.nanoTime();
                PickRequest pickRequest = this.pickRequests.get(i);
                Object resultObj = this.renderOnceInternal(null, null, canvas, nanoTime, nanoStep, pickRequest);
                long dt = System.nanoTime() - t0;
                long dtm = dt / 1000000L;
                if (pickRequest.getPickAll()) {
                    List results = (List)resultObj;
                    if (results == null || results.size() == 0) {
                        pickRequest.getAllPickListener().onPickingMissed(pickRequest.getUserObject(), dtm);
                    } else {
                        pickRequest.getAllPickListener().onObjectsPicked(results, pickRequest.getUserObject(), dtm);
                    }
                } else {
                    PickResult result = (PickResult)resultObj;
                    if (result == null) {
                        pickRequest.getNearestPickListener().onPickingMissed(pickRequest.getUserObject(), dtm);
                    } else {
                        pickRequest.getNearestPickListener().onObjectPicked(result, pickRequest.getUserObject(), dtm);
                    }
                }
                PickPool.deallocatePickRequest(pickRequest);
            }
            this.pickRequests.clear();
            this.recullForced = true;
        }
        return this.frameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long renderOnce(List<RenderPass> renderPasses, List<? extends List<GroupNode>> groupsLists, Canvas3D canvas, long nanoTime, long nanoStep) {
        DefaultRenderer defaultRenderer = this;
        synchronized (defaultRenderer) {
            if (!this.pickRequests.isEmpty()) {
                this.performPickings(canvas, nanoTime, nanoStep);
            }
            this.renderOnceInternal(renderPasses, groupsLists, canvas, nanoTime, nanoStep, null);
        }
        return this.frameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long renderOnce(RenderPass renderPass, GroupNode group, Canvas3D canvas, long nanoTime, long nanoStep) {
        DefaultRenderer defaultRenderer = this;
        synchronized (defaultRenderer) {
            if (!this.pickRequests.isEmpty()) {
                this.performPickings(canvas, nanoTime, nanoStep);
            }
            this.tmpRenderPasses.clear();
            this.tmpRenderPasses.add(renderPass);
            if (group == null) {
                this.renderOnceInternal(this.tmpRenderPasses, null, canvas, nanoTime, nanoStep, null);
            } else {
                this.tmpGroupsListsLists.clear();
                this.tmpGroupList.clear();
                this.tmpGroupList.add(group);
                this.tmpGroupsListsLists.add(this.tmpGroupList);
                this.renderOnceInternal(this.tmpRenderPasses, this.tmpGroupsListsLists, canvas, nanoTime, nanoStep, null);
            }
        }
        return this.frameId;
    }

    @Override
    public final long renderOnce(RenderPass renderPass, Canvas3D canvas, long nanoTime, long nanoStep) {
        return this.renderOnce(renderPass, null, canvas, nanoTime, nanoStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long renderOnce(Canvas3D canvas, long nanoTime, long nanoStep) {
        DefaultRenderer defaultRenderer = this;
        synchronized (defaultRenderer) {
            if (!this.pickRequests.isEmpty()) {
                this.performPickings(canvas, nanoTime, nanoStep);
            }
            this.renderOnceInternal(this.renderPasses, null, canvas, nanoTime, nanoStep, null);
        }
        return this.frameId;
    }

    @Override
    public final long renderOnce(View view, long nanoTime, long nanoStep) {
        int n = view.getCanvas3Ds().size();
        for (int i = 0; i < n; ++i) {
            this.renderOnce(view.getCanvas3D(i), nanoTime, nanoStep);
        }
        return this.frameId;
    }

    @Override
    public final long renderOnce(RenderPass renderPass, GroupNode group, long nanoTime, long nanoStep) {
        SceneGraph sg = group == null ? renderPass.getBranchGroup().getSceneGraph() : group.getRoot().getSceneGraph();
        int nv = sg.getNumberOfViews();
        for (int i = 0; i < nv; ++i) {
            this.renderOnce(sg.getView(i), nanoTime, nanoStep);
        }
        return this.frameId;
    }

    @Override
    public final long renderOnce(RenderPass renderPass, long nanoTime, long nanoStep) {
        SceneGraph sg = renderPass.getBranchGroup().getSceneGraph();
        int nv = sg.getNumberOfViews();
        for (int i = 0; i < nv; ++i) {
            this.renderOnce(sg.getView(i), nanoTime, nanoStep);
        }
        return this.frameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long renderOnce(long nanoTime, long nanoStep) {
        DefaultRenderer defaultRenderer = this;
        synchronized (defaultRenderer) {
            Canvas3D firstCanvas = this.canvasList.get(0);
            if (!this.pickRequests.isEmpty()) {
                this.performPickings(firstCanvas, nanoTime, nanoStep);
            }
            int nc = this.canvasList.size();
            for (int i = 0; i < nc; ++i) {
                this.renderOnceInternal(this.renderPasses, null, this.canvasList.get(i), nanoTime, nanoStep, null);
            }
        }
        return this.frameId;
    }

    @Override
    public long getLastFrameId() {
        return this.frameId;
    }

    @Override
    public final long getNumRenderedShapes() {
        return this.shapesRendered;
    }

    @Override
    public final long getNumRenderedTriangles() {
        return this.trianglesRendered;
    }

    @Override
    public boolean isRendering() {
        return this.isRendering;
    }

    public DefaultRenderer() {
        this.frustumCuller = new FrustumCuller();
        this.modManager = new ScenegraphModificationsManager(this);
        this.modListeners = new ArrayList(1);
        this.canvasList = new ArrayList();
        this.renderTargets = new ArrayList();
        this.renderPasses = new ArrayList();
        this.tmpRenderPasses = new ArrayList();
        this.tmpRenderPasses2 = new ArrayList();
        this.effectiveRenderPasses = new ArrayList();
        this.tmpGroupsListsLists = new ArrayList();
        this.tmpGroupList = new ArrayList(1);
        this.pickRequests = new ArrayList<PickRequest>();
    }
}

