/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.xith3d.render.Canvas3DPanel;
import org.xith3d.render.config.OpenGLLayer;

public class FourViewsPanel
extends JPanel {
    private static final long serialVersionUID = 1041045431655033959L;
    private JSplitPane northSP;
    private JSplitPane southSP;
    private JSplitPane northSouthSP;
    private Canvas3DPanel nw;
    private Canvas3DPanel ne;
    private Canvas3DPanel sw;
    private Canvas3DPanel se;

    public Canvas3DPanel getNWPanel() {
        return this.nw;
    }

    public void setNWPanel(Canvas3DPanel c3dp) {
        this.nw = c3dp;
    }

    public Canvas3DPanel getNEPanel() {
        return this.ne;
    }

    public void setNEPanel(Canvas3DPanel c3dp) {
        this.ne = c3dp;
    }

    public Canvas3DPanel getSWPanel() {
        return this.sw;
    }

    public void setSWPanel(Canvas3DPanel c3dp) {
        this.sw = c3dp;
    }

    public Canvas3DPanel getSEPanel() {
        return this.se;
    }

    public void setSEPanel(Canvas3DPanel c3dp) {
        this.se = c3dp;
    }

    public void setHorizontalDividerPos(int pos) {
        this.northSP.setDividerLocation(pos);
        this.southSP.setDividerLocation(pos);
    }

    public int getHorizontalDividerPos() {
        return this.northSP.getDividerLocation();
    }

    public void setVerticalDividerPos(int pos) {
        this.northSouthSP.setDividerLocation(pos);
    }

    public int getVerticalDividerPos() {
        return this.northSouthSP.getDividerLocation();
    }

    public void setHorizontalResizeWeight(double value) {
        this.northSP.setResizeWeight(value);
        this.southSP.setResizeWeight(value);
    }

    public double getHorizontalResizeWeight() {
        return this.northSP.getResizeWeight();
    }

    public void setVerticalResizeWeight(double value) {
        this.northSouthSP.setResizeWeight(value);
    }

    public double getVerticalResizeWeight() {
        return this.northSouthSP.getResizeWeight();
    }

    public void setDividerSize(int newSize) {
        this.northSP.setDividerSize(newSize);
        this.southSP.setDividerSize(newSize);
        this.northSouthSP.setDividerSize(newSize);
    }

    public int getDividerSize() {
        return this.northSouthSP.getDividerSize();
    }

    public FourViewsPanel(Canvas3DPanel nw, Canvas3DPanel ne, Canvas3DPanel sw, Canvas3DPanel se) {
        super(new GridLayout(1, 1));
        this.setNWPanel(nw);
        this.setNEPanel(ne);
        this.setSWPanel(sw);
        this.setSEPanel(se);
        DividerSyncer ds = new DividerSyncer();
        this.northSP = new JSplitPane(1, this.getNWPanel(), this.getNEPanel());
        this.northSP.setContinuousLayout(true);
        this.northSP.setOneTouchExpandable(true);
        this.northSP.addPropertyChangeListener(ds);
        this.southSP = new JSplitPane(1, this.getSWPanel(), this.getSEPanel());
        this.southSP.setContinuousLayout(true);
        this.southSP.addPropertyChangeListener(ds);
        this.northSouthSP = new JSplitPane(0, this.northSP, this.southSP);
        this.northSouthSP.setContinuousLayout(true);
        this.northSouthSP.setOneTouchExpandable(true);
        if (!this.getNWPanel().isMinimumSizeSet()) {
            this.getNWPanel().setMinimumSize(new Dimension(0, 0));
        }
        if (!this.getNEPanel().isMinimumSizeSet()) {
            this.getNEPanel().setMinimumSize(new Dimension(0, 0));
        }
        if (!this.getSWPanel().isMinimumSizeSet()) {
            this.getSWPanel().setMinimumSize(new Dimension(0, 0));
        }
        if (!this.getSEPanel().isMinimumSizeSet()) {
            this.getSEPanel().setMinimumSize(new Dimension(0, 0));
        }
        this.setHorizontalResizeWeight(0.5);
        this.setVerticalResizeWeight(0.5);
        this.add((Component)this.northSouthSP, null);
    }

    public FourViewsPanel(OpenGLLayer layer) {
        this(new Canvas3DPanel(layer), new Canvas3DPanel(layer), new Canvas3DPanel(layer), new Canvas3DPanel(layer));
        this.getNWPanel().setWireframeMode(true);
        this.getNEPanel().setWireframeMode(true);
        this.getSWPanel().setWireframeMode(true);
        this.getSEPanel().setWireframeMode(false);
    }

    public FourViewsPanel() {
        this(OpenGLLayer.getDefault().isJOGL() ? OpenGLLayer.JOGL_AWT : OpenGLLayer.LWJGL_AWT);
    }

    private class DividerSyncer
    implements PropertyChangeListener {
        private DividerSyncer() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("lastDividerLocation")) {
                if (evt.getSource() == FourViewsPanel.this.northSP) {
                    FourViewsPanel.this.southSP.setDividerLocation(FourViewsPanel.this.northSP.getDividerLocation());
                } else if (evt.getSource() == FourViewsPanel.this.southSP) {
                    FourViewsPanel.this.northSP.setDividerLocation(FourViewsPanel.this.southSP.getDividerLocation());
                }
            }
        }
    }
}

