/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.Arrays;

public class OpenGLInfo {
    public static final int NORM_VERSION_1_1 = OpenGLInfo.composeNormalizedVersion(1, 1, 0);
    public static final int NORM_VERSION_1_2 = OpenGLInfo.composeNormalizedVersion(1, 2, 0);
    public static final int NORM_VERSION_1_3 = OpenGLInfo.composeNormalizedVersion(1, 3, 0);
    public static final int NORM_VERSION_1_4 = OpenGLInfo.composeNormalizedVersion(1, 4, 0);
    public static final int NORM_VERSION_1_5 = OpenGLInfo.composeNormalizedVersion(1, 5, 0);
    public static final int NORM_VERSION_2_0 = OpenGLInfo.composeNormalizedVersion(2, 0, 0);
    public static final int NORM_VERSION_2_1 = OpenGLInfo.composeNormalizedVersion(2, 1, 0);
    private final String RENDERER;
    private final String VERSION;
    private final int VERSION_MAJOR;
    private final int VERSION_MINOR;
    private final int VERSION_REVISION;
    private final int NORM_VERSION;
    private final String VENDOR;
    private final KnownVendor KNOWN_VENDOR;
    private final String[] EXTENSIONS;
    private final int[] EXT_HASHES;

    public final String getRenderer() {
        return this.RENDERER;
    }

    public final String getVersion() {
        return this.VERSION;
    }

    public final int getNormalizedVersion() {
        return this.NORM_VERSION;
    }

    public final int getVersionMajor() {
        return this.VERSION_MAJOR;
    }

    public final int getVersionMinor() {
        return this.VERSION_MINOR;
    }

    public final int getVersionRevision() {
        return this.VERSION_REVISION;
    }

    public final String getVendor() {
        return this.VENDOR;
    }

    public final KnownVendor getKnwonVendor() {
        return this.KNOWN_VENDOR;
    }

    public final String[] getExtensions() {
        return this.EXTENSIONS;
    }

    public final boolean hasExtension(String extension) {
        return Arrays.binarySearch(this.EXT_HASHES, extension.hashCode()) >= 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("OpenGL Renderer = ");
        buff.append(this.RENDERER);
        buff.append('\n');
        buff.append("OpenGL Version = ");
        buff.append(this.VERSION);
        buff.append('\n');
        buff.append("OpenGL Vendor = ");
        buff.append(this.VENDOR);
        buff.append('\n');
        buff.append("OpenGL Extensions =");
        for (int i = 0; i < this.EXTENSIONS.length; ++i) {
            buff.append(' ');
            buff.append(this.EXTENSIONS[i]);
        }
        return buff.toString();
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public void dumpExtensions() {
        System.out.println("OpenGL Extensions:");
        for (int i = 0; i < this.EXTENSIONS.length; ++i) {
            System.out.println(this.EXTENSIONS[i]);
        }
    }

    private static int composeNormalizedVersion(int major, int minor, int revision) {
        int normVersion = revision + minor * 10000 + major * 10000 * 100;
        return normVersion;
    }

    public OpenGLInfo(String renderer, String version, String vendor, String extensions) {
        this.RENDERER = renderer;
        this.VERSION = version;
        this.VENDOR = vendor;
        this.KNOWN_VENDOR = KnownVendor.getKnownVendor(vendor);
        this.EXTENSIONS = extensions.split(" ");
        int p = this.VERSION.indexOf(32);
        String[] ver = (p > -1 ? this.VERSION.substring(0, p) : this.VERSION).split("\\.");
        this.VERSION_MAJOR = Integer.parseInt(ver[0]);
        this.VERSION_MINOR = ver.length > 1 ? Integer.parseInt(ver[1]) : 0;
        this.VERSION_REVISION = ver.length > 2 ? Integer.parseInt(ver[2]) : 0;
        this.NORM_VERSION = OpenGLInfo.composeNormalizedVersion(this.VERSION_MAJOR, this.VERSION_MINOR, this.VERSION_REVISION);
        this.EXT_HASHES = new int[this.EXTENSIONS.length];
        for (int i = 0; i < this.EXTENSIONS.length; ++i) {
            this.EXT_HASHES[i] = this.EXTENSIONS[i].hashCode();
        }
        Arrays.sort(this.EXT_HASHES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KnownVendor {
        NVIDIA,
        ATI,
        INTEL,
        MESA;


        public static KnownVendor getKnownVendor(String vendor) {
            if (vendor.toLowerCase().contains("nvidia")) {
                return NVIDIA;
            }
            if (vendor.toLowerCase().contains("ati")) {
                return ATI;
            }
            if (vendor.toLowerCase().contains("intel")) {
                return INTEL;
            }
            if (vendor.toLowerCase().contains("mesa")) {
                return MESA;
            }
            return null;
        }
    }
}

