/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.ArrayList;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.config.OpenGLLayer;

public interface RenderCallback {
    public void beforeRenderPassIsProcessed(RenderPass var1);

    public void afterRenderPassIsProcessed(RenderPass var1);

    public void beforeRenderPassIsRendered(RenderPass var1, OpenGLLayer var2, Object var3);

    public void beforeRenderTargetIsActivated(RenderPass var1, RenderTarget var2, OpenGLLayer var3, Object var4);

    public void afterRenderTargetIsActivated(RenderPass var1, RenderTarget var2, OpenGLLayer var3, Object var4);

    public void afterRenderPassIsSetUp(RenderPass var1, OpenGLLayer var2, Object var3);

    public void beforeRenderTargetIsDeactivated(RenderPass var1, RenderTarget var2, OpenGLLayer var3, Object var4);

    public void afterRenderTargetIsDeactivated(RenderPass var1, RenderTarget var2, OpenGLLayer var3, Object var4);

    public void afterRenderPassCompleted(RenderPass var1, OpenGLLayer var2, Object var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RenderCallbackNotifier {
        private final ArrayList<RenderCallback> callbacks;

        public final void notifyBeforeRenderPassIsProcessed(RenderPass renderPass) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).beforeRenderPassIsProcessed(renderPass);
            }
        }

        public final void notifyAfterRenderPassIsProcessed(RenderPass renderPass) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).afterRenderPassIsProcessed(renderPass);
            }
        }

        public final void notifyBeforeRenderPassIsRendered(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).beforeRenderPassIsRendered(renderPass, openGLLayer, glObj);
            }
        }

        public final void notifyBeforeRenderTargetIsActivated(RenderPass renderPass, RenderTarget renderTarget, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).beforeRenderTargetIsActivated(renderPass, renderTarget, openGLLayer, glObj);
            }
        }

        public final void notifyAfterRenderTargetIsActivated(RenderPass renderPass, RenderTarget renderTarget, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).afterRenderTargetIsActivated(renderPass, renderTarget, openGLLayer, glObj);
            }
        }

        public final void notifyAfterRenderPassIsSetUp(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).afterRenderPassIsSetUp(renderPass, openGLLayer, glObj);
            }
        }

        public final void notifyBeforeRenderTargetIsDeactivated(RenderPass renderPass, RenderTarget renderTarget, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).beforeRenderTargetIsDeactivated(renderPass, renderTarget, openGLLayer, glObj);
            }
        }

        public final void notifyAfterRenderTargetIsDeactivated(RenderPass renderPass, RenderTarget renderTarget, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).afterRenderTargetIsDeactivated(renderPass, renderTarget, openGLLayer, glObj);
            }
        }

        public final void notifyAfterRenderPassCompleted(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
            for (int i = 0; i < this.callbacks.size(); ++i) {
                this.callbacks.get(i).afterRenderPassCompleted(renderPass, openGLLayer, glObj);
            }
        }

        public RenderCallbackNotifier(ArrayList<RenderCallback> callbacks) {
            this.callbacks = callbacks;
        }
    }
}

