/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.jagatoo.datatypes.NamableObject;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.RenderCallback;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.Renderer;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;

public class RenderPass
implements Enableable,
NamableObject {
    private RenderPassConfig config;
    private final RenderBinProvider binProvider;
    private BranchGroup branchGroup;
    private final ArrayList<RenderCallback> callbacks = new ArrayList(8);
    private final RenderCallback.RenderCallbackNotifier callbackNotifier = new RenderCallback.RenderCallbackNotifier(this.callbacks);
    private RenderTarget renderTarget = null;
    private boolean isClipperEnabled = true;
    private boolean isScissorEnabled = false;
    private boolean isFrustumCullingEnabled = true;
    private boolean isLayeredForced = false;
    private boolean isUnlayeredForced = false;
    private boolean isEnabled = true;
    private Light shadowCasterLight = null;
    private String name = "";

    public void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        if (branchGroup == null) {
            throw new IllegalArgumentException("branchGroup must not be null.");
        }
        this.branchGroup = branchGroup;
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public void setConfig(RenderPassConfig config) {
        this.config = config;
    }

    public RenderPassConfig getConfig() {
        return this.config;
    }

    public boolean switchWireframeMode() {
        return this.getConfig().getRenderOptions().switchWireframeMode();
    }

    public RenderBinProvider getRenderBinProvider() {
        return this.binProvider;
    }

    public final void addRenderCallback(RenderCallback callback) {
        this.callbacks.add(callback);
    }

    public final void removeRenderCallback(RenderCallback callback) {
        this.callbacks.remove(callback);
    }

    public final RenderCallback.RenderCallbackNotifier getRenderCallbackNotifier() {
        return this.callbackNotifier;
    }

    public void setRenderTarget(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public RenderTarget getRenderTarget() {
        return this.renderTarget;
    }

    public void setClipperEnabled(boolean enabled) {
        this.isClipperEnabled = enabled;
    }

    public boolean isClipperEnabled() {
        return this.isClipperEnabled;
    }

    public void setScissorEnabled(boolean enabled) {
        this.isScissorEnabled = enabled;
    }

    public boolean isScissorEnabled() {
        return this.isScissorEnabled;
    }

    public void setFrustumCullingEnabled(boolean enabled) {
        this.isFrustumCullingEnabled = enabled;
    }

    public boolean isFrustumCullingEnabled() {
        return this.isFrustumCullingEnabled;
    }

    public void setLayeredModeForced(boolean forced) {
        this.isLayeredForced = forced;
    }

    public boolean isLayeredModeForced() {
        return this.isLayeredForced;
    }

    public void setUnlayeredModeForced(boolean forced) {
        this.isUnlayeredForced = forced;
    }

    public boolean isUnlayeredModeForced() {
        return this.isUnlayeredForced;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setShadowCasterLight(Light light) {
        EffectFactory effFact = EffectFactory.getInstance();
        if (effFact == null) {
            throw new IllegalStateException("No EffectFactory found!");
        }
        ShadowFactory shadowFact = effFact.getShadowFactory();
        if (shadowFact == null) {
            throw new IllegalStateException("No ShadowFactory registered!");
        }
        shadowFact.verifyLight(light);
        this.shadowCasterLight = light;
    }

    public final Light getShadowCasterLight() {
        return this.shadowCasterLight;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.getBranchGroup() != null) {
            this.getBranchGroup().freeOpenGLResources(canvasPeer);
        }
    }

    public final void freeOpenGLResources(Canvas3D canvas) {
        if (canvas.getPeer() == null) {
            throw new Error("The given Canvas3D is not linked to a CanvasPeer.");
        }
        this.freeOpenGLResources(canvas.getPeer());
    }

    protected RenderBinProvider createRenderBinProvider() {
        return new RenderBinProvider();
    }

    public RenderPass(BranchGroup branchGroup, RenderPassConfig config) {
        if (branchGroup == null) {
            throw new IllegalArgumentException("branchGroup must not be null.");
        }
        this.branchGroup = branchGroup;
        this.config = config;
        this.binProvider = this.createRenderBinProvider();
    }

    public RenderPass(RenderPassConfig config) {
        this(new BranchGroup(), config);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(branchGroup, config);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(branchGroup, config);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(new BranchGroup(), config);
    }

    public static RenderPass createPerspective(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(new BranchGroup(), config);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createPerspective(branchGroup, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createPerspective(branchGroup, (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createPerspective(new BranchGroup(), cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createPerspective(float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createPerspective(new BranchGroup(), (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createPerspective(branchGroup, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createPerspective(branchGroup, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createPerspective(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createPerspective(float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createPerspective(new BranchGroup(), frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return RenderPass.createPerspective(branchGroup, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance) {
        return RenderPass.createPerspective(branchGroup, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return RenderPass.createPerspective(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(float frontClipDistance, float backClipDistance) {
        return RenderPass.createPerspective(new BranchGroup(), frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createPerspective(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createPerspective(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createPerspective(new BranchGroup(), cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createPerspective(new BranchGroup(), opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode) {
        return RenderPass.createPerspective(branchGroup, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(BranchGroup branchGroup) {
        return RenderPass.createPerspective(branchGroup, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective(View.CameraMode cameraMode) {
        return RenderPass.createPerspective(new BranchGroup(), cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createPerspective() {
        return RenderPass.createPerspective(new BranchGroup(), -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(branchGroup, config);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(branchGroup, config);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(new BranchGroup(), config);
    }

    public static RenderPass createParallel(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new RenderPass(new BranchGroup(), config);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createParallel(branchGroup, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createParallel(branchGroup, (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createParallel(float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return RenderPass.createParallel(new BranchGroup(), (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createParallel(branchGroup, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createParallel(branchGroup, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createParallel(float frontClipDistance, float backClipDistance, float screenScale) {
        return RenderPass.createParallel(new BranchGroup(), frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return RenderPass.createParallel(branchGroup, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance) {
        return RenderPass.createParallel(branchGroup, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(float frontClipDistance, float backClipDistance) {
        return RenderPass.createParallel(new BranchGroup(), frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createParallel(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createParallel(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return RenderPass.createParallel(new BranchGroup(), opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode) {
        return RenderPass.createParallel(branchGroup, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup) {
        return RenderPass.createParallel(branchGroup, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel() {
        return RenderPass.createParallel(new BranchGroup(), -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        Tuple2f centerOfView = moveCenterToUpperLeft ? new Tuple2f(-((float)screenWidth) / 2.0f, (float)screenHeight / 2.0f) : null;
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, (Renderer.OpaqueSortingPolicy)null, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, -9999.0f, -9999.0f, (float)screenWidth / 2.0f, -9999.0f);
        config.setCenterOfView(centerOfView);
        return new RenderPass(branchGroup, config);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(branchGroup, RenderPassConfig.DEFAULT_CAMERA_MODE, screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(branchGroup, cameraMode, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(BranchGroup branchGroup, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(branchGroup, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(new BranchGroup(), screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(View.CameraMode cameraMode, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(new BranchGroup(), cameraMode, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static RenderPass createParallel(Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return RenderPass.createParallel(new BranchGroup(), screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, int resolutionX, int resolutionY) {
        RenderPass pass = RenderPass.createParallel(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, (float)resolutionX / 2.0f, -9999.0f);
        RenderPassConfig passConfig = pass.getConfig();
        float zPos = frontClipDistance + (backClipDistance - frontClipDistance) / 2.0f;
        Transform3D viewTrans = new Transform3D();
        viewTrans.lookAlong(0.0f, 0.0f, zPos, 0.0f, 0.0f, -1.0f);
        passConfig.setViewTransform(viewTrans);
        passConfig.setCenterOfView(new Point2f((float)(-resolutionX) / 2.0f, (float)resolutionY / 2.0f));
        return pass;
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, int resolutionX, int resolutionY) {
        return RenderPass.create2D(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -1.0f, 1.0f, resolutionX, resolutionY);
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, int resolutionX, int resolutionY) {
        return RenderPass.create2D(branchGroup, cameraMode, Renderer.OpaqueSortingPolicy.SORT_BY_Z_VALUE, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, resolutionX, resolutionY);
    }

    public static RenderPass create2D(BranchGroup branchGroup, View.CameraMode cameraMode, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, cameraMode, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, int resolutionX, int resolutionY) {
        return RenderPass.create2D(branchGroup, RenderPassConfig.DEFAULT_CAMERA_MODE, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolutionX, resolutionY);
    }

    public static RenderPass create2D(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, int resolutionX, int resolutionY) {
        return RenderPass.create2D(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, -1.0f, 1.0f, resolutionX, resolutionY);
    }

    public static RenderPass create2D(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(BranchGroup branchGroup, int resolutionX, int resolutionY) {
        return RenderPass.create2D(branchGroup, Renderer.OpaqueSortingPolicy.SORT_BY_Z_VALUE, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, resolutionX, resolutionY);
    }

    public static RenderPass create2D(BranchGroup branchGroup, Sized2iRO resolution) {
        return RenderPass.create2D(branchGroup, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, int resolutionX, int resolutionY) {
        return RenderPass.create2D(new BranchGroup(), cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolutionX, resolutionY);
    }

    public static RenderPass create2D(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, Sized2iRO resolution) {
        return RenderPass.create2D(cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, int resolutionX, int resolutionY) {
        return RenderPass.create2D(cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -1.0f, 1.0f, resolutionX, resolutionY);
    }

    public static RenderPass create2D(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Sized2iRO resolution) {
        return RenderPass.create2D(cameraMode, opaqueSortingPolicy, transparentSortingPolicy, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(View.CameraMode cameraMode, int resolutionX, int resolutionY) {
        return RenderPass.create2D(cameraMode, Renderer.OpaqueSortingPolicy.SORT_BY_Z_VALUE, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, resolutionX, resolutionY);
    }

    public static RenderPass create2D(View.CameraMode cameraMode, Sized2iRO resolution) {
        return RenderPass.create2D(cameraMode, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, int resolutionX, int resolutionY) {
        return RenderPass.create2D(RenderPassConfig.DEFAULT_CAMERA_MODE, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolutionX, resolutionY);
    }

    public static RenderPass create2D(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, Sized2iRO resolution) {
        return RenderPass.create2D(opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, int resolutionX, int resolutionY) {
        return RenderPass.create2D(opaqueSortingPolicy, transparentSortingPolicy, -1.0f, 1.0f, resolutionX, resolutionY);
    }

    public static RenderPass create2D(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Sized2iRO resolution) {
        return RenderPass.create2D(opaqueSortingPolicy, transparentSortingPolicy, resolution.getWidth(), resolution.getHeight());
    }

    public static RenderPass create2D(int resolutionX, int resolutionY) {
        return RenderPass.create2D(Renderer.OpaqueSortingPolicy.SORT_BY_Z_VALUE, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, resolutionX, resolutionY);
    }

    public static RenderPass create2D(Sized2iRO resolution) {
        return RenderPass.create2D(resolution.getWidth(), resolution.getHeight());
    }
}

