/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.List;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.preprocessing.sorting.BackToFrontByBoundingSphereAndEyeRayIntersectionRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.FrontToBackRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.OrderedStateRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.render.preprocessing.sorting.StateRenderBinSorter;
import org.xith3d.render.preprocessing.sorting.ZValueRenderBinSorter;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;
import org.xith3d.sound.SoundProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Renderer {
    protected static int renderersWorking = 0;

    @Deprecated
    public abstract SoundProcessor getSoundProcessor();

    public abstract void addScenegraphModificationListener(ScenegraphModificationsListener var1);

    public abstract void removeScenegraphModificationListener(ScenegraphModificationsListener var1);

    public abstract List<ScenegraphModificationsListener> getScenegraphModificationListeners();

    protected abstract void addCanvas3D(Canvas3D var1);

    protected abstract void removeCanvas3D(Canvas3D var1);

    protected abstract Canvas3D removeCanvas3D(int var1);

    public abstract int getNumberOfCanvas3Ds();

    public abstract Canvas3D getCanvas3D(int var1);

    public abstract void addRenderTarget(RenderTarget var1, RenderPass var2);

    public abstract RenderPass addRenderTarget(RenderTarget var1, RenderPassConfig var2);

    public abstract void removeRenderTarget(RenderTarget var1);

    public abstract List<RenderTarget> getRenderTargets();

    protected abstract RenderPass addRenderPass(RenderPass var1);

    protected abstract RenderPass addRenderPass(int var1, RenderPass var2);

    protected abstract boolean removeRenderPasses(BranchGroup var1);

    protected abstract boolean removeRenderPass(RenderPass var1);

    protected abstract boolean removeRenderPass(int var1);

    protected abstract void removeAllRenderPasses();

    public abstract int getRenderPassesCount();

    public abstract List<RenderPass> getRenderPasses(BranchGroup var1);

    public abstract RenderPass getRenderPass(int var1);

    public abstract List<RenderPass> getRenderPasses();

    public abstract void setLayeredMode(boolean var1);

    public abstract boolean isLayeredMode();

    public abstract void setOpaqueSorter(RenderBinSorter var1);

    public abstract RenderBinSorter getOpaqueSorter();

    public abstract void setTransparentSorter(RenderBinSorter var1);

    public abstract RenderBinSorter getTransparentSorter();

    public abstract void setOpaqueSortingPolicy(OpaqueSortingPolicy var1);

    public abstract OpaqueSortingPolicy getOpaqueSortingPolicy();

    public abstract void setTransparentSortingPolicy(TransparentSortingPolicy var1);

    public abstract TransparentSortingPolicy getTransparentSortingPolicy();

    public abstract long getLastFrameId();

    protected abstract void addPickRequest(PickRequest var1);

    public abstract long renderOnce(List<RenderPass> var1, List<? extends List<GroupNode>> var2, Canvas3D var3, long var4, long var6);

    public abstract long renderOnce(RenderPass var1, GroupNode var2, Canvas3D var3, long var4, long var6);

    public abstract long renderOnce(RenderPass var1, Canvas3D var2, long var3, long var5);

    public abstract long renderOnce(Canvas3D var1, long var2, long var4);

    public abstract long renderOnce(View var1, long var2, long var4);

    public abstract long renderOnce(RenderPass var1, GroupNode var2, long var3, long var5);

    public abstract long renderOnce(RenderPass var1, long var2, long var4);

    public abstract long renderOnce(long var1, long var3);

    public abstract long getNumRenderedShapes();

    public abstract long getNumRenderedTriangles();

    public abstract boolean isRendering();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransparentSortingPolicy {
        SORT_NONE,
        SORT_FRONT_TO_BACK,
        SORT_BOUNDING_SPHERE_AND_EYE_RAY_INTERSECTION,
        SORT_BY_Z_VALUE,
        CUSTOM;


        public RenderBinSorter getSorter() {
            switch (this) {
                case SORT_NONE: {
                    return null;
                }
                case SORT_FRONT_TO_BACK: {
                    return new FrontToBackRenderBinSorter();
                }
                case SORT_BOUNDING_SPHERE_AND_EYE_RAY_INTERSECTION: {
                    return new BackToFrontByBoundingSphereAndEyeRayIntersectionRenderBinSorter();
                }
                case SORT_BY_Z_VALUE: {
                    return new ZValueRenderBinSorter();
                }
            }
            throw new IllegalArgumentException("No RenderBinSorter for " + (Object)((Object)this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpaqueSortingPolicy {
        SORT_NONE,
        SORT_BY_STATES,
        SORT_BY_STATES_ORDERED,
        SORT_FRONT_TO_BACK,
        SORT_BY_Z_VALUE,
        CUSTOM;


        public RenderBinSorter getSorter() {
            switch (this) {
                case SORT_NONE: {
                    return null;
                }
                case SORT_BY_STATES: {
                    return new StateRenderBinSorter();
                }
                case SORT_BY_STATES_ORDERED: {
                    return new OrderedStateRenderBinSorter();
                }
                case SORT_FRONT_TO_BACK: {
                    return new FrontToBackRenderBinSorter();
                }
                case SORT_BY_Z_VALUE: {
                    return new ZValueRenderBinSorter();
                }
            }
            throw new IllegalArgumentException("No RenderBinSorter for " + (Object)((Object)this));
        }
    }
}

