/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShaderProgram;
import org.xith3d.scenegraph.AssemblyShaderProgramContext;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

public class AssemblyShaderProgramStateUnitPeer {
    private static final IntBuffer tmpIntBuffer = BufferUtil.newIntBuffer(1);
    private static final IntBuffer handleBuffer = BufferUtil.newIntBuffer(1);
    private static SceneGraphOpenGLReferences.Provider shaderProgramNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL gl = ((CanvasPeerImplBase)this.getContext()).getGL();
                    tmpIntBuffer.clear();
                    tmpIntBuffer.put(name);
                    tmpIntBuffer.rewind();
                    gl.glDeleteProgramsARB(1, tmpIntBuffer);
                }
            };
        }
    };
    private static boolean ARB_shader_programs_supported = false;
    private static boolean checkedOnce = false;

    private static final void checkOnce(GL gl) {
        String extensions = gl.glGetString(7939);
        if (extensions.indexOf("GL_ARB_vertex_program") != -1 && extensions.indexOf("GL_ARB_fragment_program") != -1) {
            ARB_shader_programs_supported = true;
        }
        checkedOnce = true;
        if (!ARB_shader_programs_supported) {
            // empty if block
        }
    }

    protected static final boolean areARBShaderProgramsSupported(GL gl) {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce(gl);
        }
        return ARB_shader_programs_supported;
    }

    private static final void defineVertexProgram(GL gl, AssemblyVertexShader shaderProgram, SceneGraphOpenGLReference openGLRef) {
        handleBuffer.rewind();
        gl.glGenProgramsARB(1, handleBuffer);
        int spHandle = handleBuffer.get();
        openGLRef.setName(spHandle);
        gl.glBindProgramARB(34336, spHandle);
        gl.glProgramStringARB(34336, 34933, shaderProgram.getShaderCode().length(), shaderProgram.getShaderCode());
        String programErrorString = gl.glGetString(34932);
        handleBuffer.rewind();
        gl.glGetIntegerv(34379, handleBuffer);
        int errorPos = handleBuffer.get();
        if (errorPos != -1) {
            System.err.println("VP Error String:" + programErrorString);
        }
        X3DLog.debug("Binding Shader Program to handle ", spHandle);
    }

    private static final void defineFragmentProgram(GL gl, AssemblyFragmentShader shaderProgram, SceneGraphOpenGLReference openGLRef) {
        handleBuffer.clear();
        gl.glGenProgramsARB(1, handleBuffer);
        int spHandle = handleBuffer.get();
        openGLRef.setName(spHandle);
        gl.glBindProgramARB(34820, spHandle);
        gl.glProgramStringARB(34820, 34933, shaderProgram.getShaderCode().length(), shaderProgram.getShaderCode());
        String programErrorString = gl.glGetString(34932);
        IntBuffer errorPos = BufferUtil.newIntBuffer(1);
        gl.glGetIntegerv(34379, errorPos);
        if (errorPos.get() != -1) {
            System.err.println("FP Error String:" + programErrorString);
        }
        X3DLog.debug("Binding Shader Program to handle ", spHandle);
    }

    private static final void bindVertexProgram(GL gl, OpenGLStatesCache statesCache, AssemblyVertexShader shaderProgram, CanvasPeer canvasPeer) {
        int spHandle;
        SceneGraphOpenGLReference openGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        if (!statesCache.enabled || !statesCache.assemblyVertexShadersEnabled) {
            gl.glEnable(34336);
            statesCache.assemblyVertexShadersEnabled = true;
        }
        if ((spHandle = openGLRef.getName()) != -1 && _SG_PrivilegedAccess.isDirty(shaderProgram)) {
            handleBuffer.rewind();
            handleBuffer.put(spHandle);
            handleBuffer.rewind();
            gl.glDeleteProgramsARB(1, handleBuffer);
            _SG_PrivilegedAccess.setDirty(shaderProgram, false);
            spHandle = openGLRef.deleteName();
        }
        if (spHandle != -1) {
            X3DLog.debug("Already cached, so binding Shader Program");
            gl.glBindProgramARB(34336, spHandle);
        } else {
            AssemblyShaderProgramStateUnitPeer.defineVertexProgram(gl, shaderProgram, openGLRef);
        }
        Vector4f[] parameters = shaderProgram.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                gl.glProgramEnvParameter4fARB(34336, i, parameters[i].getX(), parameters[i].getY(), parameters[i].getZ(), parameters[i].getW());
            }
        }
    }

    private static final void bindFragmentProgram(GL gl, OpenGLStatesCache statesCache, AssemblyFragmentShader shaderProgram, CanvasPeer canvasPeer) {
        int spHandle;
        SceneGraphOpenGLReference openGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        if (!statesCache.enabled || !statesCache.assemblyFragmentShadersEnabled) {
            gl.glEnable(34820);
            statesCache.assemblyFragmentShadersEnabled = true;
        }
        if ((spHandle = openGLRef.getName()) != -1 && _SG_PrivilegedAccess.isDirty(shaderProgram)) {
            handleBuffer.clear();
            handleBuffer.put(spHandle);
            handleBuffer.rewind();
            gl.glDeleteProgramsARB(1, handleBuffer);
            _SG_PrivilegedAccess.setDirty(shaderProgram, false);
            spHandle = openGLRef.deleteName();
        }
        if (spHandle != -1) {
            X3DLog.debug("Already cached, so binding Shader Program");
            gl.glBindProgramARB(34820, spHandle);
        } else {
            AssemblyShaderProgramStateUnitPeer.defineFragmentProgram(gl, shaderProgram, openGLRef);
        }
        Vector4f[] parameters = shaderProgram.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                gl.glProgramEnvParameter4fARB(34820, i, parameters[i].getX(), parameters[i].getY(), parameters[i].getZ(), parameters[i].getW());
            }
        }
    }

    private static final void setVertexProgramState(GL gl, OpenGLStatesCache statesCache, AssemblyVertexShader shaderProgram, CanvasPeer canvasPeer) {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce(gl);
        }
        if (ARB_shader_programs_supported) {
            if (shaderProgram == null || !shaderProgram.isEnabled() || shaderProgram.getShaderCode() == null) {
                if (!statesCache.enabled || statesCache.assemblyVertexShadersEnabled) {
                    gl.glDisable(34336);
                    statesCache.assemblyVertexShadersEnabled = false;
                }
            } else {
                AssemblyShaderProgramStateUnitPeer.bindVertexProgram(gl, statesCache, shaderProgram, canvasPeer);
            }
        }
    }

    private static final void setFragmentProgramState(GL gl, OpenGLStatesCache statesCache, AssemblyFragmentShader shaderProgram, CanvasPeer canvasPeer) {
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce(gl);
        }
        if (ARB_shader_programs_supported) {
            if (shaderProgram == null || !shaderProgram.isEnabled() || shaderProgram.getShaderCode() == null) {
                if (!statesCache.enabled || statesCache.assemblyFragmentShadersEnabled) {
                    gl.glDisable(34820);
                    statesCache.assemblyFragmentShadersEnabled = false;
                }
            } else {
                AssemblyShaderProgramStateUnitPeer.bindFragmentProgram(gl, statesCache, shaderProgram, canvasPeer);
            }
        }
    }

    protected static final void disableAssemblyShaders(GL gl, OpenGLStatesCache statesCache) {
        if (statesCache.enabled && !statesCache.assemblyVertexShadersEnabled && !statesCache.assemblyFragmentShadersEnabled) {
            return;
        }
        if (!checkedOnce) {
            AssemblyShaderProgramStateUnitPeer.checkOnce(gl);
        }
        if (ARB_shader_programs_supported) {
            gl.glDisable(34336);
            gl.glDisable(34820);
        }
        statesCache.assemblyVertexShadersEnabled = false;
        statesCache.assemblyFragmentShadersEnabled = false;
    }

    public static final void apply(Object glObj, AssemblyShaderProgramContext shaderProgram, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, RenderPeer.RenderMode renderMode) {
        ProfileTimer.startProfile(X3DLog.LOG_CHANNEL, "ShaderProgramPeer::apply()");
        GL gl = (GL)glObj;
        if (renderMode == RenderPeer.RenderMode.NORMAL && shaderProgram.isEnabled()) {
            AssemblyShaderProgram program = (AssemblyShaderProgram)shaderProgram.getProgram();
            AssemblyVertexShader vertexProgram = null;
            if (program.getNumVertexShaders() > 0) {
                vertexProgram = (AssemblyVertexShader)program.getVertexShader(0);
            }
            AssemblyFragmentShader fragmentProgram = null;
            if (program.getNumFragmentShaders() > 0) {
                fragmentProgram = (AssemblyFragmentShader)program.getFragmentShader(0);
            }
            AssemblyShaderProgramStateUnitPeer.setVertexProgramState(gl, statesCache, vertexProgram, canvasPeer);
            AssemblyShaderProgramStateUnitPeer.setFragmentProgramState(gl, statesCache, fragmentProgram, canvasPeer);
        } else {
            AssemblyShaderProgramStateUnitPeer.disableAssemblyShaders(gl, statesCache);
        }
        ProfileTimer.endProfile();
    }
}

