/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.jsr231.AssemblyShaderProgramStateUnitPeer;
import org.xith3d.render.jsr231.GLSLShaderProgramStateUnitPeer;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.render.jsr231.TextureUnitStateUnitPeer;

public class OpenGLStatesCacheImpl
extends OpenGLStatesCache {
    private static final FloatBuffer floatBuffer = BufferUtil.newFloatBuffer(16);
    private static final ByteBuffer byteBuffer = BufferUtil.newByteBuffer(16);

    public final void update(Object glObj, OpenGLCapabilities glCaps) {
        GL gl = (GL)glObj;
        int oldSelectedServerTU = this.currentServerTextureUnit == -1 ? 0 : this.currentServerTextureUnit;
        int oldSelectedClientTU = this.currentClientTextureUnit == -1 ? 0 : this.currentClientTextureUnit;
        int texCoordArrayEnabledMask = 0;
        boolean[] texture1DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] texture2DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] texture3DEnabled = new boolean[glCaps.getMaxTextureUnits()];
        boolean[] textureCMEnabled = new boolean[glCaps.getMaxTextureUnits()];
        int[] texGenEnableMask = new int[glCaps.getMaxTextureUnits()];
        int maskValue = 1;
        for (int i = 0; i < glCaps.getMaxTextureUnits(); ++i) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(gl, i, this, true);
            if (gl.glIsEnabled(32888)) {
                texCoordArrayEnabledMask |= maskValue;
            }
            texture1DEnabled[i] = gl.glIsEnabled(3552);
            texture2DEnabled[i] = gl.glIsEnabled(3553);
            texture3DEnabled[i] = gl.glIsEnabled(32879);
            textureCMEnabled[i] = gl.glIsEnabled(34067);
            maskValue *= 2;
            texGenEnableMask[i] = 0;
            if (gl.glIsEnabled(3168)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 1;
            }
            if (gl.glIsEnabled(3169)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 2;
            }
            if (gl.glIsEnabled(3170)) {
                int n = i;
                texGenEnableMask[n] = texGenEnableMask[n] | 4;
            }
            if (!gl.glIsEnabled(3171)) continue;
            int n = i;
            texGenEnableMask[n] = texGenEnableMask[n] | 8;
        }
        TextureUnitStateUnitPeer.selectServerTextureUnit(gl, oldSelectedServerTU, this, true);
        ShapeAtomPeer.selectClientTextureUnit(gl, oldSelectedClientTU, this, true);
        long vertexAttribsEnableMask = 0L;
        if (OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES) {
            for (int i = 0; i < glCaps.getMaxVertexAttributes(); ++i) {
                gl.glDisableVertexAttribArray(i);
            }
        }
        byteBuffer.rewind();
        gl.glGetBooleanv(3107, byteBuffer);
        int colorWriteMask = 0;
        if (byteBuffer.get(0) == 1) {
            colorWriteMask |= 1;
        }
        if (byteBuffer.get(1) == 1) {
            colorWriteMask |= 2;
        }
        if (byteBuffer.get(2) == 1) {
            colorWriteMask |= 4;
        }
        if (byteBuffer.get(3) == 1) {
            colorWriteMask |= 8;
        }
        byteBuffer.rewind();
        gl.glGetBooleanv(2930, byteBuffer);
        boolean depthWriteMask = byteBuffer.get(0) == 1;
        int currentGLSLShaderProgram = GLSLShaderProgramStateUnitPeer.getCurrentShaderProgram(gl);
        boolean[] clipPlaneEnabled = new boolean[6];
        for (int i = 0; i < clipPlaneEnabled.length; ++i) {
            int glPlane = RenderPeerImpl.translateClipPlaneIndex(i);
            clipPlaneEnabled[i] = gl.glIsEnabled(glPlane);
        }
        float[] color = new float[4];
        floatBuffer.rewind();
        gl.glGetFloatv(2816, floatBuffer);
        color[0] = floatBuffer.get();
        color[1] = floatBuffer.get();
        color[2] = floatBuffer.get();
        color[3] = 1.0f - floatBuffer.get();
        boolean[] lightEnabled = new boolean[]{gl.glIsEnabled(16384), gl.glIsEnabled(16385), gl.glIsEnabled(16386), gl.glIsEnabled(16387), gl.glIsEnabled(16388), gl.glIsEnabled(16389), gl.glIsEnabled(16390), gl.glIsEnabled(16391)};
        this.update(gl.glIsEnabled(32884), gl.glIsEnabled(32885), gl.glIsEnabled(32886), texCoordArrayEnabledMask, texGenEnableMask, texture1DEnabled, texture2DEnabled, texture3DEnabled, textureCMEnabled, 0L, oldSelectedServerTU, oldSelectedClientTU, this.maxUsedVertexAttrib, colorWriteMask, depthWriteMask, AssemblyShaderProgramStateUnitPeer.areARBShaderProgramsSupported(gl) ? gl.glIsEnabled(34336) : false, AssemblyShaderProgramStateUnitPeer.areARBShaderProgramsSupported(gl) ? gl.glIsEnabled(34820) : false, currentGLSLShaderProgram, gl.glIsEnabled(2929), gl.glIsEnabled(3008), gl.glIsEnabled(2960), gl.glIsEnabled(3089), clipPlaneEnabled, gl.glIsEnabled(3042), gl.glIsEnabled(2832), gl.glIsEnabled(2852), gl.glIsEnabled(2848), gl.glIsEnabled(2881), gl.glIsEnabled(10753), gl.glIsEnabled(10754), gl.glIsEnabled(32823), gl.glIsEnabled(2884), gl.glIsEnabled(2977), gl.glIsEnabled(2903), gl.glIsEnabled(2896), lightEnabled, gl.glIsEnabled(2912), color);
    }
}

